/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.types.I16;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

public class I16Pointer
extends Pointer {
    public static final int SIZEOF = 2;
    public static final I16Pointer NULL = new I16Pointer(0L);

    protected I16Pointer(long address) {
        super(address);
    }

    public static I16Pointer cast(AbstractPointer pointer) {
        return I16Pointer.cast(pointer.getAddress());
    }

    public static I16Pointer cast(UDATA udata) {
        return I16Pointer.cast(udata.longValue());
    }

    public static I16Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new I16Pointer(address);
    }

    public I16 at(long index) throws CorruptDataException {
        return new I16(this.getShortAtOffset(index * 2L));
    }

    public I16 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public I16Pointer untag() {
        return this.untag(1L);
    }

    public I16Pointer untag(long mask) {
        return new I16Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public I16Pointer add(long count) {
        return new I16Pointer(this.address + 2L * count);
    }

    public I16Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public I16Pointer addOffset(long offset) {
        return new I16Pointer(this.address + offset);
    }

    public I16Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public I16Pointer sub(long count) {
        return new I16Pointer(this.address - 2L * count);
    }

    public I16Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public I16Pointer subOffset(long offset) {
        return new I16Pointer(this.address - offset);
    }

    public I16Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    protected long sizeOfBaseType() {
        return 2L;
    }
}

