/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm24.j9.DataType;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.I32Pointer;
import com.ibm.j9ddr.vm24.pointer.Pointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.types.I32;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.UDATA;

public class SelfRelativePointer
extends Pointer {
    public static final SelfRelativePointer NULL = new SelfRelativePointer(0L);
    public static final long SIZEOF = 4L;

    protected SelfRelativePointer(long address) {
        super(address);
    }

    public static SelfRelativePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new SelfRelativePointer(address);
    }

    public static SelfRelativePointer cast(UDATA address) {
        return SelfRelativePointer.cast(address.longValue());
    }

    public static SelfRelativePointer cast(AbstractPointer pointer) {
        return SelfRelativePointer.cast(pointer.address);
    }

    public SelfRelativePointer add(long count) {
        return new SelfRelativePointer(this.address + count * 4L);
    }

    public SelfRelativePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public SelfRelativePointer addOffset(long offset) {
        return new SelfRelativePointer(this.address + offset);
    }

    public SelfRelativePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public DataType at(long index) throws CorruptDataException {
        throw new UnsupportedOperationException();
    }

    public DataType at(Scalar index) throws CorruptDataException {
        throw new UnsupportedOperationException();
    }

    public SelfRelativePointer untag() {
        return this.untag(3L);
    }

    public SelfRelativePointer untag(long mask) {
        return new SelfRelativePointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public SelfRelativePointer sub(long count) {
        return new SelfRelativePointer(this.address - count * 4L);
    }

    public SelfRelativePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public SelfRelativePointer subOffset(long offset) {
        return new SelfRelativePointer(this.address - offset);
    }

    public SelfRelativePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public VoidPointer get() throws CorruptDataException {
        I32 offset = I32Pointer.cast(this).at(0L);
        if (offset.eq(0L)) {
            return VoidPointer.NULL;
        }
        return VoidPointer.cast(this.addOffset(offset));
    }

    protected long sizeOfBaseType() {
        return 4L;
    }
}

