/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.StructurePointer;
import com.ibm.j9ddr.vm24.pointer.U32Pointer;
import com.ibm.j9ddr.vm24.structure.J9ZipDataDescriptor;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;

@GeneratedPointerClass(structureClass=J9ZipDataDescriptor.class)
public class J9ZipDataDescriptorPointer
extends StructurePointer {
    public static final J9ZipDataDescriptorPointer NULL = new J9ZipDataDescriptorPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9ZipDataDescriptorPointer(long address) {
        super(address);
    }

    public static J9ZipDataDescriptorPointer cast(AbstractPointer structure) {
        return J9ZipDataDescriptorPointer.cast(structure.getAddress());
    }

    public static J9ZipDataDescriptorPointer cast(UDATA udata) {
        return J9ZipDataDescriptorPointer.cast(udata.longValue());
    }

    public static J9ZipDataDescriptorPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9ZipDataDescriptorPointer(address);
    }

    public J9ZipDataDescriptorPointer add(long count) {
        return J9ZipDataDescriptorPointer.cast(this.address + J9ZipDataDescriptor.SIZEOF * count);
    }

    public J9ZipDataDescriptorPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9ZipDataDescriptorPointer addOffset(long offset) {
        return J9ZipDataDescriptorPointer.cast(this.address + offset);
    }

    public J9ZipDataDescriptorPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9ZipDataDescriptorPointer sub(long count) {
        return J9ZipDataDescriptorPointer.cast(this.address - J9ZipDataDescriptor.SIZEOF * count);
    }

    public J9ZipDataDescriptorPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9ZipDataDescriptorPointer subOffset(long offset) {
        return J9ZipDataDescriptorPointer.cast(this.address - offset);
    }

    public J9ZipDataDescriptorPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9ZipDataDescriptorPointer untag(long mask) {
        return J9ZipDataDescriptorPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9ZipDataDescriptorPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9ZipDataDescriptor.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_compressedSizeOffset_", declaredType="U32")
    public U32 compressedSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9ZipDataDescriptor._compressedSizeOffset_));
    }

    public U32Pointer compressedSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9ZipDataDescriptor._compressedSizeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_crc32Offset_", declaredType="U32")
    public U32 crc32() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9ZipDataDescriptor._crc32Offset_));
    }

    public U32Pointer crc32EA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9ZipDataDescriptor._crc32Offset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_uncompressedSizeOffset_", declaredType="U32")
    public U32 uncompressedSize() throws CorruptDataException {
        return new U32(this.getIntAtOffset(J9ZipDataDescriptor._uncompressedSizeOffset_));
    }

    public U32Pointer uncompressedSizeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)J9ZipDataDescriptor._uncompressedSizeOffset_);
    }
}

