/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.pointer.helper;

import com.ibm.j9ddr.AddressedCorruptDataException;
import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm24.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm24.j9.walkers.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm24.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.UDATAPointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ArrayClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ITablePointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9ROMClassHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm24.structure.J9Class;
import com.ibm.j9ddr.vm24.structure.J9Consts;
import com.ibm.j9ddr.vm24.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm24.structure.J9Method;
import com.ibm.j9ddr.vm24.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm24.types.Scalar;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9ClassHelper {
    private static HashMap<Long, HashMap<String, J9ObjectFieldOffset>> classToFieldOffsetCacheMap = new HashMap();
    private static final int MAXIMUM_ARRAY_ARITY = 100;
    private static final Map<String, Character> TYPE_MAP = new HashMap<String, Character>();
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;

    public static boolean isArrayClass(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.romClass().modifiers().allBitsIn(J9Consts.J9_JAVA_CLASS_ARRAY);
    }

    public static String getName(J9ClassPointer clazz) throws CorruptDataException {
        return J9UTF8Helper.stringValue(clazz.romClass().className());
    }

    public static String getArrayName(J9ClassPointer clazz) throws CorruptDataException {
        J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
        StringBuilder name = new StringBuilder();
        int arity = 0;
        try {
            arity = arrayClass.arity().intValue();
        }
        catch (InvalidDataTypeException e) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Array arity larger than MAXINT");
        }
        if (arity > 100) {
            throw new AddressedCorruptDataException(arrayClass.getAddress(), "Very high arity " + arity + " from array class 0x" + Long.toHexString(arrayClass.getAddress()));
        }
        for (int i = 0; i < arity; ++i) {
            name.append('[');
        }
        String elementClassName = J9ClassHelper.getName(arrayClass.leafComponentType());
        Character type2 = TYPE_MAP.get(elementClassName);
        if (type2 != null) {
            name.append(type2);
        } else {
            name.append('L');
            name.append(elementClassName);
            name.append(";");
        }
        return name.toString();
    }

    public static String getJavaName(J9ClassPointer clazz) throws CorruptDataException {
        String baseName = J9ClassHelper.getName(clazz);
        char ch = baseName.charAt(0);
        if (ch != '[') {
            return baseName;
        }
        J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(clazz);
        int arity = arrayClass.arity().intValue();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < arity; ++i) {
            buf.append("[]");
        }
        String aritySuffix = buf.toString();
        ch = baseName.charAt(1);
        switch (ch) {
            case 'B': {
                return "byte" + aritySuffix;
            }
            case 'C': {
                return "char" + aritySuffix;
            }
            case 'D': {
                return "double" + aritySuffix;
            }
            case 'F': {
                return "float" + aritySuffix;
            }
            case 'I': {
                return "int" + aritySuffix;
            }
            case 'J': {
                return "long" + aritySuffix;
            }
            case 'S': {
                return "void" + aritySuffix;
            }
            case 'V': {
                return "void" + aritySuffix;
            }
            case 'Z': {
                return "boolean" + aritySuffix;
            }
            case 'L': {
                return J9ClassHelper.getName(arrayClass.leafComponentType()) + aritySuffix;
            }
        }
        return baseName;
    }

    public static Iterator<J9ObjectFieldOffset> getFieldOffsets(J9ClassPointer clazz) throws CorruptDataException {
        U32 flags = new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_INSTANCE);
        return J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(clazz, J9ClassHelper.superclass(clazz), flags);
    }

    public static J9ClassPointer superclass(J9ClassPointer clazz) throws CorruptDataException {
        long index = J9ClassHelper.depth(clazz) - 1L;
        if (index < 0L) {
            return J9ClassPointer.NULL;
        }
        VoidPointer j9ClassInstancePointer = clazz.superclasses().at(index);
        return J9ClassPointer.cast(j9ClassInstancePointer);
    }

    public static long depth(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.classDepthAndFlags().longValue() & J9Consts.J9_JAVA_CLASS_DEPTH_MASK;
    }

    public static J9ConstantPoolPointer ramConstantPool(J9ClassPointer clazz) throws CorruptDataException {
        return J9ConstantPoolPointer.cast(clazz.ramMethods().add(clazz.romClass().romMethodCount()));
    }

    private static HashMap<String, J9ObjectFieldOffset> getFieldOffsetCache(J9ClassPointer clazz) {
        Long classAddr = new Long(clazz.getAddress());
        HashMap<String, J9ObjectFieldOffset> fieldOffsetCache = classToFieldOffsetCacheMap.get(classAddr);
        if (null != fieldOffsetCache) {
            return fieldOffsetCache;
        }
        fieldOffsetCache = new HashMap();
        classToFieldOffsetCacheMap.put(classAddr, fieldOffsetCache);
        return fieldOffsetCache;
    }

    public static J9ObjectFieldOffset checkFieldOffsetCache(J9ClassPointer clazz, String fieldName, String signature) {
        HashMap<String, J9ObjectFieldOffset> fieldOffsetCache = J9ClassHelper.getFieldOffsetCache(clazz);
        return fieldOffsetCache.get(fieldName + "." + signature);
    }

    public static void setFieldOffsetCache(J9ClassPointer clazz, J9ObjectFieldOffset offset, String fieldName, String signature) {
        HashMap<String, J9ObjectFieldOffset> fieldOffsetCache = J9ClassHelper.getFieldOffsetCache(clazz);
        fieldOffsetCache.put(fieldName + "." + signature, offset);
    }

    public static boolean isSameOrSuperClassOf(J9ClassPointer superClazz, J9ClassPointer clazz) throws CorruptDataException {
        long superClassDepth = J9ClassHelper.depth(superClazz);
        if (superClazz.eq(clazz)) {
            return true;
        }
        if (J9ClassHelper.depth(clazz) > superClassDepth) {
            return superClazz.eq(clazz.superclasses().at(superClassDepth));
        }
        return false;
    }

    public static UDATAPointer vTable(J9ClassPointer clazz) {
        UDATAPointer pointer = UDATAPointer.cast(clazz.add(1L));
        return pointer;
    }

    public static UDATA size(J9ClassPointer clazz, J9JavaVMPointer vm) throws CorruptDataException {
        J9ClassPointer superclass;
        UDATA classDepth;
        UDATA size = new UDATA(J9Class.SIZEOF);
        UDATA vTableSlotCount = J9ClassHelper.vTable(clazz).at(0L);
        size = size.add(Scalar.convertSlotsToBytes(vTableSlotCount));
        if (vm.jitConfig().notNull()) {
            UDATA jitVTableSlotCount = vTableSlotCount.sub(1L);
            size = size.add(Scalar.convertSlotsToBytes(jitVTableSlotCount));
        }
        if (!J9ROMClassHelper.isArray(clazz.romClass())) {
            U32 ramMethodsSize = clazz.romClass().romMethodCount().mult((int)J9Method.SIZEOF);
            size = size.add(ramMethodsSize);
            if (!clazz.instanceDescription().anyBitsIn(1L)) {
                UDATA highestBitInSlot = new UDATA(UDATA.SIZEOF * 8 - 1);
                UDATA instanceDescriptionSize = clazz.totalInstanceSize().rightShift((int)(ObjectReferencePointer.SIZEOF >> 2) + 1);
                instanceDescriptionSize = instanceDescriptionSize.add(highestBitInSlot).bitAnd(highestBitInSlot.bitNot());
                if (J9BuildFlags.gc_leafBits) {
                    instanceDescriptionSize = instanceDescriptionSize.mult(2);
                }
                size = size.add(instanceDescriptionSize);
            }
            U32 staticSlotCount = clazz.romClass().objectStaticCount().add(clazz.romClass().singleScalarStaticCount());
            staticSlotCount = J9BuildFlags.env_data64 ? staticSlotCount.add(clazz.romClass().doubleScalarStaticCount()) : staticSlotCount.add(1).bitAnd(-2L).add(clazz.romClass().doubleScalarStaticCount().mult(2));
            size = size.add(Scalar.convertSlotsToBytes(new UDATA(staticSlotCount)));
            U32 constantPoolSlotCount = clazz.romClass().ramConstantPoolCount().mult(2);
            size = size.add(Scalar.convertSlotsToBytes(new UDATA(constantPoolSlotCount)));
        }
        if (vm.runtimeFlags().allBitsIn(J9Consts.J9_RUNTIME_EXTENDED_METHOD_BLOCK)) {
            UDATA extendedMethodBlockSize = Scalar.roundToSizeofUDATA(new UDATA(clazz.romClass().romMethodCount()));
            size = size.add(extendedMethodBlockSize);
        }
        size = (classDepth = clazz.classDepthAndFlags().bitAnd(J9JavaAccessFlags.J9AccClassDepthMask)).eq(0L) ? size.add(UDATA.SIZEOF) : size.add(Scalar.convertSlotsToBytes(classDepth));
        if (clazz.iTable().notNull() && ((superclass = J9ClassPointer.cast(clazz.superclasses().at(classDepth.sub(1L)))).isNull() || !superclass.iTable().eq(clazz.iTable()))) {
            J9ITablePointer iTable = J9ITablePointer.cast(clazz.iTable());
            if (superclass.isNull()) {
                while (iTable.next().notNull()) {
                    iTable = iTable.next();
                }
            } else {
                while (iTable.next().notNull() && !iTable.next().eq(superclass.iTable())) {
                    iTable = iTable.next();
                }
            }
            iTable = clazz.romClass().modifiers().allBitsIn(J9Consts.J9_JAVA_INTERFACE) ? iTable.add(1L) : iTable.add(1L).addOffset(iTable.interfaceClass().romClass().romMethodCount().mult(UDATA.SIZEOF));
            size = size.add(iTable.getAddress() - clazz.iTable().getAddress());
        }
        return size;
    }

    public static int getJavaLangClassModifiers(J9ClassPointer j9class) throws CorruptDataException {
        int rawModifiers = J9ClassHelper.getRawModifiers(j9class);
        rawModifiers = J9ClassHelper.isArrayClass(j9class) ? (rawModifiers &= 0x417) : (rawModifiers &= 0x761F);
        return rawModifiers;
    }

    public static int getRawModifiers(J9ClassPointer j9class) throws CorruptDataException {
        if (J9ClassHelper.isArrayClass(j9class)) {
            J9ArrayClassPointer arrayClass = J9ArrayClassPointer.cast(j9class);
            U32 modifiers = arrayClass.leafComponentType().romClass().modifiers();
            modifiers = modifiers.bitOr(J9JavaAccessFlags.J9AccAbstract);
            modifiers = modifiers.bitOr(J9JavaAccessFlags.J9AccFinal);
            return modifiers.intValue();
        }
        U32 modifiers = j9class.romClass().modifiers();
        if (j9class.romClass().outerClassName().notNull()) {
            modifiers = j9class.romClass().memberAccessFlags();
        }
        return modifiers.intValue();
    }

    public static UDATA classDepth(J9ClassPointer j9class) throws CorruptDataException {
        return j9class.classDepthAndFlags().bitAnd(J9Consts.J9_JAVA_CLASS_DEPTH_MASK);
    }

    public static boolean isObsolete(J9ClassPointer j9class) throws CorruptDataException {
        return j9class.classDepthAndFlags().allBitsIn(J9Consts.J9_JAVA_CLASS_HOT_SWAPPED_OUT);
    }

    public static J9ClassPointer currentClass(J9ClassPointer j9class) throws CorruptDataException {
        return J9ClassHelper.isObsolete(j9class) ? j9class.arrayClass() : j9class;
    }

    public static J9MethodPointer getMethodFromPCAndClass(J9ClassPointer localClass, U8Pointer pc) throws CorruptDataException {
        J9ROMClassPointer localROMClass = localClass.romClass();
        int i = 0;
        while ((long)i < localROMClass.romMethodCount().longValue()) {
            J9MethodPointer localMethod = localClass.ramMethods().add(i);
            J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(localMethod);
            boolean a = pc.gte(U8Pointer.cast(romMethod));
            boolean b = pc.lte(J9ROMMethodHelper.bytecodeEnd(romMethod).subOffset(1L));
            if (a && b) {
                return localMethod;
            }
            ++i;
        }
        return J9MethodPointer.NULL;
    }

    public static boolean isSwappedOut(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.classDepthAndFlags().allBitsIn(J9JavaAccessFlags.J9AccClassHotSwappedOut);
    }

    public static boolean hasValidEyeCatcher(J9ClassPointer clazz) throws CorruptDataException {
        return clazz.clazz().eq(0x99669966L) && clazz.flags().eq(3455045103L) && UDATA.cast(clazz.monitor()).eq(0x5A5A5A5AL);
    }

    static {
        TYPE_MAP.put("boolean", Character.valueOf('Z'));
        TYPE_MAP.put("byte", Character.valueOf('B'));
        TYPE_MAP.put("char", Character.valueOf('C'));
        TYPE_MAP.put("short", Character.valueOf('S'));
        TYPE_MAP.put("int", Character.valueOf('I'));
        TYPE_MAP.put("long", Character.valueOf('J'));
        TYPE_MAP.put("float", Character.valueOf('F'));
        TYPE_MAP.put("double", Character.valueOf('D'));
    }
}

