/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.InvalidDataTypeException;
import com.ibm.j9ddr.vm24.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm24.j9.ObjectModel;
import com.ibm.j9ddr.vm24.j9.gc.GCClassIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCClassIteratorClassSlots;
import com.ibm.j9ddr.vm24.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm24.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCScavengerForwardedHeader;
import com.ibm.j9ddr.vm24.j9.gc.GCSegmentIterator;
import com.ibm.j9ddr.vm24.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm24.j9.walkers.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm24.pointer.AbstractPointer;
import com.ibm.j9ddr.vm24.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm24.pointer.PointerPointer;
import com.ibm.j9ddr.vm24.pointer.U8Pointer;
import com.ibm.j9ddr.vm24.pointer.VoidPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm24.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaStackPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9SharedClassConfigPointer;
import com.ibm.j9ddr.vm24.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm24.pointer.generated.MM_SublistPoolPointer;
import com.ibm.j9ddr.vm24.pointer.generated.MM_SublistPuddlePointer;
import com.ibm.j9ddr.vm24.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm24.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm24.structure.J9Class;
import com.ibm.j9ddr.vm24.structure.J9Constants;
import com.ibm.j9ddr.vm24.structure.J9FieldFlags;
import com.ibm.j9ddr.vm24.structure.J9IndexableObject;
import com.ibm.j9ddr.vm24.structure.J9MemorySegment;
import com.ibm.j9ddr.vm24.structure.J9Object;
import com.ibm.j9ddr.vm24.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckBase;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckCycle;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckElement;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckError;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.CheckReporter;
import com.ibm.j9ddr.vm24.tools.ddrinteractive.gccheck.SegmentTree;
import com.ibm.j9ddr.vm24.types.IDATA;
import com.ibm.j9ddr.vm24.types.U32;
import com.ibm.j9ddr.vm24.types.UDATA;
import java.util.Arrays;
import java.util.Iterator;

class CheckEngine {
    private J9JavaVMPointer _javaVM;
    private CheckReporter _reporter;
    private CheckCycle _cycle;
    private Check _currentCheck;
    private CheckElement _lastHeapObject1 = new CheckElement();
    private CheckElement _lastHeapObject2 = new CheckElement();
    private CheckElement _lastHeapObject3 = new CheckElement();
    private SegmentTree _classSegmentsTree;
    private static final int CLASS_CACHE_SIZE = 19;
    private J9ClassPointer[] _checkedClassCache = new J9ClassPointer[19];
    private J9ClassPointer[] _checkedClassCacheAllowUndead = new J9ClassPointer[19];
    private static final int OBJECT_CACHE_SIZE = 61;
    private J9ObjectPointer[] _checkedObjectCache = new J9ObjectPointer[61];

    public CheckEngine(J9JavaVMPointer vm, CheckReporter reporter) {
        this._javaVM = vm;
        this._reporter = reporter;
    }

    public J9JavaVMPointer getJavaVM() {
        return this._javaVM;
    }

    public CheckReporter getReporter() {
        return this._reporter;
    }

    public void clearPreviousObjects() {
        this._lastHeapObject1.setNone();
        this._lastHeapObject2.setNone();
        this._lastHeapObject3.setNone();
    }

    public void pushPreviousObject(J9ObjectPointer object) {
        this._lastHeapObject3.copyFrom(this._lastHeapObject2);
        this._lastHeapObject2.copyFrom(this._lastHeapObject1);
        this._lastHeapObject1.setObject(object);
    }

    public void pushPreviousClass(J9ClassPointer clazz) {
        this._lastHeapObject3.copyFrom(this._lastHeapObject2);
        this._lastHeapObject2.copyFrom(this._lastHeapObject1);
        this._lastHeapObject1.setClazz(clazz);
    }

    public boolean isMidscavengeFlagSet() {
        return (this._cycle.getMiscFlags() & 0x10000) != 0;
    }

    public void reportForwardedObject(J9ObjectPointer object, J9ObjectPointer forwardedObject) {
        if ((this._cycle.getMiscFlags() & 1) != 0) {
            this._reporter.reportForwardedObject(object, forwardedObject);
        }
    }

    public int checkObjectHeap(J9ObjectPointer object, J9MemorySegmentPointer segment) {
        int result = 0;
        boolean isDead = false;
        boolean isIndexable = false;
        UDATA holeSize = new UDATA(0L);
        J9ClassPointer clazz = null;
        try {
            isDead = ObjectModel.isDeadObject(object);
            if (isDead) {
                holeSize = ObjectModel.getSizeInBytesDeadObject(object);
            } else {
                isIndexable = ObjectModel.isIndexable(object);
                clazz = J9ObjectHelper.clazz(object);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 1;
        }
        if (isDead) {
            if (holeSize.eq(0L)) {
                CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", 16, this._cycle.nextErrorCount());
                this._reporter.report(error);
                this._reporter.reportHeapWalkError(error, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
                return 1;
            }
            return 0;
        }
        try {
            result = this.checkJ9Object(object, segment, this._cycle.getCheckFlags());
        }
        catch (CorruptDataException cde) {
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 1;
        }
        if (0 != result) {
            String elementName = isIndexable ? "IObject " : "Object ";
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
            this._reporter.report(error);
            this._reporter.reportHeapWalkError(error, this._lastHeapObject1, this._lastHeapObject2, this._lastHeapObject3);
            return 1;
        }
        if (0 == result) {
            VoidPointer address;
            J9ObjectPointer field;
            GCObjectIterator addressIterator;
            GCObjectIterator fieldIterator;
            try {
                fieldIterator = GCObjectIterator.fromJ9Object(object, true);
                addressIterator = GCObjectIterator.fromJ9Object(object, true);
            }
            catch (CorruptDataException e) {
                CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 1;
            }
            while (fieldIterator.hasNext() && 0 == (result = this.checkSlotObjectHeap(field = fieldIterator.next(), ObjectReferencePointer.cast(address = addressIterator.nextAddress()), segment, object))) {
            }
        }
        if (0 == result) {
            int cacheIndex = (int)(object.getAddress() % 61L);
            this._checkedObjectCache[cacheIndex] = object;
        }
        return result;
    }

    public int checkSlotObjectHeap(J9ObjectPointer object, ObjectReferencePointer objectIndirect, J9MemorySegmentPointer segment, J9ObjectPointer objectIndirectBase) {
        if (object.isNull()) {
            return 0;
        }
        int result = this.checkObjectIndirect(object);
        if ((this._cycle.getMiscFlags() & 0x8000) != 0) {
            switch (result) {
                case 0: 
                case 1: 
                case 6: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    return 0;
                }
            }
        }
        boolean isIndexable = false;
        boolean scavengerEnabled = false;
        try {
            isIndexable = ObjectModel.isIndexable(objectIndirectBase);
            scavengerEnabled = GCExtensions.scavengerEnabled();
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(object, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 1;
        }
        if (0 != result) {
            String elementName = isIndexable ? "IObject " : "Object ";
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 0;
        }
        if (J9BuildFlags.gc_generational && scavengerEnabled) {
            J9MemorySegmentPointer objectSegment = this.findSegmentForPointer(object, true, false);
            if (objectSegment == null) {
                return 4;
            }
            if (object.notNull()) {
                boolean isOld;
                boolean isRemembered;
                UDATA objectSegmentType;
                UDATA segmentType;
                try {
                    segmentType = segment.type();
                    objectSegmentType = objectSegment.type();
                    isRemembered = ObjectModel.isRemembered(objectIndirectBase);
                    isOld = ObjectModel.isOld(object);
                }
                catch (CorruptDataException e) {
                    CheckError error = new CheckError(objectIndirectBase, this._cycle, this._currentCheck, "Object ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 1;
                }
                if (segmentType.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD) && objectSegmentType.allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW) && !isRemembered) {
                    String elementName = isIndexable ? "IObject " : "Object ";
                    CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, elementName, 17, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                if (segmentType.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD) && !isOld && !isRemembered) {
                    String elementName = isIndexable ? "IObject " : "Object ";
                    CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, elementName, 20, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
            }
        }
        return 0;
    }

    private J9MemorySegmentPointer findSegmentForPointer(AbstractPointer pointer, boolean searchObjectMemorySegments, boolean searchClassMemorySegments) {
        try {
            J9MemorySegmentPointer segment;
            if (searchObjectMemorySegments) {
                J9MemorySegmentPointer sharedMemSegment;
                J9SharedClassConfigPointer sharedConfig;
                GCSegmentIterator objectIterator = GCSegmentIterator.fromJ9MemorySegmentList(this._javaVM.objectMemorySegments(), J9MemorySegment.MEMORY_TYPE_RAM);
                while (objectIterator.hasNext()) {
                    J9MemorySegmentPointer segment2 = objectIterator.next();
                    if (!this.isPointerInSegment(pointer, segment2)) continue;
                    return segment2;
                }
                if (J9BuildFlags.opt_zero && J9BuildFlags.opt_sharedClasses && (sharedConfig = this._javaVM.sharedClassConfig()).notNull() && this._javaVM.zeroOptions().allBitsIn(J9Constants.J9VM_ZERO_SHARESTRINGS) && this.isPointerInSegment(pointer, sharedMemSegment = sharedConfig.metadataMemorySegment())) {
                    return sharedMemSegment;
                }
            }
            if (searchClassMemorySegments && (segment = this._classSegmentsTree.findSegment(pointer)).notNull() && segment.type().anyBitsIn(J9MemorySegment.MEMORY_TYPE_RAM_CLASS | J9MemorySegment.MEMORY_TYPE_UNDEAD_CLASS)) {
                return segment;
            }
        }
        catch (CorruptDataException cde) {
            // empty catch block
        }
        return null;
    }

    private int checkObjectIndirect(J9ObjectPointer object) {
        int result;
        if (object.isNull()) {
            return 0;
        }
        int cacheIndex = (int)Math.abs(object.getAddress() % 61L);
        if (this._checkedObjectCache[cacheIndex] == object) {
            return 0;
        }
        J9ObjectPointer[] newObject = new J9ObjectPointer[]{J9ObjectPointer.NULL};
        J9MemorySegmentPointer[] objectSegment = new J9MemorySegmentPointer[1];
        try {
            result = this.checkJ9ObjectPointer(object, newObject, objectSegment);
            if (0 == result) {
                result = this.checkJ9Object(newObject[0], objectSegment[0], this._cycle.getCheckFlags());
            }
        }
        catch (CorruptDataException e) {
            result = Integer.MAX_VALUE;
        }
        if (0 == result) {
            this._checkedObjectCache[cacheIndex] = object;
        }
        return result;
    }

    private int checkJ9ObjectPointer(J9ObjectPointer object, J9ObjectPointer[] newObject, J9MemorySegmentPointer[] segmentIndirect) throws CorruptDataException {
        GCScavengerForwardedHeader scavengerForwardedHeader;
        newObject[0] = object;
        if (object.isNull()) {
            return 0;
        }
        segmentIndirect[0] = this.findSegmentForPointer(object, true, false);
        if (segmentIndirect[0] == null) {
            GCVMThreadListIterator threadListIterator = GCVMThreadListIterator.from();
            while (threadListIterator.hasNext()) {
                J9VMThreadPointer vmThread = threadListIterator.next();
                if (!this.isObjectOnStack(object, vmThread.stackObject())) continue;
                return 6;
            }
            UDATA classSlot = UDATA.cast(object.clazz());
            if (classSlot.eq(0x99669966L)) {
                return 37;
            }
            return 4;
        }
        if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 1;
        }
        if (this.isMidscavengeFlagSet() && segmentIndirect[0].type().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW) && (scavengerForwardedHeader = GCScavengerForwardedHeader.fromJ9Object(object)).isForwardedPointer()) {
            newObject[0] = scavengerForwardedHeader.getForwardedObject();
            this.reportForwardedObject(object, newObject[0]);
            object = newObject[0];
            segmentIndirect[0] = this.findSegmentForPointer(object, true, false);
            if (segmentIndirect[0] == null) {
                GCVMThreadListIterator threadListIterator = GCVMThreadListIterator.from();
                while (threadListIterator.hasNext()) {
                    J9VMThreadPointer vmThread = threadListIterator.next();
                    if (!this.isObjectOnStack(object, vmThread.stackObject())) continue;
                    return 6;
                }
                return 4;
            }
            if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
                return 1;
            }
        }
        long classShape = -1L;
        try {
            classShape = ObjectModel.getClassShape(J9ObjectHelper.clazz(object)).longValue();
        }
        catch (CorruptDataException cde) {
            // empty catch block
        }
        if (classShape == J9Object.OBJECT_HEADER_SHAPE_DOUBLES) {
            J9IndexableObjectPointer array = J9IndexableObjectPointer.cast(object);
            int size = 0;
            VoidPointer elementPtr = VoidPointer.NULL;
            try {
                size = ObjectModel.getSizeInElements(object).intValue();
            }
            catch (InvalidDataTypeException ex) {
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            if (0 != size) {
                elementPtr = ObjectModel.getElementAddress(array, 0, 8);
                if (elementPtr.anyBitsIn(7L)) {
                    return 2;
                }
                elementPtr = ObjectModel.getElementAddress(array, size - 1, 8);
                if (elementPtr.anyBitsIn(7L)) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public int checkSlot(PointerPointer objectIndirect, VoidPointer objectIndirectBase, int objectType) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (0 != result) {
                CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), objectType);
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), objectType);
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotVMThread(PointerPointer objectIndirect, VoidPointer objectIndirectBase, int objectType, int iteratorState) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (3 == iteratorState && 6 == result) {
                result = this.checkStackObject(object);
            }
            if (0 != result) {
                CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), objectType);
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), objectType);
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotStack(PointerPointer objectIndirect, J9VMThreadPointer vmThread, VoidPointer stackLocation) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (6 == result) {
                result = this.checkStackObject(object);
            }
            if (0 != result) {
                CheckError error = new CheckError(vmThread, objectIndirect, stackLocation, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 2;
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(vmThread, objectIndirect, stackLocation, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
            return 2;
        }
        return 0;
    }

    private int checkStackObject(J9ObjectPointer object) {
        if (object.isNull()) {
            return 0;
        }
        if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_ONSTACK_ALIGNMENT_MASK)) {
            return 1;
        }
        if ((this._cycle.getCheckFlags() & 1) != 0) {
            try {
                int ret = this.checkJ9ClassPointer(J9ObjectHelper.clazz(object));
                if (0 != ret) {
                    return ret;
                }
            }
            catch (CorruptDataException e) {
                return Integer.MAX_VALUE;
            }
        }
        if ((this._cycle.getCheckFlags() & 8) != 0) {
            try {
                if (!this.checkIndexableFlag(object)) {
                    return 13;
                }
            }
            catch (CorruptDataException e) {
                return Integer.MAX_VALUE;
            }
        }
        return 0;
    }

    public int checkSlotReferences(PointerPointer objectIndirect, MM_SublistPuddlePointer puddle, MM_SublistPoolPointer pool) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (0 != result) {
                CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
            if (puddle._newStoreFlag()) {
                if (!pool._newStoreFlag()) {
                    CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 21, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                }
            } else if (!ObjectModel.isOld(object)) {
                CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 22, this._cycle.nextErrorCount());
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotRememberedSet(PointerPointer objectIndirect, MM_SublistPuddlePointer puddle) {
        try {
            int result;
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            if (this.isMidscavengeFlagSet() && object.anyBitsIn(1L)) {
                object = object.untag(1L);
            }
            if (0 != (result = this.checkObjectIndirect(object))) {
                CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
            if (object.notNull()) {
                J9MemorySegmentPointer segment = this.findSegmentForPointer(object, true, false);
                if (segment == null) {
                    CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 4, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                if (segment.type().allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW)) {
                    CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 18, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                if (!ObjectModel.isOld(object) || !ObjectModel.isRemembered(object)) {
                    CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, 19, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    this._reporter.reportObjectHeader(error, object, null);
                    return 0;
                }
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(puddle, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkSlotPool(PointerPointer objectIndirect, VoidPointer objectIndirectBase) {
        try {
            J9ObjectPointer object = J9ObjectPointer.cast(objectIndirect.at(0L));
            int result = this.checkObjectIndirect(object);
            if (0 != result) {
                CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), 0);
                this._reporter.report(error);
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(objectIndirectBase, objectIndirect, this._cycle, this._currentCheck, Integer.MAX_VALUE, this._cycle.nextErrorCount(), 0);
            this._reporter.report(error);
        }
        return 0;
    }

    public int checkClassHeap(J9ClassPointer clazz, J9MemorySegmentPointer segment) {
        try {
            int result = this.checkJ9Class(clazz, segment, this._cycle.getCheckFlags());
            if (0 != result) {
                CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", result, this._cycle.nextErrorCount());
                this._reporter.report(error);
            }
            GCClassIterator classIterator = GCClassIterator.fromJ9Class(clazz);
            while (classIterator.hasNext()) {
                PointerPointer slotPtr = PointerPointer.cast(classIterator.nextAddress());
                J9ObjectPointer object = J9ObjectPointer.cast(slotPtr.at(0L));
                result = this.checkObjectIndirect(object);
                if (0 != result) {
                    String elementName = "";
                    switch (classIterator.getState()) {
                        case 1: {
                            elementName = "static ";
                            break;
                        }
                        case 2: {
                            elementName = "constant ";
                            break;
                        }
                        case 3: {
                            elementName = "slots ";
                        }
                    }
                    CheckError error = new CheckError(clazz, slotPtr, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                    return 0;
                }
                if (!GCExtensions.isStandardGC() || !object.notNull() || ObjectModel.isOld(object) || ObjectModel.isRemembered(clazz.classObject())) continue;
                CheckError error = new CheckError(clazz, slotPtr, this._cycle, this._currentCheck, "Class ", 20, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
            if (0 != this.checkClassStatics(clazz)) {
                return 0;
            }
            GCClassIteratorClassSlots classIteratorClassSlots = GCClassIteratorClassSlots.fromJ9Class(clazz);
            while (classIteratorClassSlots.hasNext()) {
                PointerPointer classSlotPtr = PointerPointer.cast(classIteratorClassSlots.nextAddress());
                J9ClassPointer classSlot = J9ClassPointer.cast(classSlotPtr.at(0L));
                String elementName = "";
                result = 0;
                switch (classIteratorClassSlots.getState()) {
                    case 1: {
                        if (classSlot.notNull()) {
                            result = this.checkJ9ClassPointer(classSlot);
                        }
                        elementName = "constant ";
                        break;
                    }
                    case 2: {
                        result = this.checkJ9ClassPointer(classSlot);
                        elementName = "superclass ";
                        break;
                    }
                    case 3: {
                        result = this.checkJ9ClassPointer(classSlot);
                        elementName = "interface ";
                        break;
                    }
                    case 4: {
                        if (classSlot.notNull()) {
                            result = this.checkJ9ClassPointer(classSlot);
                        }
                        elementName = "array class ";
                    }
                }
                if (0 == result) continue;
                CheckError error = new CheckError(clazz, classSlotPtr, this._cycle, this._currentCheck, elementName, result, this._cycle.nextErrorCount());
                this._reporter.report(error);
                return 0;
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return 0;
    }

    private int checkClassStatics(J9ClassPointer clazz) {
        int result = 0;
        try {
            if (!J9ClassHelper.isArrayClass(clazz) && !J9ClassHelper.isSwappedOut(clazz)) {
                J9ROMClassPointer romClazz = clazz.romClass();
                UDATA numberOfReferences = new UDATA(0L);
                PointerPointer sectionStart = PointerPointer.cast(clazz.ramStatics());
                PointerPointer sectionEnd = sectionStart.add(romClazz.objectStaticCount());
                Iterator<J9ObjectFieldOffset> objectFieldOffsetIterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(clazz, J9ClassHelper.superclass(clazz), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC | J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_ONLY_OBJECT_SLOTS));
                while (objectFieldOffsetIterator.hasNext()) {
                    J9ObjectFieldOffset fieldOffset = objectFieldOffsetIterator.next();
                    if (!fieldOffset.isStatic() || !fieldOffset.getField().modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagObject)) continue;
                    numberOfReferences = numberOfReferences.add(1L);
                    PointerPointer address = sectionStart.addOffset(fieldOffset.getOffsetOrAddress());
                    if (address.gte(sectionStart) && address.lt(sectionEnd)) continue;
                    result = 32;
                    CheckError error = new CheckError(clazz, address, this._cycle, this._currentCheck, "Class ", result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                }
                if (!numberOfReferences.eq(romClazz.objectStaticCount())) {
                    result = 33;
                    CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", result, this._cycle.nextErrorCount());
                    this._reporter.report(error);
                }
            }
        }
        catch (CorruptDataException e) {
            CheckError error = new CheckError(clazz, this._cycle, this._currentCheck, "Class ", Integer.MAX_VALUE, this._cycle.nextErrorCount());
            this._reporter.report(error);
        }
        return result;
    }

    private int checkJ9Class(J9ClassPointer clazz, J9MemorySegmentPointer segment, int checkFlags) throws CorruptDataException {
        UDATA delta;
        if (clazz.isNull()) {
            return 0;
        }
        if (clazz.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9CLASS_ALIGNMENT_MASK)) {
            return 8;
        }
        int ret = this.checkJ9ClassHeader(clazz);
        if (0 != ret) {
            return ret;
        }
        if ((checkFlags & 2) != 2 && (delta = UDATA.cast(segment.heapAlloc()).sub(UDATA.cast(clazz))).lt(J9Class.SIZEOF)) {
            return 10;
        }
        return 0;
    }

    public int checkJ9ClassPointer(J9ClassPointer clazz) throws CorruptDataException {
        return this.checkJ9ClassPointer(clazz, false);
    }

    public int checkJ9ClassPointer(J9ClassPointer clazz, boolean allowUndead) throws CorruptDataException {
        IDATA delta;
        if (clazz == null || clazz.isNull()) {
            return 7;
        }
        int cacheIndex = (int)(clazz.longValue() % 19L);
        if (allowUndead && clazz.eq(this._checkedClassCacheAllowUndead[cacheIndex])) {
            return 0;
        }
        if (clazz.eq(this._checkedClassCache[cacheIndex])) {
            return 0;
        }
        if (UDATA.cast(clazz).anyBitsIn(CheckBase.J9MODRON_GCCHK_J9CLASS_ALIGNMENT_MASK)) {
            return 8;
        }
        J9MemorySegmentPointer segment = this.findSegmentForClass(clazz);
        if (segment == null) {
            return 9;
        }
        if (!allowUndead && (segment.type().longValue() & J9MemorySegment.MEMORY_TYPE_UNDEAD_CLASS) != 0L) {
            return 29;
        }
        int result = this.checkJ9ClassHeader(clazz);
        if (0 != result) {
            return result;
        }
        if ((this._cycle.getCheckFlags() & 2) != 0 && (delta = segment.heapAlloc().sub(U8Pointer.cast(clazz))).lt(J9Class.SIZEOF)) {
            return 10;
        }
        if (allowUndead) {
            this._checkedClassCacheAllowUndead[cacheIndex] = clazz;
        } else {
            this._checkedClassCache[cacheIndex] = clazz;
        }
        return 0;
    }

    private int checkJ9ClassHeader(J9ClassPointer clazz) throws CorruptDataException {
        if (!(clazz.clazz().eq(0x99669966L) && clazz.flags().eq(3455045103L) && UDATA.cast(clazz.monitor()).eq(0x5A5A5A5AL))) {
            return 26;
        }
        return 0;
    }

    private int checkJ9Object(J9ObjectPointer object, J9MemorySegmentPointer segment, int checkFlags) throws CorruptDataException {
        int ret;
        if (object.isNull()) {
            return 0;
        }
        if (object.anyBitsIn(CheckBase.J9MODRON_GCCHK_J9OBJECT_ALIGNMENT_MASK)) {
            return 1;
        }
        if ((checkFlags & 1) != 0 && 0 != (ret = this.checkJ9ClassPointer(J9ObjectHelper.clazz(object), true))) {
            return ret;
        }
        if ((checkFlags & 2) != 0) {
            UDATA delta = UDATA.cast(segment.heapAlloc().sub(UDATA.cast(object)));
            if (delta.lt(J9Object.SIZEOF)) {
                return 5;
            }
            if (ObjectModel.isIndexable(object) && delta.lt(J9IndexableObject.SIZEOF)) {
                return 5;
            }
            if (delta.lt(ObjectModel.getSizeInBytesWithHeader(object))) {
                return 5;
            }
            if ((checkFlags & 8) != 0) {
                if (!this.checkIndexableFlag(object)) {
                    return 13;
                }
                if (GCExtensions.isStandardGC()) {
                    UDATA segmentFlags = segment.type();
                    if (segmentFlags.allBitsIn(J9MemorySegment.MEMORY_TYPE_OLD)) {
                        if (!ObjectModel.isOld(object)) {
                            return 14;
                        }
                    } else if (segmentFlags.allBitsIn(J9MemorySegment.MEMORY_TYPE_NEW) && ObjectModel.isOld(object)) {
                        return 15;
                    }
                }
            }
        }
        return 0;
    }

    private boolean checkIndexableFlag(J9ObjectPointer object) throws CorruptDataException {
        U32 classShape = ObjectModel.getClassShape(J9ObjectHelper.clazz(object));
        boolean result = false;
        if (ObjectModel.isIndexable(object)) {
            if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_BYTES) || classShape.eq(J9Object.OBJECT_HEADER_SHAPE_WORDS) || classShape.eq(J9Object.OBJECT_HEADER_SHAPE_DOUBLES) || classShape.eq(J9Object.OBJECT_HEADER_SHAPE_LONGS) || classShape.eq(J9Object.OBJECT_HEADER_SHAPE_POINTERS)) {
                result = true;
            }
        } else if (classShape.eq(J9Object.OBJECT_HEADER_SHAPE_MIXED) || classShape.eq(J9Object.OBJECT_HEADER_SHAPE_REFERENCE_MIXED)) {
            result = true;
        }
        return result;
    }

    public void startCheckCycle(CheckCycle checkCycle) throws CorruptDataException {
        this._cycle = checkCycle;
        this._currentCheck = null;
        this.clearPreviousObjects();
        this.clearCheckedCache();
        this.prepareForHeapWalk();
    }

    public void prepareForHeapWalk() throws CorruptDataException {
        this._classSegmentsTree = new SegmentTree(this._javaVM.classMemorySegments());
    }

    public void endCheckCycle() {
    }

    public void startNewCheck(Check check) {
        this._currentCheck = check;
        this.clearPreviousObjects();
    }

    private void clearCheckedCache() {
        Arrays.fill(this._checkedClassCache, null);
        Arrays.fill(this._checkedClassCacheAllowUndead, null);
        Arrays.fill(this._checkedObjectCache, null);
    }

    private boolean isPointerInSegment(AbstractPointer pointer, J9MemorySegmentPointer segment) {
        try {
            return pointer.gte(segment.heapBase()) && pointer.lt(segment.heapAlloc());
        }
        catch (CorruptDataException e) {
            return false;
        }
    }

    private boolean isObjectOnStack(J9ObjectPointer object, J9JavaStackPointer stack) {
        try {
            return object.lt(stack.end()) && object.gte(stack.add(1L));
        }
        catch (CorruptDataException e) {
            return false;
        }
    }

    private J9MemorySegmentPointer findSegmentForClass(J9ClassPointer clazz) {
        J9MemorySegmentPointer segment = this._classSegmentsTree.findSegment(clazz);
        if (segment != null) {
            if (!this.isPointerInSegment(clazz, segment)) {
                return null;
            }
            try {
                if (segment.type().anyBitsIn(J9MemorySegment.MEMORY_TYPE_RAM_CLASS | J9MemorySegment.MEMORY_TYPE_UNDEAD_CLASS)) {
                    return segment;
                }
            }
            catch (CorruptDataException e) {
                return null;
            }
        }
        return null;
    }

    public int checkSlotFinalizableList(J9ObjectPointer object) {
        int result = this.checkObjectIndirect(object);
        if (0 != result) {
            CheckError error = new CheckError((AbstractPointer)object, null, this._cycle, this._currentCheck, result, this._cycle.nextErrorCount(), 6);
            this._reporter.report(error);
        }
        return 0;
    }

    public void setMaxErrorsToReport(int count) {
        this._reporter.setMaxErrorsToReport(count);
    }
}

