/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.events.EventManager;
import com.ibm.j9ddr.vm26.j9.HashTable;
import com.ibm.j9ddr.vm26.j9.StringTable;
import com.ibm.j9ddr.vm26.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm26.pointer.PointerPointer;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm26.pointer.generated.MM_StringTablePointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm26.types.UDATA;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class StringTable_V1
extends StringTable {
    protected StringTable_V1(MM_StringTablePointer stringTable) throws CorruptDataException {
        this._stringTable = stringTable;
        this._tableCount = stringTable._tableCount().longValue();
    }

    public static StringTable from() throws CorruptDataException {
        MM_GCExtensionsPointer extensions = GCExtensions.getGCExtensionsPointer();
        return new StringTable_V1(extensions.stringTable());
    }

    public StringTable.StringSlotIterator iterator() {
        return new StringTable.StringSlotIterator(){
            private Iterator<PointerPointer> hashTableIterator = null;
            protected long _currentIndex = 0L;

            public boolean hasNext() {
                while (true) {
                    if (this.hashTableIterator != null) {
                        if (this.hashTableIterator.hasNext()) {
                            return true;
                        }
                        ++this._currentIndex;
                    }
                    if (this._currentIndex >= StringTable_V1.this._tableCount) {
                        this.hashTableIterator = null;
                        return false;
                    }
                    try {
                        J9HashTablePointer hashTable = J9HashTablePointer.cast(StringTable_V1.this._stringTable._table().at(this._currentIndex));
                        HashTable<PointerPointer> currentHashTable = HashTable.fromJ9HashTable(hashTable, PointerPointer.class, new StringEqualFunction(), new StringHashFunction());
                        this.hashTableIterator = currentHashTable.iterator();
                        continue;
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        continue;
                    }
                    break;
                }
            }

            public J9ObjectPointer next() {
                if (this.hasNext()) {
                    try {
                        PointerPointer next = this.hashTableIterator.next();
                        return J9ObjectPointer.cast(next.at(0L));
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
                        return null;
                    }
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            public VoidPointer nextAddress() {
                if (this.hasNext()) {
                    return VoidPointer.cast(this.hashTableIterator.next());
                }
                throw new NoSuchElementException("There are no more items available through this iterator");
            }

            public J9HashTablePointer getCurrentHashTable() throws CorruptDataException {
                return J9HashTablePointer.cast(StringTable_V1.this._stringTable._table().at(this._currentIndex));
            }

            public void remove() {
                throw new UnsupportedOperationException("The image is read only and cannot be modified.");
            }
        };
    }

    public J9ObjectPointer search(J9ObjectPointer objectPointer) throws CorruptDataException {
        throw new UnsupportedOperationException("Search is not supported in StringTable_V1");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringEqualFunction
    implements HashTable.HashEqualFunction<PointerPointer> {
        @Override
        public boolean equal(PointerPointer left, PointerPointer right) {
            try {
                J9ObjectPointer leftObject = J9ObjectPointer.cast(left.at(0L));
                J9ObjectPointer rightObject = J9ObjectPointer.cast(right.at(0L));
                return J9ObjectHelper.stringValue(leftObject).equals(J9ObjectHelper.stringValue(rightObject));
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error checking equality", e, true);
                return false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringHashFunction
    implements HashTable.HashFunction<PointerPointer> {
        @Override
        public UDATA hash(PointerPointer entry) {
            try {
                J9ObjectPointer entryObject = J9ObjectPointer.cast(entry.at(0L));
                return new UDATA(J9ObjectHelper.stringValue(entryObject).hashCode());
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error calculating hash", e, false);
                return new UDATA(0L);
            }
        }
    }
}

