/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.Pointer;
import com.ibm.j9ddr.vm26.types.I32;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.UDATA;

public class I32Pointer
extends Pointer {
    public static final int SIZEOF = 4;
    public static final I32Pointer NULL = new I32Pointer(0L);

    protected I32Pointer(long address) {
        super(address);
    }

    public static I32Pointer cast(AbstractPointer pointer) {
        return I32Pointer.cast(pointer.getAddress());
    }

    public static I32Pointer cast(UDATA udata) {
        return I32Pointer.cast(udata.longValue());
    }

    public static I32Pointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new I32Pointer(address);
    }

    public I32 at(long index) throws CorruptDataException {
        return new I32(this.getIntAtOffset(index * 4L));
    }

    public I32 at(Scalar index) throws CorruptDataException {
        return this.at(index.longValue());
    }

    public I32Pointer untag() {
        return this.untag(3L);
    }

    public I32Pointer untag(long mask) {
        return new I32Pointer(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public I32Pointer add(long count) {
        return new I32Pointer(this.address + 4L * count);
    }

    public I32Pointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public I32Pointer addOffset(long offset) {
        return new I32Pointer(this.address + offset);
    }

    public I32Pointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public I32Pointer sub(long count) {
        return new I32Pointer(this.address - 4L * count);
    }

    public I32Pointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public I32Pointer subOffset(long offset) {
        return new I32Pointer(this.address - offset);
    }

    public I32Pointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    protected long sizeOfBaseType() {
        return 4L;
    }
}

