/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm26.pointer.AbstractPointer;
import com.ibm.j9ddr.vm26.pointer.I32Pointer;
import com.ibm.j9ddr.vm26.pointer.StructurePointer;
import com.ibm.j9ddr.vm26.pointer.U16Pointer;
import com.ibm.j9ddr.vm26.pointer.U32Pointer;
import com.ibm.j9ddr.vm26.pointer.U8Pointer;
import com.ibm.j9ddr.vm26.structure.ByteDataWrapper;
import com.ibm.j9ddr.vm26.types.I32;
import com.ibm.j9ddr.vm26.types.Scalar;
import com.ibm.j9ddr.vm26.types.U16;
import com.ibm.j9ddr.vm26.types.U32;
import com.ibm.j9ddr.vm26.types.U8;
import com.ibm.j9ddr.vm26.types.UDATA;

@GeneratedPointerClass(structureClass=ByteDataWrapper.class)
public class ByteDataWrapperPointer
extends StructurePointer {
    public static final ByteDataWrapperPointer NULL = new ByteDataWrapperPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected ByteDataWrapperPointer(long address) {
        super(address);
    }

    public static ByteDataWrapperPointer cast(AbstractPointer structure) {
        return ByteDataWrapperPointer.cast(structure.getAddress());
    }

    public static ByteDataWrapperPointer cast(UDATA udata) {
        return ByteDataWrapperPointer.cast(udata.longValue());
    }

    public static ByteDataWrapperPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new ByteDataWrapperPointer(address);
    }

    public ByteDataWrapperPointer add(long count) {
        return ByteDataWrapperPointer.cast(this.address + ByteDataWrapper.SIZEOF * count);
    }

    public ByteDataWrapperPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public ByteDataWrapperPointer addOffset(long offset) {
        return ByteDataWrapperPointer.cast(this.address + offset);
    }

    public ByteDataWrapperPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public ByteDataWrapperPointer sub(long count) {
        return ByteDataWrapperPointer.cast(this.address - ByteDataWrapper.SIZEOF * count);
    }

    public ByteDataWrapperPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public ByteDataWrapperPointer subOffset(long offset) {
        return ByteDataWrapperPointer.cast(this.address - offset);
    }

    public ByteDataWrapperPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public ByteDataWrapperPointer untag(long mask) {
        return ByteDataWrapperPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public ByteDataWrapperPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return ByteDataWrapper.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataLengthOffset_", declaredType="U32")
    public U32 dataLength() throws CorruptDataException {
        return new U32(this.getIntAtOffset(ByteDataWrapper._dataLengthOffset_));
    }

    public U32Pointer dataLengthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U32Pointer.cast(this.address + (long)ByteDataWrapper._dataLengthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataTypeOffset_", declaredType="U8")
    public U8 dataType() throws CorruptDataException {
        return new U8(this.getByteAtOffset(ByteDataWrapper._dataTypeOffset_));
    }

    public U8Pointer dataTypeEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)ByteDataWrapper._dataTypeOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_externalBlockOffsetOffset_", declaredType="I32")
    public I32 externalBlockOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(ByteDataWrapper._externalBlockOffsetOffset_));
    }

    public I32Pointer externalBlockOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)ByteDataWrapper._externalBlockOffsetOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_inPrivateUseOffset_", declaredType="U8")
    public U8 inPrivateUse() throws CorruptDataException {
        return new U8(this.getByteAtOffset(ByteDataWrapper._inPrivateUseOffset_));
    }

    public U8Pointer inPrivateUseEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)ByteDataWrapper._inPrivateUseOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_privateOwnerIDOffset_", declaredType="U16")
    public U16 privateOwnerID() throws CorruptDataException {
        return new U16(this.getShortAtOffset(ByteDataWrapper._privateOwnerIDOffset_));
    }

    public U16Pointer privateOwnerIDEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U16Pointer.cast(this.address + (long)ByteDataWrapper._privateOwnerIDOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_tokenOffsetOffset_", declaredType="I32")
    public I32 tokenOffset() throws CorruptDataException {
        return new I32(this.getIntAtOffset(ByteDataWrapper._tokenOffsetOffset_));
    }

    public I32Pointer tokenOffsetEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)ByteDataWrapper._tokenOffsetOffset_);
    }
}

