/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.pointer.helper;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.pointer.VoidPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.types.UDATA;

public class J9ThreadHelper {
    public static VoidPointer getTLS(J9ThreadPointer threadPointer, UDATA key) throws CorruptDataException {
        return VoidPointer.cast(threadPointer.tlsEA().at(key.sub(1L)));
    }

    public static J9VMThreadPointer getVMThread(J9ThreadPointer threadPointer) throws CorruptDataException {
        return J9VMThreadPointer.cast(J9ThreadHelper.getTLS(threadPointer, J9RASHelper.getVM(DataType.getJ9RASPointer()).vmThreadKey()));
    }

    public static IOSThread getOSThread(J9ThreadPointer threadPointer) throws CorruptDataException {
        for (IOSThread iOSThread : DataType.getProcess().getThreads()) {
            if (!threadPointer.tid().eq(iOSThread.getThreadId())) continue;
            return iOSThread;
        }
        return null;
    }
}

