/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm26.j9.DataType;
import com.ibm.j9ddr.vm26.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm26.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm26.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm26.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.LinearDumper;
import com.ibm.j9ddr.vm26.tools.ddrinteractive.RamClassWalker;
import java.io.PrintStream;

public class DumpAllRamClassLinearCommand
extends Command {
    public DumpAllRamClassLinearCommand() {
        this.addCommand("dumpallramclasslinear", "[nestingThreshold]", "cfdump all J9RAMClass using the Linear RAM Class Dumper");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length > 1) {
            throw new DDRInteractiveCommandException("This debug extension accepts none or one argument!");
        }
        long nestingThreashold = args.length == 1 ? Long.valueOf(args[0]) : 1L;
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            if (null == vm) {
                throw new DDRInteractiveCommandException("Unable to find the VM in core dump!");
            }
            out.println();
            out.println("!j9javavm " + vm.getHexAddress());
            out.println();
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(vm.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer classPointer = (J9ClassPointer)classSegmentIterator.next();
                out.println("!dumpramclasslinear " + classPointer.getHexAddress());
                out.println(String.format("RAM Class '%s' at %s", J9ClassHelper.getJavaName(classPointer), classPointer.getHexAddress()));
                out.println();
                RamClassWalker classWalker = new RamClassWalker(classPointer, context);
                new LinearDumper().gatherLayoutInfo(out, classWalker, nestingThreashold);
                out.println();
            }
        }
        catch (CorruptDataException e1) {
            e1.printStackTrace();
        }
    }
}

