/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm26.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm26.j9.ROMHelp;
import com.ibm.j9ddr.vm26.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm26.pointer.helper.J9ROMMethodHelper;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9ROMMethodStructureFormatter
extends BaseStructureFormatter {
    @Override
    public FormatWalkResult postFormat(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
        J9ROMMethodPointer method;
        if (type2.equalsIgnoreCase("j9rommethod") && !(method = J9ROMMethodPointer.cast(address)).isNull()) {
            this.writeMethodName(method, out);
            this.writeNextROMMethodAddress(method, out);
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNextROMMethodAddress(J9ROMMethodPointer romMethod, PrintStream out) {
        out.print("Next ROM Method: !j9rommethod ");
        try {
            out.print("0x" + Long.toHexString(ROMHelp.nextROMMethod(romMethod).getAddress()));
        }
        catch (CorruptDataException ex) {
            out.print("<FAULT>");
        }
        finally {
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodName(J9ROMMethodPointer romMethod, PrintStream out) {
        out.print("Signature: ");
        try {
            out.print(J9ROMMethodHelper.getName(romMethod));
            out.print(J9ROMMethodHelper.getSignature(romMethod));
        }
        catch (CorruptDataException ex) {
            out.print("<FAULT>");
        }
        finally {
            out.println();
        }
    }
}

