/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.MonitorTableList;
import com.ibm.j9ddr.vm27.j9.ObjectMonitor;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantModel;
import com.ibm.j9ddr.vm27.pointer.ObjectMonitorReferencePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9TenantNativeDataPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadAbstractMonitorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ThreadHelper;
import com.ibm.j9ddr.vm27.structure.J9Consts;
import com.ibm.j9ddr.vm27.structure.J9Object;
import com.ibm.j9ddr.vm27.types.IDATA;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ObjectMonitor_V1
extends ObjectMonitor {
    private static HashMap<J9ObjectPointer, List<J9VMThreadPointer>> blockedThreadsCache;
    private J9VMThreadPointer owner;
    private long count;
    private boolean isInflated;
    private J9ObjectMonitorPointer lockword;
    private J9ThreadAbstractMonitorPointer monitor;
    private ArrayList<J9VMThreadPointer> waitingThreads;
    private ArrayList<J9VMThreadPointer> blockedThreads;
    private boolean ownerAndCountInitialized = false;
    private J9ObjectMonitorPointer j9objectMonitor;
    private J9TenantNativeDataPointer tenant;
    private J9ObjectPointer object;

    protected ObjectMonitor_V1(J9ObjectPointer object, J9TenantNativeDataPointer tenant) throws CorruptDataException {
        this.object = object;
        this.tenant = tenant;
        this.j9objectMonitor = MonitorTableList.peek(object, tenant);
        this.initializeLockword();
    }

    @Override
    public J9ObjectPointer getObject() {
        return this.object;
    }

    @Override
    public J9ObjectMonitorPointer getLockword() {
        return this.lockword;
    }

    @Override
    public J9ThreadAbstractMonitorPointer getInflatedMonitor() {
        return this.monitor;
    }

    @Override
    public J9ObjectMonitorPointer getJ9ObjectMonitorPointer() {
        return this.j9objectMonitor;
    }

    @Override
    public J9VMThreadPointer getOwner() throws CorruptDataException {
        if (!this.ownerAndCountInitialized) {
            this.initializeOwnerAndCount();
        }
        return this.owner;
    }

    @Override
    public long getCount() throws CorruptDataException {
        if (!this.ownerAndCountInitialized) {
            this.initializeOwnerAndCount();
        }
        return this.count;
    }

    @Override
    public boolean isInflated() {
        return this.isInflated;
    }

    @Override
    public boolean isInTable() {
        return this.j9objectMonitor.notNull();
    }

    @Override
    public List<J9VMThreadPointer> getWaitingThreads() throws CorruptDataException {
        if (this.waitingThreads == null) {
            this.initializeWaitingThreads();
        }
        return this.waitingThreads;
    }

    @Override
    public List<J9VMThreadPointer> getBlockedThreads() throws CorruptDataException {
        if (this.blockedThreads == null) {
            this.initializeBlockedThreads();
        }
        return this.blockedThreads;
    }

    @Override
    public boolean isContended() throws CorruptDataException {
        if (this.isInflated) {
            return this.getBlockedThreads().size() > 0;
        }
        return this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_FLC);
    }

    private void initializeOwnerAndCount() throws CorruptDataException {
        if (this.isInflated) {
            J9ThreadPointer osOwner = this.monitor.owner();
            if (osOwner.notNull()) {
                this.owner = J9ThreadHelper.getVMThread(osOwner);
                this.count = this.monitor.count().longValue();
                if (this.count == 0L) {
                    this.owner = J9VMThreadPointer.NULL;
                }
            } else {
                this.owner = J9VMThreadPointer.NULL;
            }
        } else {
            this.owner = J9VMThreadPointer.cast(this.lockword.untag(J9Object.OBJECT_HEADER_LOCK_BITS_MASK));
            if (this.owner.notNull()) {
                UDATA base = UDATA.cast(this.lockword).bitAnd(J9Object.OBJECT_HEADER_LOCK_BITS_MASK).rightShift((int)J9Object.OBJECT_HEADER_LOCK_RECURSION_OFFSET);
                if (J9BuildFlags.thr_lockReservation) {
                    if (!this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_RESERVED)) {
                        base = base.add(1L);
                    }
                    this.count = base.longValue();
                } else {
                    this.count = base.add(1L).longValue();
                }
                if (this.count == 0L) {
                    this.owner = J9VMThreadPointer.NULL;
                }
            }
        }
        this.ownerAndCountInitialized = true;
    }

    private void initializeWaitingThreads() throws CorruptDataException {
        this.waitingThreads = new ArrayList();
        if (!this.isInflated) {
            return;
        }
        J9ThreadPointer thread = this.monitor.waiting();
        while (thread.notNull()) {
            J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(thread);
            if (vmThread.notNull()) {
                this.waitingThreads.add(vmThread);
            }
            thread = thread.next();
        }
    }

    private void initializeBlockedThreads() throws CorruptDataException {
        this.blockedThreads = new ArrayList();
        if (this.isInflated) {
            if (J9BuildFlags.thr_threeTierLocking) {
                J9ThreadPointer thread = this.monitor.blocking();
                while (thread.notNull()) {
                    J9VMThreadPointer vmThread = J9ThreadHelper.getVMThread(thread);
                    if (vmThread.notNull()) {
                        this.blockedThreads.add(vmThread);
                    }
                    thread = thread.next();
                }
            } else {
                List<J9VMThreadPointer> list = ObjectMonitor_V1.getBlockedThreads(this.object);
                if (list != null) {
                    this.blockedThreads.addAll(list);
                }
            }
        } else {
            List<J9VMThreadPointer> list = ObjectMonitor_V1.getBlockedThreads(this.object);
            if (list != null) {
                this.blockedThreads.addAll(list);
            }
        }
    }

    private void initializeLockword() throws CorruptDataException {
        this.lockword = J9ObjectMonitorPointer.NULL;
        if (J9BuildFlags.thr_lockNursery) {
            IDATA lockOffset = new IDATA(J9ObjectHelper.clazz(this.object).lockOffset());
            if (lockOffset.gte(new IDATA(0L))) {
                this.lockword = ObjectMonitorReferencePointer.cast(this.object.addOffset(lockOffset.longValue())).at(0L);
            } else if (this.j9objectMonitor.notNull()) {
                this.lockword = this.j9objectMonitor.alternateLockword();
            }
        } else {
            this.lockword = J9ObjectMonitorPointer.cast(J9ObjectHelper.monitor(this.object));
        }
        if (this.lockword.notNull()) {
            this.isInflated = this.lockword.allBitsIn(J9Object.OBJECT_HEADER_LOCK_INFLATED);
            if (this.isInflated) {
                this.monitor = J9ThreadAbstractMonitorPointer.cast(this.j9objectMonitor.monitor());
            }
        }
    }

    private static List<J9VMThreadPointer> getBlockedThreads(J9ObjectPointer blockingObject) throws CorruptDataException {
        if (blockedThreadsCache == null) {
            blockedThreadsCache = new HashMap();
            GCVMThreadListIterator iterator = GCVMThreadListIterator.from();
            while (iterator.hasNext()) {
                J9ObjectPointer object;
                J9VMThreadPointer vmThread = iterator.next();
                if (!vmThread.publicFlags().allBitsIn(J9Consts.J9_PUBLIC_FLAGS_THREAD_BLOCKED) || !(object = vmThread.blockingEnterObject()).notNull()) continue;
                List<J9VMThreadPointer> list = blockedThreadsCache.get(object);
                if (list == null) {
                    list = new ArrayList<J9VMThreadPointer>();
                    blockedThreadsCache.put(object, list);
                }
                list.add(vmThread);
            }
        }
        return blockedThreadsCache.get(blockingObject);
    }

    public int hashCode() {
        if (this.lockword != null) {
            return this.lockword.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public int compareTo(ObjectMonitor objectMonitor) {
        int result = 0;
        ObjectMonitor_V1 objectMonitor_V1 = (ObjectMonitor_V1)objectMonitor;
        result = this.object.compare(objectMonitor_V1.object);
        if (TenantModel.isTenantEnabled() && 0 == result) {
            result = this.tenant.compare(objectMonitor_V1.tenant);
        }
        return result;
    }
}

