/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.Pool;
import com.ibm.j9ddr.vm27.j9.SlotIterator;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.U32Pointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9PoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9PoolPuddleListPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9PoolPuddlePointer;
import java.util.NoSuchElementException;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pool_27_V0<StructType extends DataType>
extends Pool<StructType>
implements SlotIterator<StructType> {
    private static int POOLSTATE_FOLLOW_NEXT_POINTERS = 1;
    private final boolean isInline;
    private final State state = new State();
    private int slot = 0;
    private VoidPointer nextItem = null;
    StructType nextStruct = null;
    boolean inited = false;

    protected <T extends DataType> Pool_27_V0(J9PoolPointer structure, Class<T> structType, boolean isInline) throws CorruptDataException {
        super(structure, structType);
        this.isInline = isInline;
    }

    @Override
    public boolean includesElement(StructType anElement) {
        throw new RuntimeException("Unimplemented");
    }

    @Override
    public SlotIterator<StructType> iterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        if (this.nextStruct != null) {
            return true;
        }
        try {
            this.nextItem = !this.inited ? this.pool_startDo() : this.pool_nextDo();
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error creating iterator", e, true);
            this.nextItem = null;
        }
        finally {
            this.inited = true;
        }
        while (this.nextItem != null && this.nextItem.notNull()) {
            try {
                if (!this.isInline) {
                    PointerPointer ptr = PointerPointer.cast(this.nextItem);
                    this.nextItem = ptr.at(0L);
                }
                this.nextStruct = (DataType)DataType.getStructure(this.structType, this.nextItem.getAddress());
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error getting next pool item", e, false);
            }
            if (this.nextStruct != null) break;
            try {
                this.nextItem = this.pool_nextDo();
            }
            catch (CorruptDataException e) {
                EventManager.raiseCorruptDataEvent("Error creating iterator", e, true);
                this.nextItem = null;
            }
        }
        return this.nextStruct != null;
    }

    @Override
    public StructType next() {
        if (this.hasNext()) {
            StructType next = this.nextStruct;
            this.nextStruct = null;
            return next;
        }
        throw new NoSuchElementException();
    }

    @Override
    public VoidPointer nextAddress() {
        if (this.hasNext()) {
            this.nextStruct = null;
            return this.nextItem;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long numElements() {
        try {
            return J9PoolPuddleListPointer.cast(this.pool.puddleList()).numElements().longValue();
        }
        catch (CorruptDataException e) {
            return 0L;
        }
    }

    @Override
    public long capacity() {
        long numElements = 0L;
        try {
            J9PoolPuddleListPointer puddleList = J9PoolPuddleListPointer.cast(this.pool.puddleList());
            J9PoolPuddlePointer walk = puddleList.nextPuddle();
            while (!walk.isNull()) {
                numElements += this.pool.elementsPerPuddle().longValue();
                walk = walk.nextPuddle();
            }
        }
        catch (CorruptDataException e) {
            return 0L;
        }
        return numElements;
    }

    private VoidPointer pool_startDo() throws CorruptDataException {
        this.slot = 0;
        J9PoolPuddleListPointer puddleList = J9PoolPuddleListPointer.cast(this.pool.puddleList());
        return this.poolPuddle_startDo(puddleList.nextPuddle(), true);
    }

    private VoidPointer poolPuddle_startDo(J9PoolPuddlePointer currentPuddle, boolean followNextPointers) throws CorruptDataException {
        UDATAPointer currAddr = null;
        if (this.pool.isNull() || currentPuddle.isNull()) {
            return null;
        }
        if (currentPuddle.usedElements().longValue() == 0L) {
            if (currentPuddle.nextPuddle().notNull() && followNextPointers) {
                return this.poolPuddle_startDo(currentPuddle.nextPuddle(), followNextPointers);
            }
            return null;
        }
        while (this.isPuddleSlotFree(currentPuddle)) {
            ++this.slot;
        }
        currAddr = UDATAPointer.cast(currentPuddle.firstElementAddress().getAddress() + this.elementSize * (long)this.slot);
        this.state.currentPuddle = currentPuddle;
        this.state.lastSlot = this.slot;
        this.state.leftToDo = currentPuddle.usedElements().intValue() - 1;
        this.state.flags = 0;
        if (followNextPointers) {
            this.state.flags |= POOLSTATE_FOLLOW_NEXT_POINTERS;
        }
        if (this.state.leftToDo == 0) {
            if (followNextPointers) {
                this.state.currentPuddle = this.state.currentPuddle.nextPuddle();
                this.state.lastSlot = -1;
            } else {
                this.state.currentPuddle = null;
            }
        }
        logger.fine(String.format("Next pool item 0x%016x", currAddr.getAddress()));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.state.toString());
        }
        return VoidPointer.cast(currAddr);
    }

    private boolean isPuddleSlotFree(J9PoolPuddlePointer currentPuddle) throws CorruptDataException {
        int bitmask;
        U32Pointer ptr = U32Pointer.cast(currentPuddle.add(1L));
        long value = (ptr = ptr.add(this.slot / 32)).at(0L).longValue();
        return (value & (long)(bitmask = 1 << 31 - this.slot % 32)) != 0L;
    }

    private VoidPointer pool_nextDo() throws CorruptDataException {
        this.slot = 1 + this.state.lastSlot;
        UDATAPointer currAddr = null;
        if (this.state.leftToDo == 0) {
            if (this.state.currentPuddle != null && this.state.currentPuddle.notNull()) {
                return this.poolPuddle_startDo(this.state.currentPuddle, true);
            }
            return null;
        }
        while (this.isPuddleSlotFree(this.state.currentPuddle)) {
            ++this.slot;
        }
        currAddr = UDATAPointer.cast(this.state.currentPuddle.firstElementAddress().getAddress() + this.elementSize * (long)this.slot);
        this.state.lastSlot = this.slot;
        --this.state.leftToDo;
        if (this.state.leftToDo == 0) {
            if ((this.state.flags & POOLSTATE_FOLLOW_NEXT_POINTERS) == POOLSTATE_FOLLOW_NEXT_POINTERS) {
                this.state.currentPuddle = this.state.currentPuddle.nextPuddle();
                this.state.lastSlot = -1;
            } else {
                this.state.currentPuddle = null;
            }
        }
        logger.fine(String.format("Next pool item 0x%016x", currAddr.getAddress()));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.state.toString());
        }
        return VoidPointer.cast(currAddr);
    }

    private class State {
        J9PoolPuddlePointer currentPuddle = null;
        int lastSlot = 0;
        int leftToDo = 0;
        int flags = 0;

        private State() {
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Pool walker state\n\tCurrent Puddle : 0x");
            builder.append(Long.toHexString(this.currentPuddle.getAddress()));
            builder.append("\n\tLast Slot : ");
            builder.append(this.lastSlot);
            builder.append("\n\tLeft to do : ");
            builder.append(this.leftToDo);
            builder.append("\n\tFlags : ");
            builder.append(this.flags);
            return builder.toString();
        }
    }
}

