/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.AlgorithmPicker;
import com.ibm.j9ddr.vm27.j9.BaseAlgorithm;
import com.ibm.j9ddr.vm27.j9.IAlgorithm;
import com.ibm.j9ddr.vm27.pointer.SelfRelativePointer;
import com.ibm.j9ddr.vm27.pointer.U32Pointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ConstantPoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ExceptionHandlerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ExceptionInfoPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodDebugInfoPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ROMMethodHelper;
import com.ibm.j9ddr.vm27.structure.J9Consts;
import com.ibm.j9ddr.vm27.structure.J9ExceptionHandler;
import com.ibm.j9ddr.vm27.structure.J9ExceptionInfo;
import com.ibm.j9ddr.vm27.structure.J9JavaAccessFlags;
import com.ibm.j9ddr.vm27.structure.J9ROMMethod;
import com.ibm.j9ddr.vm27.types.U16;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.U8;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.LinkedList;

public class ROMHelp {
    private static final AlgorithmPicker<IROMHelpImpl> picker = new AlgorithmPicker<IROMHelpImpl>("ALG_ROM_HELP_VERSION"){

        @Override
        protected Iterable<? extends IROMHelpImpl> allAlgorithms() {
            LinkedList<ROMHelp_27_V0> list = new LinkedList<ROMHelp_27_V0>();
            list.add(new ROMHelp_27_V0());
            return list;
        }
    };
    private static IROMHelpImpl impl;

    private static IROMHelpImpl getImpl() {
        if (impl == null) {
            impl = picker.pickAlgorithm();
        }
        return impl;
    }

    public static J9ROMMethodPointer getOriginalROMMethod(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().getOriginalROMMethod(method);
    }

    public static J9ROMMethodPointer nextROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().nextROMMethod(romMethod);
    }

    public static U32Pointer getMethodAnnotationsDataFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().getMethodAnnotationsDataFromROMMethod(romMethod);
    }

    public static U32Pointer getParameterAnnotationsDataFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().getParameterAnnotationsDataFromROMMethod(romMethod);
    }

    public static U32Pointer getDefaultAnnotationDataFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().getDefaultAnnotationDataFromROMMethod(romMethod);
    }

    public static J9MethodDebugInfoPointer getMethodDebugInfoFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().getMethodDebugInfoFromROMMethod(romMethod);
    }

    public static SelfRelativePointer J9EXCEPTIONINFO_THROWNAMES(J9ExceptionInfoPointer info) throws CorruptDataException {
        return ROMHelp.getImpl().J9EXCEPTIONINFO_THROWNAMES(info);
    }

    public static J9ExceptionHandlerPointer J9EXCEPTIONINFO_HANDLERS(J9ExceptionInfoPointer info) throws CorruptDataException {
        return ROMHelp.getImpl().J9EXCEPTIONINFO_HANDLERS(info);
    }

    public static J9ExceptionInfoPointer J9_EXCEPTION_DATA_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
    }

    public static U32Pointer J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(romMethod);
    }

    public static UDATA J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
    }

    public static UDATA J9_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod);
    }

    public static U8Pointer J9_BYTECODE_START_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_BYTECODE_START_FROM_ROM_METHOD(method);
    }

    public static J9ROMMethodPointer J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_ROM_METHOD_FROM_RAM_METHOD(method);
    }

    public static J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_CLASS_FROM_METHOD(method);
    }

    public static U8 J9_ARG_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_ARG_COUNT_FROM_ROM_METHOD(method);
    }

    public static U16 J9_TEMP_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9_TEMP_COUNT_FROM_ROM_METHOD(method);
    }

    public static J9UTF8Pointer J9ROMMETHOD_SIGNATURE(J9ROMMethodPointer method) throws CorruptDataException {
        return ROMHelp.getImpl().J9ROMMETHOD_SIGNATURE(method);
    }

    public static U32Pointer getStackMapFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
        return ROMHelp.getImpl().getStackMapFromROMMethod(romMethod);
    }

    private static interface IROMHelpImpl
    extends IAlgorithm {
        public J9ROMMethodPointer getOriginalROMMethod(J9MethodPointer var1) throws CorruptDataException;

        public J9ROMMethodPointer nextROMMethod(J9ROMMethodPointer var1) throws CorruptDataException;

        public U32Pointer getMethodAnnotationsDataFromROMMethod(J9ROMMethodPointer var1) throws CorruptDataException;

        public U32Pointer getParameterAnnotationsDataFromROMMethod(J9ROMMethodPointer var1) throws CorruptDataException;

        public U32Pointer getDefaultAnnotationDataFromROMMethod(J9ROMMethodPointer var1) throws CorruptDataException;

        public J9MethodDebugInfoPointer getMethodDebugInfoFromROMMethod(J9ROMMethodPointer var1) throws CorruptDataException;

        public SelfRelativePointer J9EXCEPTIONINFO_THROWNAMES(J9ExceptionInfoPointer var1) throws CorruptDataException;

        public J9ExceptionHandlerPointer J9EXCEPTIONINFO_HANDLERS(J9ExceptionInfoPointer var1) throws CorruptDataException;

        public J9ExceptionInfoPointer J9_EXCEPTION_DATA_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public U32Pointer J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public UDATA J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public UDATA J9_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public U8Pointer J9_BYTECODE_START_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public J9ROMMethodPointer J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer var1) throws CorruptDataException;

        public J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer var1) throws CorruptDataException;

        public U8 J9_ARG_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public U16 J9_TEMP_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer var1) throws CorruptDataException;

        public J9UTF8Pointer J9ROMMETHOD_SIGNATURE(J9ROMMethodPointer var1) throws CorruptDataException;

        public U32Pointer getStackMapFromROMMethod(J9ROMMethodPointer var1) throws CorruptDataException;
    }

    private static class ROMHelp_27_V0
    extends BaseAlgorithm
    implements IROMHelpImpl {
        protected ROMHelp_27_V0() {
            super(70, 0);
        }

        public J9ROMMethodPointer getOriginalROMMethod(J9MethodPointer method) throws CorruptDataException {
            J9ClassPointer methodClass = this.J9_CLASS_FROM_METHOD(method);
            J9ROMClassPointer romClass = methodClass.romClass();
            J9ROMMethodPointer romMethod = this.J9_ROM_METHOD_FROM_RAM_METHOD(method);
            U8Pointer bytecodes = this.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod);
            if (bytecodes.lt(romClass) || bytecodes.gte(romClass.addOffset(romClass.romSize()))) {
                romMethod = romClass.romMethods();
                for (long methodIndex = UDATA.cast(method).sub(UDATA.cast(methodClass.ramMethods())).longValue(); methodIndex > 0L; --methodIndex) {
                    romMethod = this.nextROMMethod(romMethod);
                }
            }
            return romMethod;
        }

        private J9ROMMethodPointer skipOverLengthDataAndPadding(J9ROMMethodPointer annotation) throws CorruptDataException {
            J9ROMMethodPointer result = annotation;
            UDATA size = U32.roundToSizeofU32(new UDATA(U32Pointer.cast(annotation).at(0L)));
            result = result.addOffset(4L);
            result = result.addOffset(size);
            return result;
        }

        public J9ROMMethodPointer nextROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            boolean hasExceptionInfo = J9ROMMethodHelper.hasExceptionInfo(romMethod);
            boolean hasMethodAnnotations = J9ROMMethodHelper.hasMethodAnnotations(romMethod);
            boolean hasParameterAnnotations = J9ROMMethodHelper.hasParameterAnnotations(romMethod);
            boolean hasDefaultAnnotation = J9ROMMethodHelper.hasDefaultAnnotation(romMethod);
            boolean hasDebugInfo = J9ROMMethodHelper.hasDebugInfo(romMethod);
            boolean hasStackMap = J9ROMMethodHelper.hasStackMap(romMethod);
            J9ExceptionInfoPointer exceptionInfo = this.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
            J9ROMMethodPointer result = hasExceptionInfo ? J9ROMMethodPointer.cast(this.J9EXCEPTIONINFO_THROWNAMES(exceptionInfo).add(exceptionInfo.throwCount())) : J9ROMMethodPointer.cast(exceptionInfo);
            if (hasMethodAnnotations) {
                result = this.skipOverLengthDataAndPadding(result);
            }
            if (hasParameterAnnotations) {
                result = this.skipOverLengthDataAndPadding(result);
            }
            if (hasDefaultAnnotation) {
                result = this.skipOverLengthDataAndPadding(result);
            }
            if (hasDebugInfo) {
                U32 taggedSizeOrSRP = U32Pointer.cast(result).at(0L);
                result = taggedSizeOrSRP.allBitsIn(1L) ? result.addOffset(taggedSizeOrSRP.bitAnd(-2)) : result.addOffset(4L);
            }
            if (hasStackMap) {
                result = result.addOffset(U32Pointer.cast(result).at(0L));
            }
            return result;
        }

        private U32Pointer methodAnnotationsDataFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            boolean hasExceptionInfo = J9ROMMethodHelper.hasExceptionInfo(romMethod);
            J9ExceptionInfoPointer exceptionInfo = this.J9_EXCEPTION_DATA_FROM_ROM_METHOD(romMethod);
            J9ROMMethodPointer result = hasExceptionInfo ? J9ROMMethodPointer.cast(this.J9EXCEPTIONINFO_THROWNAMES(exceptionInfo).add(exceptionInfo.throwCount())) : J9ROMMethodPointer.cast(exceptionInfo);
            return U32Pointer.cast(result);
        }

        public U32Pointer getMethodAnnotationsDataFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            boolean hasMethodAnnotations = J9ROMMethodHelper.hasMethodAnnotations(romMethod);
            if (hasMethodAnnotations) {
                return this.methodAnnotationsDataFromROMMethod(romMethod);
            }
            return U32Pointer.NULL;
        }

        private U32Pointer parameterAnnotationsFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            J9ROMMethodPointer result = J9ROMMethodPointer.cast(this.methodAnnotationsDataFromROMMethod(romMethod));
            boolean hasMethodAnnotations = J9ROMMethodHelper.hasMethodAnnotations(romMethod);
            if (hasMethodAnnotations) {
                result = this.skipOverLengthDataAndPadding(result);
            }
            return U32Pointer.cast(result);
        }

        public U32Pointer getParameterAnnotationsDataFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            boolean hasParameterAnnotations = J9ROMMethodHelper.hasParameterAnnotations(romMethod);
            if (hasParameterAnnotations) {
                return this.parameterAnnotationsFromROMMethod(romMethod);
            }
            return U32Pointer.NULL;
        }

        private U32Pointer defaultAnnotationFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            J9ROMMethodPointer result = J9ROMMethodPointer.cast(this.parameterAnnotationsFromROMMethod(romMethod));
            boolean hasParameterAnnotations = J9ROMMethodHelper.hasParameterAnnotations(romMethod);
            if (hasParameterAnnotations) {
                result = this.skipOverLengthDataAndPadding(result);
            }
            return U32Pointer.cast(result);
        }

        public U32Pointer getDefaultAnnotationDataFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            boolean hasDefaultAnnotation = J9ROMMethodHelper.hasDefaultAnnotation(romMethod);
            if (hasDefaultAnnotation) {
                return this.defaultAnnotationFromROMMethod(romMethod);
            }
            return U32Pointer.NULL;
        }

        private J9MethodDebugInfoPointer methodDebugInfoFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            J9ROMMethodPointer result = J9ROMMethodPointer.cast(this.defaultAnnotationFromROMMethod(romMethod));
            boolean hasDefaultAnnotation = J9ROMMethodHelper.hasDefaultAnnotation(romMethod);
            if (hasDefaultAnnotation) {
                result = this.skipOverLengthDataAndPadding(result);
            }
            return J9MethodDebugInfoPointer.cast(result);
        }

        public J9MethodDebugInfoPointer getMethodDebugInfoFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            boolean hasDebugInfo = J9ROMMethodHelper.hasDebugInfo(romMethod);
            if (hasDebugInfo) {
                J9MethodDebugInfoPointer result = this.methodDebugInfoFromROMMethod(romMethod);
                U32 taggedSizeOrSRP = U32Pointer.cast(result).at(0L);
                if (taggedSizeOrSRP.allBitsIn(1L)) {
                    return result;
                }
                return J9MethodDebugInfoPointer.cast(SelfRelativePointer.cast(result).get());
            }
            return J9MethodDebugInfoPointer.NULL;
        }

        public U32Pointer stackMapFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            boolean hasDebugInfo = J9ROMMethodHelper.hasDebugInfo(romMethod);
            J9MethodDebugInfoPointer debugInfo = this.methodDebugInfoFromROMMethod(romMethod);
            U32Pointer result = U32Pointer.cast(debugInfo);
            if (hasDebugInfo) {
                U32 taggedSizeOrSRP = U32Pointer.cast(debugInfo).at(0L);
                result = taggedSizeOrSRP.allBitsIn(1L) ? result.addOffset(taggedSizeOrSRP.bitAnd(-2)) : result.addOffset(4L);
            }
            return result;
        }

        public U32Pointer getStackMapFromROMMethod(J9ROMMethodPointer romMethod) throws CorruptDataException {
            if (J9ROMMethodHelper.hasStackMap(romMethod)) {
                return this.stackMapFromROMMethod(romMethod);
            }
            return U32Pointer.NULL;
        }

        public SelfRelativePointer J9EXCEPTIONINFO_THROWNAMES(J9ExceptionInfoPointer info) throws CorruptDataException {
            return SelfRelativePointer.cast(this.J9EXCEPTIONINFO_HANDLERS(info).addOffset(new U32(info.catchCount()).mult((int)J9ExceptionHandler.SIZEOF)));
        }

        public J9ExceptionHandlerPointer J9EXCEPTIONINFO_HANDLERS(J9ExceptionInfoPointer info) throws CorruptDataException {
            return J9ExceptionHandlerPointer.cast(info.addOffset(J9ExceptionInfo.SIZEOF));
        }

        public J9ExceptionInfoPointer J9_EXCEPTION_DATA_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            U32Pointer sigAddr = this.J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(romMethod);
            if (romMethod.modifiers().anyBitsIn(J9JavaAccessFlags.J9AccMethodHasGenericSignature)) {
                sigAddr = sigAddr.add(1L);
            }
            return J9ExceptionInfoPointer.cast(sigAddr);
        }

        public U32Pointer J9_GENERIC_SIG_ADDR_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            return U32Pointer.cast(this.J9_BYTECODE_START_FROM_ROM_METHOD(romMethod).addOffset(this.J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod)));
        }

        public UDATA J9_ROUNDED_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            return this.J9_BYTECODE_SIZE_FROM_ROM_METHOD(romMethod).add(3L).bitAnd(new UDATA(3L).bitNot());
        }

        public UDATA J9_BYTECODE_SIZE_FROM_ROM_METHOD(J9ROMMethodPointer romMethod) throws CorruptDataException {
            return new UDATA(romMethod.bytecodeSizeLow()).add(new UDATA(romMethod.bytecodeSizeHigh()).leftShift(16));
        }

        public U8Pointer J9_BYTECODE_START_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
            return U8Pointer.cast(method).add(J9ROMMethod.SIZEOF);
        }

        public J9ROMMethodPointer J9_ROM_METHOD_FROM_RAM_METHOD(J9MethodPointer method) throws CorruptDataException {
            return J9ROMMethodPointer.cast(method.bytecodes().sub(J9ROMMethod.SIZEOF));
        }

        public J9ClassPointer J9_CLASS_FROM_METHOD(J9MethodPointer method) throws CorruptDataException {
            J9ConstantPoolPointer cp = method.constantPool().untag(J9Consts.J9_STARTPC_STATUS);
            return cp.ramClass();
        }

        public U8 J9_ARG_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
            return method.argCount();
        }

        public U16 J9_TEMP_COUNT_FROM_ROM_METHOD(J9ROMMethodPointer method) throws CorruptDataException {
            return method.tempCount();
        }

        public J9UTF8Pointer J9ROMMETHOD_SIGNATURE(J9ROMMethodPointer method) throws CorruptDataException {
            return method.nameAndSignature().signature();
        }
    }
}

