/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.AlgorithmVersion;
import com.ibm.j9ddr.vm27.j9.gc.GCArrayletObjectModel_V1;
import com.ibm.j9ddr.vm27.j9.gc.GCBase;
import com.ibm.j9ddr.vm27.j9.gc.GCContiguousArrayObjectModel_V1;
import com.ibm.j9ddr.vm27.j9.gc.GCPackedArrayObjectModel_V1;
import com.ibm.j9ddr.vm27.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9IndexableObjectHelper;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;

abstract class GCArrayObjectModel
extends GCBase {
    GCArrayObjectModel() {
    }

    public static GCArrayObjectModel from(boolean isPacked) throws CorruptDataException {
        if (isPacked) {
            if (J9BuildFlags.gc_arraylets) {
                AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_PACKED_ARRAYLET_OBJECT_MODEL_VERSION");
                switch (version.getAlgorithmVersion()) {
                    default: 
                }
                return new GCPackedArrayObjectModel_V1();
            }
            throw new UnsupportedOperationException();
        }
        if (J9BuildFlags.gc_arraylets) {
            AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_ARRAYLET_OBJECT_MODEL_VERSION");
            switch (version.getAlgorithmVersion()) {
                default: 
            }
            return new GCArrayletObjectModel_V1();
        }
        AlgorithmVersion version = AlgorithmVersion.getVersionOf("ALG_GC_CONTIGUOUS_ARRAY_OBJECT_MODEL_VERSION");
        switch (version.getAlgorithmVersion()) {
            default: 
        }
        return new GCContiguousArrayObjectModel_V1();
    }

    public abstract UDATA getSizeInBytesWithHeader(J9IndexableObjectPointer var1) throws CorruptDataException;

    public UDATA getSizeInSlotsWithHeader(J9IndexableObjectPointer array) throws CorruptDataException {
        return UDATA.convertBytesToSlots(this.getSizeInBytesWithHeader(array));
    }

    public UDATA getSizeInElements(J9IndexableObjectPointer array) throws CorruptDataException {
        U32 size = J9IndexableObjectHelper.size(array);
        if (size.anyBitsIn(Integer.MIN_VALUE)) {
            throw new CorruptDataException("java array size with sign bit set");
        }
        return new UDATA(size);
    }

    public abstract UDATA getHashcodeOffset(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getHeaderSize(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract VoidPointer getElementAddress(J9IndexableObjectPointer var1, int var2, int var3) throws CorruptDataException;

    public abstract VoidPointer getDataPointerForContiguous(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract J9ObjectPointer getTargetObject(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract ObjectReferencePointer getTargetObjectEA(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getTargetOffset(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATAPointer getTargetOffsetEA(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract boolean isPackedObjectHeader(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getPackedDataSize(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract UDATA getPackedDataSize(J9ClassPointer var1) throws CorruptDataException;

    public abstract ObjectReferencePointer getArrayoidPointer(J9IndexableObjectPointer var1) throws CorruptDataException;

    public abstract boolean isInlineContiguousArraylet(J9IndexableObjectPointer var1) throws CorruptDataException;
}

