/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.gc.GCExtensions;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCIterator;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemorySpacePointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemorySubSpacePointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import java.util.NoSuchElementException;

public class GCHeapRegionIterator
extends GCIterator {
    private MM_MemorySpacePointer _space;
    private MM_HeapRegionDescriptorPointer _auxRegion;
    private MM_HeapRegionDescriptorPointer _tableRegion;
    private MM_HeapRegionManagerPointer _regionManager;
    private long _tableDescriptorSize;
    private GCHeapRegionDescriptor currentRegion;

    protected GCHeapRegionIterator(MM_HeapRegionManagerPointer manager, MM_MemorySpacePointer space, boolean includeTableRegions, boolean includeAuxRegions) throws CorruptDataException {
        this._regionManager = manager;
        this._space = space;
        if (includeAuxRegions) {
            this._auxRegion = this._regionManager._auxRegionDescriptorList();
            if (this._auxRegion.isNull()) {
                this._auxRegion = null;
            }
        }
        if (includeTableRegions) {
            this._tableRegion = this._regionManager._regionTable();
            if (this._tableRegion.isNull()) {
                this._tableRegion = null;
            }
            this._tableDescriptorSize = this._regionManager._tableDescriptorSize().longValue();
        }
    }

    public static GCHeapRegionIterator fromMMHeapRegionManager(MM_HeapRegionManagerPointer manager, MM_MemorySpacePointer space, boolean includeTableRegions, boolean includeAuxRegions) throws CorruptDataException {
        return new GCHeapRegionIterator(manager, space, includeAuxRegions, includeTableRegions);
    }

    public static GCHeapRegionIterator from() throws CorruptDataException {
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        MM_GCExtensionsPointer gcext = GCExtensions.getGCExtensionsPointer();
        MM_HeapRegionManagerPointer hrm = gcext.heapRegionManager();
        return GCHeapRegionIterator.fromMMHeapRegionManager(hrm, true, true);
    }

    public static GCHeapRegionIterator fromMMHeapRegionManager(MM_HeapRegionManagerPointer manager, MM_MemorySpacePointer space) throws CorruptDataException {
        return new GCHeapRegionIterator(manager, space, true, true);
    }

    public static GCHeapRegionIterator fromMMHeapRegionManager(MM_HeapRegionManagerPointer manager, boolean includeTableRegions, boolean includeAuxRegions) throws CorruptDataException {
        return new GCHeapRegionIterator(manager, null, includeTableRegions, includeAuxRegions);
    }

    protected boolean shouldIncludeRegion(MM_HeapRegionDescriptorPointer region) throws CorruptDataException {
        if (null != this._space) {
            MM_MemorySubSpacePointer subspace = region._memorySubSpace();
            if (subspace.notNull()) {
                return this._space.eq(subspace._memorySpace());
            }
            return false;
        }
        return true;
    }

    protected MM_HeapRegionDescriptorPointer getNextAuxiliaryRegion(MM_HeapRegionDescriptorPointer heapRegion) throws CorruptDataException {
        MM_HeapRegionDescriptorPointer next = heapRegion._nextRegion();
        if (next.isNull()) {
            return null;
        }
        return next;
    }

    protected MM_HeapRegionDescriptorPointer getNextTableRegion(MM_HeapRegionDescriptorPointer heapRegion) throws CorruptDataException {
        MM_HeapRegionDescriptorPointer next = heapRegion.addOffset(this._tableDescriptorSize * heapRegion._regionsInSpan().longValue());
        if (next.isNull()) {
            return null;
        }
        MM_HeapRegionDescriptorPointer top = MM_HeapRegionDescriptorPointer.cast(this._regionManager._regionTable().longValue() + this._tableDescriptorSize * this._regionManager._tableRegionCount().longValue());
        MM_HeapRegionDescriptorPointer usedRegion = MM_HeapRegionDescriptorPointer.NULL;
        MM_HeapRegionDescriptorPointer current = next;
        while (usedRegion.isNull() && current.lt(top)) {
            if (current._isAllocated()) {
                usedRegion = current;
                continue;
            }
            current = current.addOffset(this._tableDescriptorSize * current._regionsInSpan().longValue());
        }
        if (usedRegion.isNull()) {
            return null;
        }
        return usedRegion;
    }

    public boolean hasNext() {
        try {
            if (null != this.currentRegion) {
                return true;
            }
            while (null != this._auxRegion || null != this._tableRegion) {
                MM_HeapRegionDescriptorPointer region = null;
                if (null != this._auxRegion && (null == this._tableRegion || this._auxRegion.lt(this._tableRegion))) {
                    region = this._auxRegion;
                    this._auxRegion = this.getNextAuxiliaryRegion(this._auxRegion);
                } else {
                    if (null == this._tableRegion) break;
                    region = this._tableRegion;
                    this._tableRegion = this.getNextTableRegion(this._tableRegion);
                }
                if (!this.shouldIncludeRegion(region)) continue;
                this.currentRegion = GCHeapRegionDescriptor.fromHeapRegionDescriptor(region);
                return true;
            }
            return false;
        }
        catch (CorruptDataException cde) {
            EventManager.raiseCorruptDataEvent("Error getting next item", cde, false);
            return false;
        }
    }

    public GCHeapRegionDescriptor next() {
        if (this.hasNext()) {
            GCHeapRegionDescriptor next = this.currentRegion;
            this.currentRegion = null;
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    public VoidPointer nextAddress() {
        throw new UnsupportedOperationException("This iterator cannot return addresses");
    }
}

