/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm27.j9.gc.GCCellLinkedFreeHeader;
import com.ibm.j9ddr.vm27.j9.gc.GCFreeListIteratorAggregatedCellList;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemoryPoolAggregatedCellListPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemoryPoolPointer;
import java.util.NoSuchElementException;

public class GCMemoryPoolAggregatedCellList
extends GCMemoryPool {
    protected MM_MemoryPoolAggregatedCellListPointer _memoryPool = null;

    protected GCMemoryPoolAggregatedCellList(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        super(region, memoryPool);
        this.init(region);
    }

    private void init(GCHeapRegionDescriptor region) throws CorruptDataException {
        this._region = region;
        this._memoryPoolType = GCMemoryPool.MemoryPoolType.SEGREGATED;
        this._memoryPool = MM_MemoryPoolAggregatedCellListPointer.cast(region.getMemoryPool());
    }

    public GCCellLinkedFreeHeader getFirstFreeEntry() throws CorruptDataException {
        return GCCellLinkedFreeHeader.fromUDATAPointer(UDATAPointer.cast(this._memoryPool._freeListHead()));
    }

    public void checkFreeListsImpl() {
        try {
            GCFreeListIteratorAggregatedCellList freeEntryIterator = this.getFreeListIterator();
            GCCellLinkedFreeHeader previousFreeEntry = null;
            while (freeEntryIterator.hasNext()) {
                GCCellLinkedFreeHeader freeListEntry = freeEntryIterator.next();
                try {
                    this.freeEntryCheck(freeListEntry, previousFreeEntry);
                    previousFreeEntry = freeListEntry;
                }
                catch (CorruptFreeEntryException e) {
                    EventManager.raiseCorruptDataEvent("Free list corruption detected", e, false);
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("Corruption detected in free entry", e, false);
                }
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Data corruption detected while validating freelists", e, false);
        }
    }

    public GCFreeListIteratorAggregatedCellList getFreeListIterator() throws CorruptDataException {
        if (this.getRegion().containsObjects()) {
            return new GCFreeListIteratorAggregatedCellList(this);
        }
        return new GCFreeListIteratorAggregatedCellList(this){

            public GCCellLinkedFreeHeader next() throws NoSuchElementException {
                throw new NoSuchElementException("No more elements available though this iterator");
            }

            public boolean hasNext() {
                return false;
            }

            public String toString() {
                return "";
            }
        };
    }

    private void freeEntryCheck(GCCellLinkedFreeHeader freeListEntry, GCCellLinkedFreeHeader previousFreeEntry) throws CorruptFreeEntryException, CorruptDataException {
        this.freeEntryCheckGeneric(freeListEntry.getHeapLinkedHeader());
        if (previousFreeEntry != null && previousFreeEntry.getHeapLinkedHeader().getHeader().lte(freeListEntry.getHeapLinkedHeader().getHeader())) {
            throw new CorruptFreeEntryException("invalidOrdering", freeListEntry.getHeapLinkedHeader().getHeader());
        }
    }
}

