/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.util.IteratorHelpers;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.gc.CorruptFreeEntryException;
import com.ibm.j9ddr.vm27.j9.gc.CorruptHintException;
import com.ibm.j9ddr.vm27.j9.gc.GCBase;
import com.ibm.j9ddr.vm27.j9.gc.GCFreeListHeapIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCFreeListHeapIteratorSplitAddressOrderedList;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapLinkedFreeHeader;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCMemoryPool;
import com.ibm.j9ddr.vm27.j9.gc.GCModronAllocateHintIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCModronAllocateHintIteratorSAOL;
import com.ibm.j9ddr.vm27.pointer.generated.J9ModronAllocateHintPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ModronFreeListPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapLinkedFreeHeaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemoryPoolPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_MemoryPoolSplitAddressOrderedListPointer;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class GCMemoryPoolSplitAddressOrderedList
extends GCMemoryPool {
    protected UDATA _heapFreeListCount = new UDATA(0L);
    protected MM_MemoryPoolSplitAddressOrderedListPointer _memoryPool = null;
    protected J9ModronFreeListPointer _heapFreeLists = null;
    protected GCHeapRegionDescriptor _region = null;

    protected GCMemoryPoolSplitAddressOrderedList(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        super(region, memoryPool);
        this.init(region, memoryPool);
    }

    private void init(GCHeapRegionDescriptor region, MM_MemoryPoolPointer memoryPool) throws CorruptDataException {
        this._region = region;
        this._memoryPoolType = GCMemoryPool.MemoryPoolType.SAOL;
        this._memoryPool = MM_MemoryPoolSplitAddressOrderedListPointer.cast(memoryPool);
        this._heapFreeLists = this._memoryPool._heapFreeLists();
        this._heapFreeListCount = this._memoryPool._heapFreeListCount();
    }

    public UDATA getFreeListCount() throws CorruptDataException {
        return this._heapFreeListCount;
    }

    public GCModronAllocateHintIterator hintIterator() throws CorruptDataException {
        return new GCModronAllocateHintIteratorSAOL(this);
    }

    public GCHeapLinkedFreeHeader getFirstEntryAtFreeListIndex(UDATA freeListArrayIndex) throws CorruptDataException {
        return GCHeapLinkedFreeHeader.fromLinkedFreeHeaderPointer(this._heapFreeLists.add(freeListArrayIndex)._freeList());
    }

    public J9ModronAllocateHintPointer getFirstHintForFreeList(UDATA freeListArrayIndex) throws CorruptDataException {
        return this._heapFreeLists.add(freeListArrayIndex)._hintActive();
    }

    private void freeEntryCheck(GCHeapLinkedFreeHeader freeListEntry, GCHeapLinkedFreeHeader previousFreeEntry) throws CorruptFreeEntryException, CorruptDataException {
        MM_HeapLinkedFreeHeaderPointer freeEntryPointer = freeListEntry.getHeader();
        MM_HeapLinkedFreeHeaderPointer previousFreeEntryPointer = MM_HeapLinkedFreeHeaderPointer.NULL;
        this.freeEntryCheckGeneric(freeListEntry);
        if (null != previousFreeEntry && (previousFreeEntryPointer = previousFreeEntry.getHeader()).gte(freeEntryPointer)) {
            throw new CorruptFreeEntryException("invalidOrdering", freeEntryPointer);
        }
        if (freeListEntry.getSize().lt(GCBase.getExtensions().tlhMinimumSize())) {
            throw new CorruptFreeEntryException("sizeFieldInvalid", freeListEntry.getHeader());
        }
    }

    public GCFreeListHeapIterator freeListIterator() throws CorruptDataException {
        return new GCFreeListHeapIteratorSplitAddressOrderedList(this);
    }

    public void checkFreeListsImpl() {
        try {
            GCFreeListHeapIterator freeEntryIterator = this.freeListIterator();
            GCHeapLinkedFreeHeader previousFreeEntry = null;
            J9ModronAllocateHintPointer hint = null;
            MM_HeapLinkedFreeHeaderPointer freeEntryFromHint = null;
            List hints = IteratorHelpers.toList(this.hintIterator());
            Collections.sort(hints, new Comparator<J9ModronAllocateHintPointer>(){

                @Override
                public int compare(J9ModronAllocateHintPointer o1, J9ModronAllocateHintPointer o2) {
                    try {
                        if (o2.heapFreeHeader().gt(o1.heapFreeHeader())) {
                            return -1;
                        }
                        if (o2.heapFreeHeader().eq(o1.heapFreeHeader())) {
                            return 0;
                        }
                        return 1;
                    }
                    catch (CorruptDataException e) {
                        EventManager.raiseCorruptDataEvent("corruption detected in allocation hints", e, false);
                        throw new UnsupportedOperationException("Unreachable");
                    }
                }
            });
            Iterator allocHintIterator = hints.iterator();
            if (allocHintIterator.hasNext()) {
                hint = (J9ModronAllocateHintPointer)allocHintIterator.next();
                freeEntryFromHint = hint.heapFreeHeader();
            }
            while (freeEntryIterator.hasNext()) {
                GCHeapLinkedFreeHeader freeListEntry = freeEntryIterator.next();
                try {
                    this.freeEntryCheck(freeListEntry, previousFreeEntry);
                    previousFreeEntry = freeListEntry;
                }
                catch (CorruptFreeEntryException e) {
                    EventManager.raiseCorruptDataEvent("Free list corruption detected", e, false);
                }
                catch (CorruptDataException e) {
                    EventManager.raiseCorruptDataEvent("Corruption detected in free entry", e, false);
                }
                MM_HeapLinkedFreeHeaderPointer freeListEntryPointer = freeListEntry.getHeader();
                while (null != freeEntryFromHint && freeEntryFromHint.lte(freeListEntryPointer)) {
                    if (freeEntryFromHint.lt(freeListEntryPointer)) {
                        throw new CorruptHintException("allocHintFreeEntryCorrupt", hint);
                    }
                    if (allocHintIterator.hasNext()) {
                        hint = (J9ModronAllocateHintPointer)allocHintIterator.next();
                        freeEntryFromHint = hint.heapFreeHeader();
                        continue;
                    }
                    freeEntryFromHint = null;
                }
            }
            if (null != freeEntryFromHint) {
                EventManager.raiseCorruptDataEvent("Hint corruption detected ", new CorruptHintException("allocHintFreeEntryCorrupt", hint), false);
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Data corruption detected while validating freelists", e, false);
        }
    }
}

