/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.ObjectModel;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm27.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.HashMap;
import java.util.NoSuchElementException;

class GCMixedObjectIterator_V1
extends GCObjectIterator {
    protected static final HashMap<J9ClassPointer, boolean[]> descriptionCache = new HashMap();
    protected ObjectReferencePointer data;
    protected boolean[] descriptionArray;
    protected int scanIndex;
    protected int scanLimit;
    protected int bytesInObjectSlot;
    protected int objectsInDescriptionSlot;

    protected static void setCache(J9ClassPointer clazz, boolean[] description) {
        descriptionCache.put(clazz, description);
    }

    protected static boolean[] checkCache(J9ClassPointer clazz) {
        return descriptionCache.get(clazz);
    }

    protected GCMixedObjectIterator_V1(J9ObjectPointer object, boolean includeClassSlot) throws CorruptDataException {
        super(object, includeClassSlot);
        J9ClassPointer clazz = J9ObjectHelper.clazz(object);
        this.bytesInObjectSlot = (int)ObjectReferencePointer.SIZEOF;
        this.objectsInDescriptionSlot = UDATA.SIZEOF * 8;
        VoidPointer data = VoidPointer.cast(object.addOffset(ObjectModel.getHeaderSize(object)));
        this.initialize(clazz, data);
    }

    protected GCMixedObjectIterator_V1(J9ClassPointer clazz, VoidPointer addr) throws CorruptDataException {
        super(null, false);
        this.bytesInObjectSlot = (int)ObjectReferencePointer.SIZEOF;
        this.objectsInDescriptionSlot = UDATA.SIZEOF * 8;
        this.initialize(clazz, addr);
    }

    private void initialize(J9ClassPointer clazz, VoidPointer addr) throws CorruptDataException {
        this.data = ObjectReferencePointer.cast(addr);
        this.scanIndex = 0;
        this.scanLimit = clazz.totalInstanceSize().intValue() / this.bytesInObjectSlot;
        this.descriptionArray = GCMixedObjectIterator_V1.checkCache(clazz);
        if (null == this.descriptionArray) {
            this.descriptionArray = new boolean[(clazz.totalInstanceSize().intValue() + this.bytesInObjectSlot - 1) / this.bytesInObjectSlot];
            if (this.scanLimit > 0 && clazz.instanceDescription().notNull()) {
                this.initializeDescriptionArray(clazz);
                GCMixedObjectIterator_V1.setCache(clazz, this.descriptionArray);
            }
        }
    }

    protected void initializeDescriptionArray(J9ClassPointer clazz) throws CorruptDataException {
        UDATAPointer descriptionPtr = clazz.instanceDescription();
        if (descriptionPtr.anyBitsIn(1L)) {
            long tempDescription = descriptionPtr.getAddress() >>> 1;
            this.initializeDescriptionArray(tempDescription, 0);
        } else {
            int descriptionSlot = 0;
            for (int descriptionIndex = 0; descriptionIndex < this.scanLimit; descriptionIndex += this.objectsInDescriptionSlot) {
                long tempDescription = descriptionPtr.at(descriptionSlot++).longValue();
                this.initializeDescriptionArray(tempDescription, descriptionIndex);
            }
        }
    }

    private void initializeDescriptionArray(long tempDescription, int offset) {
        for (int i = 0; i < this.objectsInDescriptionSlot; ++i) {
            if (1L == (tempDescription & 1L)) {
                this.descriptionArray[offset + i] = true;
            }
            tempDescription >>>= 1;
        }
    }

    public boolean hasNext() {
        if (this.object != null && this.includeClassSlot) {
            return true;
        }
        while (this.scanIndex < this.scanLimit) {
            if (this.descriptionArray[this.scanIndex]) {
                return true;
            }
            ++this.scanIndex;
        }
        return false;
    }

    public J9ObjectPointer next() {
        try {
            if (this.hasNext()) {
                if (this.object != null && this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return J9ObjectHelper.clazz(this.object).classObject();
                }
                J9ObjectPointer next = J9ObjectPointer.cast(this.data.at(this.scanIndex));
                ++this.scanIndex;
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }

    public VoidPointer nextAddress() {
        try {
            if (this.hasNext()) {
                if (this.object != null && this.includeClassSlot) {
                    this.includeClassSlot = false;
                    return VoidPointer.cast(J9ObjectHelper.clazz(this.object).classObjectEA());
                }
                VoidPointer next = VoidPointer.cast(this.data.add(this.scanIndex));
                ++this.scanIndex;
                return next;
            }
            throw new NoSuchElementException("There are no more items available through this iterator");
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            return null;
        }
    }
}

