/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.j9.gc;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.events.EventManager;
import com.ibm.j9ddr.vm27.j9.ObjectModel;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_CopyScanCachePointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_EnvironmentModronPointer;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.NoSuchElementException;

class GCObjectHeapIteratorAddressOrderedList_V1
extends GCObjectHeapIterator {
    protected J9ObjectPointer currentObject = null;
    protected U8Pointer scanPtr;
    protected U8Pointer scanPtrTop;
    protected U8Pointer[][] excludedRanges;
    protected int currentExcludedRange;

    protected GCObjectHeapIteratorAddressOrderedList_V1(U8Pointer base, U8Pointer top, boolean includeLiveObjects, boolean includeDeadObjects) throws CorruptDataException {
        super(includeLiveObjects, includeDeadObjects);
        this.scanPtr = base;
        this.scanPtrTop = top;
        ArrayList<U8Pointer[]> excludedRangeList = new ArrayList<U8Pointer[]>();
        GCVMThreadListIterator threadIterator = new GCVMThreadListIterator();
        boolean scavengerEnabled = false;
        if (J9BuildFlags.gc_modronScavenger && GCObjectHeapIteratorAddressOrderedList_V1.getExtensions().scavengerEnabled()) {
            scavengerEnabled = true;
        }
        while (threadIterator.hasNext()) {
            U8Pointer cacheTop;
            U8Pointer cacheAlloc;
            MM_CopyScanCachePointer tenureCache;
            U8Pointer cacheTop2;
            U8Pointer cacheAlloc2;
            J9VMThreadPointer vmThread = threadIterator.next();
            if (J9BuildFlags.gc_inlinedAllocFields) {
                U8Pointer realHeapAlloc;
                U8Pointer heapAlloc;
                U8Pointer heapTop = this.adjustedToRange(vmThread.heapTop(), base, top);
                if (heapTop.notNull()) {
                    heapAlloc = this.adjustedToRange(vmThread.heapAlloc(), base, top);
                    if (this.isSomethingToAdd(heapAlloc, heapTop)) {
                        excludedRangeList.add(new U8Pointer[]{heapAlloc, heapTop});
                    } else {
                        realHeapAlloc = this.adjustedToRange(vmThread.allocateThreadLocalHeap().realHeapAlloc(), base, top);
                        if (realHeapAlloc.notNull() && this.isSomethingToAdd(realHeapAlloc, heapTop)) {
                            excludedRangeList.add(new U8Pointer[]{realHeapAlloc, heapTop});
                        }
                    }
                }
                if (J9BuildFlags.gc_nonZeroTLH && (heapTop = this.adjustedToRange(vmThread.nonZeroHeapTop(), base, top)).notNull()) {
                    heapAlloc = this.adjustedToRange(vmThread.nonZeroHeapAlloc(), base, top);
                    if (this.isSomethingToAdd(heapAlloc, heapTop)) {
                        excludedRangeList.add(new U8Pointer[]{heapAlloc, heapTop});
                    } else {
                        realHeapAlloc = this.adjustedToRange(vmThread.nonZeroAllocateThreadLocalHeap().realHeapAlloc(), base, top);
                        if (realHeapAlloc.notNull() && this.isSomethingToAdd(realHeapAlloc, heapTop)) {
                            excludedRangeList.add(new U8Pointer[]{realHeapAlloc, heapTop});
                        }
                    }
                }
            } else {
                throw new UnsupportedOperationException("No support for non-gc_inlinedAllocFields VMs");
            }
            if (!scavengerEnabled) continue;
            MM_EnvironmentModronPointer env = MM_EnvironmentModronPointer.cast(vmThread.gcExtensions());
            MM_CopyScanCachePointer survivorCache = env._survivorCopyScanCache();
            if (survivorCache.notNull() && this.isSomethingToAdd(cacheAlloc2 = this.adjustedToRange(U8Pointer.cast(survivorCache.cacheAlloc()), base, top), cacheTop2 = this.adjustedToRange(U8Pointer.cast(survivorCache.cacheTop()), base, top))) {
                excludedRangeList.add(new U8Pointer[]{cacheAlloc2, cacheTop2});
            }
            if (!(tenureCache = env._tenureCopyScanCache()).notNull() || !this.isSomethingToAdd(cacheAlloc = this.adjustedToRange(U8Pointer.cast(tenureCache.cacheAlloc()), base, top), cacheTop = this.adjustedToRange(U8Pointer.cast(tenureCache.cacheTop()), base, top))) continue;
            excludedRangeList.add(new U8Pointer[]{cacheAlloc, cacheTop});
        }
        excludedRangeList.add(new U8Pointer[]{this.scanPtrTop, this.scanPtrTop});
        Collections.sort(excludedRangeList, new Comparator<U8Pointer[]>(){

            @Override
            public int compare(U8Pointer[] o1, U8Pointer[] o2) {
                return o1[0].compare(o2[0]);
            }
        });
        this.excludedRanges = new U8Pointer[excludedRangeList.size()][2];
        excludedRangeList.toArray((T[])this.excludedRanges);
        this.currentExcludedRange = 0;
    }

    private U8Pointer adjustedToRange(U8Pointer ptr, U8Pointer base, U8Pointer top) {
        U8Pointer result = ptr;
        if (result.notNull()) {
            if (result.lt(base)) {
                result = base;
            } else if (result.gt(top)) {
                result = top;
            }
        }
        return result;
    }

    private boolean isSomethingToAdd(U8Pointer start, U8Pointer end) throws CorruptDataException {
        boolean result = false;
        if (start.lt(end)) {
            result = true;
        } else if (start.gt(end)) {
            throw new CorruptDataException("Memory range: Start address is higher then end address");
        }
        return result;
    }

    protected void advanceScanPointer() {
        try {
            while (this.scanPtr.lt(this.scanPtrTop)) {
                if (null != this.currentObject) {
                    if (ObjectModel.isDeadObject(this.currentObject)) {
                        UDATA deadObjectSize = ObjectModel.getSizeInBytesDeadObject(this.currentObject);
                        if (deadObjectSize.eq(0L)) {
                            throw new CorruptDataException("Dead object at " + this.currentObject.getHexAddress() + " has an invalid size of 0");
                        }
                        this.scanPtr = this.scanPtr.add(deadObjectSize);
                    } else {
                        this.scanPtr = this.scanPtr.add(ObjectModel.getConsumedSizeInBytesWithHeader(this.currentObject));
                    }
                    this.currentObject = null;
                }
                if (this.scanPtr.gte(this.scanPtrTop)) {
                    return;
                }
                while (this.scanPtr.gt(this.excludedRanges[this.currentExcludedRange][1])) {
                    ++this.currentExcludedRange;
                }
                if (this.scanPtr.gte(this.excludedRanges[this.currentExcludedRange][0])) {
                    this.scanPtr = U8Pointer.cast(this.excludedRanges[this.currentExcludedRange][1]);
                    ++this.currentExcludedRange;
                    continue;
                }
                if (this.scanPtr.gte(this.scanPtrTop)) {
                    return;
                }
                this.currentObject = J9ObjectPointer.cast(this.scanPtr);
                if (!this.includeLiveObjects || !this.includeDeadObjects) {
                    boolean isDead = ObjectModel.isDeadObject(this.currentObject);
                    if (!this.includeLiveObjects && !isDead || !this.includeDeadObjects && isDead) continue;
                }
                return;
            }
        }
        catch (CorruptDataException e) {
            EventManager.raiseCorruptDataEvent("Error getting next item", e, false);
            this.currentObject = null;
            this.scanPtr = this.scanPtrTop;
        }
    }

    public boolean hasNext() {
        if (null == this.currentObject) {
            this.advanceScanPointer();
        }
        return null != this.currentObject;
    }

    public void advance(UDATA size) {
        U8Pointer newAddress = this.scanPtr.addOffset(size);
        if (!newAddress.gte(this.scanPtr) || !newAddress.lt(this.scanPtrTop)) {
            throw new NoSuchElementException("An address to advance is out of range");
        }
        this.scanPtr = newAddress;
        this.currentObject = null;
    }

    public J9ObjectPointer next() {
        if (this.hasNext()) {
            J9ObjectPointer next = this.currentObject;
            this.advanceScanPointer();
            return next;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }

    public J9ObjectPointer peek() {
        if (this.hasNext()) {
            return this.currentObject;
        }
        throw new NoSuchElementException("There are no more items available through this iterator");
    }
}

