/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.I64Pointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.structure.J9GuestMemoryUsage;
import com.ibm.j9ddr.vm27.types.I64;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=J9GuestMemoryUsage.class)
public class J9GuestMemoryUsagePointer
extends StructurePointer {
    public static final J9GuestMemoryUsagePointer NULL = new J9GuestMemoryUsagePointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected J9GuestMemoryUsagePointer(long address) {
        super(address);
    }

    public static J9GuestMemoryUsagePointer cast(AbstractPointer structure) {
        return J9GuestMemoryUsagePointer.cast(structure.getAddress());
    }

    public static J9GuestMemoryUsagePointer cast(UDATA udata) {
        return J9GuestMemoryUsagePointer.cast(udata.longValue());
    }

    public static J9GuestMemoryUsagePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9GuestMemoryUsagePointer(address);
    }

    public J9GuestMemoryUsagePointer add(long count) {
        return J9GuestMemoryUsagePointer.cast(this.address + J9GuestMemoryUsage.SIZEOF * count);
    }

    public J9GuestMemoryUsagePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public J9GuestMemoryUsagePointer addOffset(long offset) {
        return J9GuestMemoryUsagePointer.cast(this.address + offset);
    }

    public J9GuestMemoryUsagePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public J9GuestMemoryUsagePointer sub(long count) {
        return J9GuestMemoryUsagePointer.cast(this.address - J9GuestMemoryUsage.SIZEOF * count);
    }

    public J9GuestMemoryUsagePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public J9GuestMemoryUsagePointer subOffset(long offset) {
        return J9GuestMemoryUsagePointer.cast(this.address - offset);
    }

    public J9GuestMemoryUsagePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public J9GuestMemoryUsagePointer untag(long mask) {
        return J9GuestMemoryUsagePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public J9GuestMemoryUsagePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return J9GuestMemoryUsage.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_maxMemLimitOffset_", declaredType="I64")
    public I64 maxMemLimit() throws CorruptDataException {
        return new I64(this.getLongAtOffset(J9GuestMemoryUsage._maxMemLimitOffset_));
    }

    public I64Pointer maxMemLimitEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I64Pointer.cast(this.address + (long)J9GuestMemoryUsage._maxMemLimitOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_memUsedOffset_", declaredType="I64")
    public I64 memUsed() throws CorruptDataException {
        return new I64(this.getLongAtOffset(J9GuestMemoryUsage._memUsedOffset_));
    }

    public I64Pointer memUsedEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I64Pointer.cast(this.address + (long)J9GuestMemoryUsage._memUsedOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_timestampOffset_", declaredType="I64")
    public I64 timestamp() throws CorruptDataException {
        return new I64(this.getLongAtOffset(J9GuestMemoryUsage._timestampOffset_));
    }

    public I64Pointer timestampEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I64Pointer.cast(this.address + (long)J9GuestMemoryUsage._timestampOffset_);
    }
}

