/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.StructurePointer;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.structure.RasDataHeader;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=RasDataHeader.class)
public class RasDataHeaderPointer
extends StructurePointer {
    public static final RasDataHeaderPointer NULL = new RasDataHeaderPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected RasDataHeaderPointer(long address) {
        super(address);
    }

    public static RasDataHeaderPointer cast(AbstractPointer structure) {
        return RasDataHeaderPointer.cast(structure.getAddress());
    }

    public static RasDataHeaderPointer cast(UDATA udata) {
        return RasDataHeaderPointer.cast(udata.longValue());
    }

    public static RasDataHeaderPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new RasDataHeaderPointer(address);
    }

    public RasDataHeaderPointer add(long count) {
        return RasDataHeaderPointer.cast(this.address + RasDataHeader.SIZEOF * count);
    }

    public RasDataHeaderPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public RasDataHeaderPointer addOffset(long offset) {
        return RasDataHeaderPointer.cast(this.address + offset);
    }

    public RasDataHeaderPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public RasDataHeaderPointer sub(long count) {
        return RasDataHeaderPointer.cast(this.address - RasDataHeader.SIZEOF * count);
    }

    public RasDataHeaderPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public RasDataHeaderPointer subOffset(long offset) {
        return RasDataHeaderPointer.cast(this.address - offset);
    }

    public RasDataHeaderPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public RasDataHeaderPointer untag(long mask) {
        return RasDataHeaderPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public RasDataHeaderPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return RasDataHeader.SIZEOF;
    }

    public U8Pointer eyecatcherEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return U8Pointer.cast(this.address + (long)RasDataHeader._eyecatcherOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_lengthOffset_", declaredType="int")
    public I32 length() throws CorruptDataException {
        return new I32(this.getIntAtOffset(RasDataHeader._lengthOffset_));
    }

    public I32Pointer lengthEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)RasDataHeader._lengthOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_modificationOffset_", declaredType="int")
    public I32 modification() throws CorruptDataException {
        return new I32(this.getIntAtOffset(RasDataHeader._modificationOffset_));
    }

    public I32Pointer modificationEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)RasDataHeader._modificationOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="int")
    public I32 version() throws CorruptDataException {
        return new I32(this.getIntAtOffset(RasDataHeader._versionOffset_));
    }

    public I32Pointer versionEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return I32Pointer.cast(this.address + (long)RasDataHeader._versionOffset_);
    }
}

