/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.BoolPointer;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.ByteBufferPointer;
import com.ibm.j9ddr.vm27.pointer.generated.StoragePointer;
import com.ibm.j9ddr.vm27.structure.RawChunk;
import com.ibm.j9ddr.vm27.types.Scalar;
import com.ibm.j9ddr.vm27.types.UDATA;

@GeneratedPointerClass(structureClass=RawChunk.class)
public class RawChunkPointer
extends StoragePointer {
    public static final RawChunkPointer NULL = new RawChunkPointer(0L);
    private static final boolean CACHE_FIELDS = false;
    private static final boolean CACHE_CLASS = false;

    protected RawChunkPointer(long address) {
        super(address);
    }

    public static RawChunkPointer cast(AbstractPointer structure) {
        return RawChunkPointer.cast(structure.getAddress());
    }

    public static RawChunkPointer cast(UDATA udata) {
        return RawChunkPointer.cast(udata.longValue());
    }

    public static RawChunkPointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new RawChunkPointer(address);
    }

    public RawChunkPointer add(long count) {
        return RawChunkPointer.cast(this.address + RawChunk.SIZEOF * count);
    }

    public RawChunkPointer add(Scalar count) {
        return this.add(count.longValue());
    }

    public RawChunkPointer addOffset(long offset) {
        return RawChunkPointer.cast(this.address + offset);
    }

    public RawChunkPointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    public RawChunkPointer sub(long count) {
        return RawChunkPointer.cast(this.address - RawChunk.SIZEOF * count);
    }

    public RawChunkPointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    public RawChunkPointer subOffset(long offset) {
        return RawChunkPointer.cast(this.address - offset);
    }

    public RawChunkPointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    public RawChunkPointer untag(long mask) {
        return RawChunkPointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public RawChunkPointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    protected long sizeOfBaseType() {
        return RawChunk.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dataOffset_", declaredType="class ByteBuffer*")
    public ByteBufferPointer data() throws CorruptDataException {
        long pointer = this.getPointerAtOffset(RawChunk._dataOffset_);
        return ByteBufferPointer.cast(pointer);
    }

    public PointerPointer dataEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)RawChunk._dataOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_openOffset_", declaredType="bool")
    public boolean open() throws CorruptDataException {
        return this.getBoolAtOffset(RawChunk._openOffset_);
    }

    public BoolPointer openEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return BoolPointer.cast(this.address + (long)RawChunk._openOffset_);
    }
}

