/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm27.j9.walkers.ClassSegmentIterator;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassloadersSummaryCommand
extends Command {
    public ClassloadersSummaryCommand() {
        this.addCommand("classloaderssummary", "", "Display classloaders summary");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            Collection<ClassloadersSummaryNode> stats = this.getStat();
            this.printStat(stats, out);
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    public void printStat(Collection<ClassloadersSummaryNode> stats, PrintStream out) throws CorruptDataException {
        int longestName = 0;
        int numClassloaders = 0;
        for (ClassloadersSummaryNode csc : stats) {
            numClassloaders = (int)((long)numClassloaders + csc.numClassloaders);
            longestName = Math.max(longestName, csc.name.length());
        }
        out.println();
        out.println("[Classloaders Summary]");
        CommandUtils.dbgPrint(out, "<num %-" + longestName + "s, # Classloaders, # Loaded Classes>" + nl, "Classloader name");
        TreeMap countmap = new TreeMap(Collections.reverseOrder());
        LinkedHashMap<Long, String> cllist = new LinkedHashMap<Long, String>();
        int count = 0;
        for (ClassloadersSummaryNode classloadersSummaryNode : stats) {
            CommandUtils.dbgPrint(out, "%3d) %-" + longestName + "s, %-14d, %d" + nl, count++, classloadersSummaryNode.name, classloadersSummaryNode.numClassloaders, classloadersSummaryNode.numLoadedClasses);
            Long cpval = (Long)countmap.get(classloadersSummaryNode.numLoadedClasses);
            if (cpval != null) {
                Long clcount = new Long(cpval + classloadersSummaryNode.numClassloaders);
                countmap.put(classloadersSummaryNode.numLoadedClasses, clcount);
                String list = (String)((HashMap)cllist).get(classloadersSummaryNode.numLoadedClasses);
                cllist.put(classloadersSummaryNode.numLoadedClasses, list + ", " + classloadersSummaryNode.name);
                continue;
            }
            countmap.put(classloadersSummaryNode.numLoadedClasses, classloadersSummaryNode.numClassloaders);
            cllist.put(classloadersSummaryNode.numLoadedClasses, classloadersSummaryNode.name);
        }
        if (!countmap.isEmpty()) {
            out.println("\n<# Loaded Classes, # Classloaders, Classloader Names>");
        }
        for (Map.Entry entry : countmap.entrySet()) {
            CommandUtils.dbgPrint(out, "%-17d, %-14d, %s" + nl, entry.getKey(), entry.getValue(), ((HashMap)cllist).get(entry.getKey()));
        }
        out.println();
        out.println("Number of Classloaders: " + numClassloaders);
    }

    public Collection<ClassloadersSummaryNode> getStat() throws CorruptDataException {
        LinkedHashMap<String, ClassloadersSummaryNode> classloaders = new LinkedHashMap<String, ClassloadersSummaryNode>();
        J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
        GCClassLoaderIterator iterator = GCClassLoaderIterator.from();
        while (iterator.hasNext()) {
            J9ObjectPointer sys;
            J9ClassLoaderPointer classLoader = iterator.next();
            J9ObjectPointer classLoaderObject = classLoader.classLoaderObject();
            boolean isSystem = classLoaderObject.equals(sys = vm.systemClassLoader().classLoaderObject());
            String loader = isSystem ? "*System*" : J9ObjectHelper.getClassName(classLoaderObject);
            long classesLoaded = 0L;
            ClassSegmentIterator classSegmentIterator = new ClassSegmentIterator(vm.classMemorySegments());
            while (classSegmentIterator.hasNext()) {
                J9ClassPointer classPointer = (J9ClassPointer)classSegmentIterator.next();
                if (classPointer.classLoader().getAddress() != classLoader.getAddress()) continue;
                ++classesLoaded;
            }
            ClassloadersSummaryNode cpentry = (ClassloadersSummaryNode)classloaders.get(loader);
            if (cpentry == null) {
                classloaders.put(loader, new ClassloadersSummaryNode(loader, 1L, classesLoaded));
                continue;
            }
            ClassloadersSummaryNode classloadersSummaryNode = cpentry;
            Long l = classloadersSummaryNode.numClassloaders;
            Long l2 = classloadersSummaryNode.numClassloaders = Long.valueOf(classloadersSummaryNode.numClassloaders + 1L);
            cpentry.numLoadedClasses += classesLoaded;
        }
        return classloaders.values();
    }

    public class ClassloadersSummaryNode {
        public String name;
        public Long numClassloaders;
        public long numLoadedClasses;

        public ClassloadersSummaryNode(String name, Long numClassloaders, long numLoadedClasses) {
            this.name = name;
            this.numClassloaders = numClassloaders;
            this.numLoadedClasses = numLoadedClasses;
        }
    }
}

