/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffset;
import com.ibm.j9ddr.vm27.j9.J9ObjectFieldOffsetIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantContextHelper;
import com.ibm.j9ddr.vm27.j9.tenant.TenantModel;
import com.ibm.j9ddr.vm27.pointer.BoolPointer;
import com.ibm.j9ddr.vm27.pointer.DoublePointer;
import com.ibm.j9ddr.vm27.pointer.FloatPointer;
import com.ibm.j9ddr.vm27.pointer.I16Pointer;
import com.ibm.j9ddr.vm27.pointer.I32Pointer;
import com.ibm.j9ddr.vm27.pointer.I64Pointer;
import com.ibm.j9ddr.vm27.pointer.I8Pointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMFieldShapePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9UTF8Pointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ROMFieldShapeHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm27.structure.J9FieldFlags;
import com.ibm.j9ddr.vm27.structure.J9ROMFieldOffsetWalkState;
import com.ibm.j9ddr.vm27.types.U32;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.io.PrintStream;
import java.util.Iterator;

public class J9StaticsCommand
extends Command {
    public J9StaticsCommand() {
        this.addCommand("j9statics", "<ramclass>", "Display static fields of a ram class");
    }

    long staticFieldAddress(J9VMThreadPointer vmStruct, J9ROMClassPointer romClass, String fieldName, String signature, long options) {
        return 0L;
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (args.length != 1) {
                CommandUtils.dbgPrint(out, "Usage: !j9statics <classAddress>\n");
                return;
            }
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            J9ClassPointer ramClass = J9ClassPointer.cast(address);
            J9ROMClassPointer romClass = ramClass.romClass();
            J9UTF8Pointer className = romClass.className();
            CommandUtils.dbgPrint(out, "Static fields in %s:\n", J9UTF8Helper.stringValue(className));
            TenantContextHelper tenantContextHelper = null;
            J9ObjectPointer tenantContext = null;
            boolean tenantEnabled = TenantModel.isTenantEnabled();
            if (tenantEnabled) {
                tenantContextHelper = TenantContextHelper.getDefault();
                tenantContext = tenantContextHelper.rootTenantContext();
            }
            Iterator<J9ObjectFieldOffset> ofoIterator = J9ObjectFieldOffsetIterator.J9ObjectFieldOffsetIteratorFor(ramClass, J9ClassHelper.superclass(ramClass), new U32(J9ROMFieldOffsetWalkState.J9VM_FIELD_OFFSET_WALK_INCLUDE_STATIC));
            block12: while (ofoIterator.hasNext()) {
                J9ObjectFieldOffset fieldOffset = ofoIterator.next();
                J9ROMFieldShapePointer field = fieldOffset.getField();
                String name = J9ROMFieldShapeHelper.getName(field);
                String sig = J9ROMFieldShapeHelper.getSignature(field);
                String suffix = "";
                UDATA rowAndColumn = null;
                boolean isIsolated = false;
                int row = 0;
                int col = 0;
                boolean index = false;
                UDATAPointer fieldAddress = ramClass.ramStatics().addOffset(fieldOffset.getOffsetOrAddress());
                if (tenantEnabled && field.modifiers().anyBitsIn(J9FieldFlags.J9FieldFlagHasTenantAnnotation)) {
                    isIsolated = true;
                    rowAndColumn = fieldAddress.at(0L);
                    row = tenantContextHelper.getRowIndex(rowAndColumn);
                    col = tenantContextHelper.getColIndex(rowAndColumn);
                }
                switch (sig.charAt(0)) {
                    case 'L': 
                    case '[': {
                        if (isIsolated) {
                            J9ObjectPointer val = tenantContextHelper.getObject(tenantContext, rowAndColumn);
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticstringfieldshape %s) = !j9object %s [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), val.getHexAddress(), row, col);
                            continue block12;
                        }
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticstringfieldshape %s) = !j9object %s\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), fieldAddress.at(0L).getHexValue());
                        continue block12;
                    }
                    case 'D': {
                        if (isIsolated) {
                            long val = tenantContextHelper.getLong(tenantContext, rowAndColumn);
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticdoublefieldshape %s) = %s (%s) [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), Double.toHexString(val), val, row, col);
                            continue block12;
                        }
                        DoublePointer doublePointer = DoublePointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticdoublefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), doublePointer.getHexValue(), new Double(doublePointer.doubleAt(0L)).toString());
                        continue block12;
                    }
                    case 'F': {
                        if (isIsolated) {
                            float val = Float.intBitsToFloat(tenantContextHelper.getInt(tenantContext, rowAndColumn));
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s) [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), Float.toHexString(val), Float.valueOf(val), row, col);
                            continue block12;
                        }
                        FloatPointer floatPointer = FloatPointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), floatPointer.getHexValue(), new Float(floatPointer.floatAt(0L)).toString());
                        continue block12;
                    }
                    case 'J': {
                        if (isIsolated) {
                            long val = tenantContextHelper.getLong(tenantContext, rowAndColumn);
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticdoublefieldshape %s) = %s (%d) [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), Long.toHexString(val), val, row, col);
                            continue block12;
                        }
                        I64Pointer longPointer = I64Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticdoublefieldshape %s) = %s (%d)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), longPointer.getHexValue(), longPointer.at(0L).longValue());
                        continue block12;
                    }
                    case 'I': {
                        if (isIsolated) {
                            int val = tenantContextHelper.getInt(tenantContext, rowAndColumn);
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%d) [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), Integer.toHexString(val), val, row, col);
                            continue block12;
                        }
                        I32Pointer intPointer = I32Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%d)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), intPointer.getHexValue(), intPointer.at(0L).intValue());
                        continue block12;
                    }
                    case 'B': {
                        if (isIsolated) {
                            byte val = (byte)(tenantContextHelper.getInt(tenantContext, rowAndColumn) & 0xFF);
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s) [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), Integer.toHexString(val), val, row, col);
                            continue block12;
                        }
                        I8Pointer bytePointer = I8Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), bytePointer.getHexValue(), bytePointer.at(0L).byteValue());
                        continue block12;
                    }
                    case 'S': {
                        if (isIsolated) {
                            short val = (short)(tenantContextHelper.getInt(tenantContext, rowAndColumn) & 0xFFFF);
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%d) [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), Integer.toHexString(val), val, row, col);
                            continue block12;
                        }
                        I16Pointer shortPointer = I16Pointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%d)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), shortPointer.getHexValue(), shortPointer.at(0L).shortValue());
                        continue block12;
                    }
                    case 'Z': {
                        if (isIsolated) {
                            boolean val = tenantContextHelper.getInt(tenantContext, rowAndColumn) == 1;
                            CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s) [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), val, val, row, col);
                            continue block12;
                        }
                        BoolPointer booleanPointer = BoolPointer.cast(fieldAddress);
                        CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s (%s)\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), booleanPointer.getHexValue(), booleanPointer.boolAt(0L) ? "true" : "false");
                        continue block12;
                    }
                }
                if (isIsolated) {
                    CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s [isolated row=%d, col=%d]\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), fieldAddress.at(0L).getHexValue(), row, col);
                    continue;
                }
                CommandUtils.dbgPrint(out, "\t%s %s %s (!j9romstaticsinglefieldshape %s) = %s\n", fieldAddress.getHexAddress(), name, sig, field.getHexAddress(), fieldAddress.at(0L).getHexValue());
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

