/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.pointer.U8Pointer;
import com.ibm.j9ddr.vm27.pointer.UDATAPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9BuildFlags;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.types.UDATA;
import java.io.PrintStream;

public class J9VTablesCommand
extends Command {
    public J9VTablesCommand() {
        this.addCommand("j9vtables", "<ramclass>", "dump interpreter and jit vtables for given ram class.");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            UDATAPointer jitVTable = UDATAPointer.NULL;
            long address = CommandUtils.parsePointer(args[0], J9BuildFlags.env_data64);
            J9ClassPointer ramClass = J9ClassPointer.cast(address);
            UDATAPointer vTable = J9ClassHelper.vTable(ramClass);
            UDATA vTableSlotCount = vTable.at(0L);
            if (J9BuildFlags.interp_nativeSupport && !vm.jitConfig().isNull()) {
                jitVTable = UDATAPointer.cast(U8Pointer.cast(ramClass).sub((vTableSlotCount.longValue() + 1L) * (long)UDATA.SIZEOF));
            }
            CommandUtils.dbgPrint(out, String.format("VTable for j9class %s  (size=%d - 1 for skipped resolve method)\n", ramClass.getHexAddress(), vTableSlotCount.longValue()));
            CommandUtils.dbgPrint(out, String.format("\tInterpreted%s\n", !jitVTable.isNull() ? "\t\tJitted\n" : ""));
            for (long i = 2L; i < vTableSlotCount.longValue() + 1L; ++i) {
                String name = J9MethodHelper.getName(J9MethodPointer.cast(vTable.at(i)));
                String intAddr = U8Pointer.cast(vTable.at(i)).getHexAddress();
                if (!jitVTable.isNull()) {
                    String jitAddr = U8Pointer.cast(jitVTable.at(vTableSlotCount.sub(i))).getHexAddress();
                    CommandUtils.dbgPrint(out, String.format(" %d\t!j9method %s\t%s\t%s\n", i - 1L, intAddr, jitAddr, name));
                    continue;
                }
                CommandUtils.dbgPrint(out, String.format(" %d\t!j9method %s\t%s\t\n", i - 1L, intAddr, name));
            }
            return;
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

