/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.gc.GCClassLoaderIterator;
import com.ibm.j9ddr.vm27.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMNameAndSignaturePointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9UTF8Helper;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.commands.WildCard;
import java.io.PrintStream;
import java.util.Hashtable;
import java.util.Iterator;

public class MethodForNameCommand
extends Command {
    public MethodForNameCommand() {
        this.addCommand("methodforname", "<name>", "find the method corresponding to name (with wildcards)");
    }

    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            if (args.length != 1) {
                throw new DDRInteractiveCommandException(command + ": too " + (args.length < 1 ? "few" : "many") + " arguments. Expected 1");
            }
            String name = args[0];
            CommandUtils.dbgPrint(out, String.format("Searching for methods named '%s' in VM=%s...\n", name, J9RASHelper.getVM(DataType.getJ9RASPointer()).getHexAddress()));
            int count = this.dbgGetMethodsForName(out, name);
            CommandUtils.dbgPrint(out, String.format("Found %d method(s) named %s\n", count, name));
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }

    int dbgGetMethodsForName(PrintStream out, String pattern) throws CorruptDataException {
        String classStart;
        String nameStart;
        int matchCount = 0;
        if (pattern.indexOf(46) != -1) {
            nameStart = pattern.substring(pattern.indexOf(46) + 1);
            classStart = pattern.substring(0, pattern.indexOf(46));
        } else {
            classStart = "*";
            nameStart = pattern;
        }
        String sigStart = pattern.indexOf(40) != -1 ? pattern.substring(pattern.indexOf(40)) : "*";
        StringBuffer needleBuffer = new StringBuffer();
        long classMatchFlags = WildCard.parseWildcard(classStart, needleBuffer);
        String classNeedle = needleBuffer.toString();
        if (classMatchFlags == -1L) {
            CommandUtils.dbgError(out, "Invalid wildcards in class name\n");
            return 0;
        }
        needleBuffer = new StringBuffer();
        long methodMatchFlags = WildCard.parseWildcard(nameStart, needleBuffer);
        String methodNeedle = needleBuffer.toString();
        if (methodMatchFlags == -1L) {
            CommandUtils.dbgError(out, "Invalid wildcards in method name\n");
            return 0;
        }
        needleBuffer = new StringBuffer();
        long sigMatchFlags = WildCard.parseWildcard(sigStart, needleBuffer);
        String sigNeedle = needleBuffer.toString();
        if (methodMatchFlags == -1L) {
            CommandUtils.dbgError(out, "Invalid wildcards in method name\n");
            return 0;
        }
        Hashtable<String, J9ClassPointer> loadedClasses = new Hashtable<String, J9ClassPointer>();
        GCClassLoaderIterator classLoaderIterator = GCClassLoaderIterator.from();
        while (classLoaderIterator.hasNext()) {
            J9ClassLoaderPointer loader = classLoaderIterator.next();
            Iterator<J9ClassPointer> classItterator = ClassIterator.fromJ9Classloader(loader);
            while (classItterator.hasNext()) {
                J9ClassPointer clazz = classItterator.next();
                J9ROMClassPointer romClazz = clazz.romClass();
                String className = J9UTF8Helper.stringValue(romClazz.className());
                if (loadedClasses.containsValue(clazz)) continue;
                loadedClasses.put(clazz.toString(), clazz);
                if (!WildCard.wildcardMatch(classMatchFlags, classNeedle, className)) continue;
                J9MethodPointer methodCursor = clazz.ramMethods();
                long count = romClazz.romMethodCount().longValue();
                while (count > 0L) {
                    String sigUTF;
                    J9ROMMethodPointer romMethod = J9MethodHelper.romMethod(methodCursor);
                    J9ROMNameAndSignaturePointer nameAndSignature = romMethod.nameAndSignature();
                    String nameUTF = J9UTF8Helper.stringValue(nameAndSignature.name());
                    if (WildCard.wildcardMatch(methodMatchFlags, methodNeedle, nameUTF) && WildCard.wildcardMatch(sigMatchFlags, sigNeedle, sigUTF = J9UTF8Helper.stringValue(nameAndSignature.signature()))) {
                        ++matchCount;
                        CommandUtils.dbgPrint(out, String.format("!j9method %s --> %s.%s%s\n", methodCursor.getHexAddress(), className, nameUTF, sigUTF));
                    }
                    --count;
                    methodCursor = methodCursor.add(1L);
                }
            }
        }
        return matchCount;
    }
}

