/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Humanize;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm27.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.JavaLangClassLoaderHelper;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionDescriptor;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCHeapRegionManager;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectHeapIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCObjectIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantContextHelper;
import com.ibm.j9ddr.vm27.j9.walkers.ClassIterator;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassLoaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextMultiTenantPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextTarokPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionDescriptorVLHGCPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_HeapRegionManagerPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.structure.MM_AllocationContextMultiTenant;
import com.ibm.j9ddr.vm27.structure.MM_AllocationContextTarok;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.ThreadsCommand;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.structureformat.extensions.J9ObjectStructureFormatter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TenantCommand
extends Command {
    public TenantCommand() {
        this.addCommand("tenant", "<address> [threads | regions | classes | loaders | xrefs | all (default) ]", "Dump tenant details");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            TenantContextHelper tenantContextHelper = new TenantContextHelper(vm);
            if (args.length < 1) {
                System.out.println("Listing all tenants...");
                Set<J9ObjectPointer> allTenants = tenantContextHelper.getAllTenants();
                for (J9ObjectPointer tenant : allTenants) {
                    String id = tenantContextHelper.id(tenant);
                    System.out.println("!tenant " + tenant.getHexAddress() + " // " + id + ", " + tenantContextHelper.state(tenant));
                }
                System.out.println("Found " + allTenants.size() + " tenants");
                throw new DDRInteractiveCommandException("This debug extension takes an address argument and optional qualifier \" !tenant <address> [threads | regions | classes | loaders | xrefs | all]\"");
            }
            boolean dumpThreads = false;
            boolean dumpRegions = false;
            boolean dumpClasses = false;
            boolean dumpLoaders = false;
            boolean dumpExternalReferences = false;
            if (1 == args.length) {
                dumpThreads = true;
                dumpRegions = true;
                dumpClasses = true;
                dumpLoaders = true;
                dumpExternalReferences = true;
            }
            for (int i = 1; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equalsIgnoreCase("threads")) {
                    dumpThreads = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("regions")) {
                    dumpRegions = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("classes")) {
                    dumpClasses = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("loaders")) {
                    dumpLoaders = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("xrefs")) {
                    dumpExternalReferences = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("all")) {
                    dumpThreads = true;
                    dumpRegions = true;
                    dumpClasses = true;
                    dumpLoaders = true;
                    dumpExternalReferences = true;
                    continue;
                }
                throw new DDRInteractiveCommandException("Unrecognized tenant subcommand -->" + arg);
            }
            long addr = Long.decode(args[0]);
            J9ObjectPointer tenantObject = J9ObjectPointer.cast(addr);
            String tenantID = tenantContextHelper.id(tenantObject);
            out.println("Dumping info about tenant: " + tenantID);
            MM_AllocationContextMultiTenantPointer acmt = tenantContextHelper.allocationContext(tenantObject);
            out.print("MM_AllocationContextMultiTenant: " + acmt.getHexAddress());
            if (acmt.notNull()) {
                long acState = acmt._state();
                if (MM_AllocationContextMultiTenant.TenantBindState.BOUND == acState) {
                    out.print(" // BOUND");
                }
                if (MM_AllocationContextMultiTenant.TenantBindState.UNBOUND == acState) {
                    out.print(" // UNBOUND");
                }
                if (MM_AllocationContextMultiTenant.TenantBindState.UNBINDING == acState) {
                    out.print(" // UNBINDING");
                }
            }
            out.println();
            new J9ObjectStructureFormatter().format("j9object", addr, out, context, null, null);
            if (dumpThreads) {
                this.dumpThreads(tenantContextHelper, tenantObject, out);
            }
            if (dumpRegions) {
                this.dumpRegions(tenantContextHelper, tenantObject, out);
            }
            if (dumpClasses) {
                this.dumpClasses(tenantContextHelper, tenantObject, out);
            }
            if (dumpLoaders) {
                this.dumpLoaders(tenantContextHelper, tenantObject, out);
            }
            if (dumpExternalReferences) {
                this.dumpTenantExternalReferences(vm, tenantContextHelper, tenantObject, out);
            }
        }
        catch (DDRInteractiveCommandException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace(out);
            throw new DDRInteractiveCommandException(e);
        }
    }

    private void dumpRegions(TenantContextHelper tenantContextHelper, J9ObjectPointer tenantObject, PrintStream out) throws CorruptDataException {
        int threadNumber = 1;
        Table table = new Table("Regions");
        table.row("number", "address", "low", "high", "live", "size");
        long totalSize = 0L;
        long totalLive = 0L;
        for (MM_HeapRegionDescriptorVLHGCPointer region : tenantContextHelper.getRegions(tenantObject)) {
            long low = region._lowAddress().longValue();
            long high = region._highAddress().longValue();
            long live = region._projectedLiveBytes().longValue();
            long size = high - low;
            table.row(Integer.toString(threadNumber++), region.getHexAddress(), Humanize.pointer(low), Humanize.pointer(high), Humanize.bytes(live), Humanize.bytes(size));
            totalLive += live;
            totalSize += size;
        }
        table.row("", "TOTALs", "", "", Humanize.bytes(totalLive), Humanize.bytes(totalSize));
        table.render(out);
    }

    private void dumpThreads(TenantContextHelper tenantContextHelper, J9ObjectPointer tenantObject, PrintStream out) throws CorruptDataException {
        int threadNumber = 1;
        Table table = new Table("Threads");
        table.row("number", "stack", "vmthread", "j9thread", "tid", "id");
        for (J9VMThreadPointer thread : tenantContextHelper.getThreads(tenantObject)) {
            table.row(Integer.toString(threadNumber++), "!stack 0x" + Long.toHexString(thread.getAddress()), "!j9vmthread 0x" + Long.toHexString(thread.getAddress()), "!j9thread 0x" + Long.toHexString(thread.osThread().getAddress()), "0x" + Long.toHexString(thread.osThread().tid().longValue()) + "(" + thread.osThread().tid().longValue() + ")", ThreadsCommand.getThreadName(thread));
        }
        table.render(out);
    }

    private void dumpClasses(TenantContextHelper tenantContextHelper, J9ObjectPointer tenantObject, PrintStream out) throws CorruptDataException {
        int classNumber = 1;
        Table table = new Table("Classes");
        Set<J9ObjectPointer> heapClasses = tenantContextHelper.getClasses(tenantObject);
        ArrayList<J9ClassPointer> ramClasses = new ArrayList<J9ClassPointer>();
        for (J9ObjectPointer heapClass : heapClasses) {
            J9ClassPointer ramClass = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(heapClass);
            ramClasses.add(ramClass);
        }
        Collections.sort(ramClasses, new Comparator<J9ClassPointer>(){

            @Override
            public int compare(J9ClassPointer c1, J9ClassPointer c2) {
                try {
                    String name1 = J9ClassHelper.getName(c1);
                    String name2 = J9ClassHelper.getName(c2);
                    return name1.compareTo(name2);
                }
                catch (CorruptDataException e) {
                    return 0;
                }
            }
        });
        table.row("number", "name", "loader", "address");
        for (J9ClassPointer ramClass : ramClasses) {
            J9ClassLoaderPointer classLoader = ramClass.classLoader();
            table.row(Integer.toString(classNumber++), J9ClassHelper.getName(ramClass), classLoader.getHexAddress(), "!j9class " + ramClass.getHexAddress());
        }
        table.render(out);
    }

    private void dumpLoaders(TenantContextHelper tenantContextHelper, J9ObjectPointer tenantObject, PrintStream out) throws CorruptDataException {
        J9ClassLoaderPointer cursor;
        Set<J9ObjectPointer> heapClasses = tenantContextHelper.getClasses(tenantObject);
        ArrayList<J9ClassPointer> ramClasses = new ArrayList<J9ClassPointer>();
        HashSet<J9ClassLoaderPointer> classLoaders = new HashSet<J9ClassLoaderPointer>();
        HashMap<J9ClassLoaderPointer, J9ClassLoaderPointer> childToParentMap = new HashMap<J9ClassLoaderPointer, J9ClassLoaderPointer>();
        HashMap<J9ClassLoaderPointer, HashSet<J9ClassLoaderPointer>> childrenByLoader = new HashMap<J9ClassLoaderPointer, HashSet<J9ClassLoaderPointer>>();
        for (J9ObjectPointer heapClass : heapClasses) {
            J9ClassPointer ramClass = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(heapClass);
            ramClasses.add(ramClass);
            classLoaders.add(ramClass.classLoader());
        }
        ArrayList<J9ClassLoaderPointer> toBeWalkedList = new ArrayList<J9ClassLoaderPointer>();
        toBeWalkedList.addAll(classLoaders);
        while (!toBeWalkedList.isEmpty()) {
            cursor = (J9ClassLoaderPointer)toBeWalkedList.remove(0);
            J9ObjectPointer classLoaderObject = cursor.classLoaderObject();
            J9ObjectPointer parentLoaderObject = JavaLangClassLoaderHelper.getParent(classLoaderObject);
            J9ClassLoaderPointer parentClassLoader = JavaLangClassLoaderHelper.getClassLoader(parentLoaderObject);
            HashSet<J9ClassLoaderPointer> children = (HashSet<J9ClassLoaderPointer>)childrenByLoader.get(parentClassLoader);
            if (null == children) {
                children = new HashSet<J9ClassLoaderPointer>();
                childrenByLoader.put(parentClassLoader, children);
            }
            children.add(cursor);
            childToParentMap.put(cursor, parentClassLoader);
            if (parentClassLoader.isNull()) continue;
            toBeWalkedList.add(parentClassLoader);
        }
        out.println();
        out.println("ClassLoader Tree");
        out.println("================");
        if (null != childrenByLoader.get(J9ClassLoaderPointer.NULL)) {
            toBeWalkedList.addAll((Collection)childrenByLoader.get(J9ClassLoaderPointer.NULL));
        }
        while (!toBeWalkedList.isEmpty()) {
            cursor = (J9ClassLoaderPointer)toBeWalkedList.remove(0);
            int depth = this.getDepth(cursor, childToParentMap);
            for (int i = 0; i < depth; ++i) {
                out.print("  ");
            }
            out.printf("loader=%s object=%s (%s)\n", cursor.getHexAddress(), cursor.classLoaderObject().getHexAddress(), J9ObjectHelper.getClassName(cursor.classLoaderObject()));
            Iterator<J9ClassPointer> classIterator = ClassIterator.fromJ9Classloader(cursor);
            while (classIterator.hasNext()) {
                J9ClassPointer clazz = classIterator.next();
                if (!clazz.classLoader().equals(cursor)) continue;
                for (int i = 0; i < depth; ++i) {
                    out.print("  ");
                }
                out.printf("  %s @ %s\n", clazz.getHexAddress(), J9ClassHelper.getJavaName(clazz));
            }
            HashSet children = (HashSet)childrenByLoader.get(cursor);
            if (null == children) continue;
            toBeWalkedList.addAll(0, children);
        }
    }

    private int getDepth(J9ClassLoaderPointer loader, HashMap<J9ClassLoaderPointer, J9ClassLoaderPointer> childToParentMap) {
        J9ClassLoaderPointer parent = childToParentMap.get(loader);
        if (null == parent) {
            return 0;
        }
        return this.getDepth(parent, childToParentMap) + 1;
    }

    private void dumpTenantExternalReferences(J9JavaVMPointer vm, TenantContextHelper tenantContextHelper, J9ObjectPointer tenantObject, PrintStream out) throws CorruptDataException {
        MM_AllocationContextMultiTenantPointer tenantAllocationContext = tenantContextHelper.allocationContext(tenantObject);
        long numExternalReferences = 0L;
        Table table = new Table("External References");
        table.row("object (!j9object)", "field (!j9object)", "AC (type)", "!mm_heapregiondescriptorvlhgc", "object's tenant");
        MM_HeapRegionManagerPointer hrmPointer = MM_GCExtensionsPointer.cast(vm.gcExtensions()).heapRegionManager();
        GCHeapRegionManager heapRegionManager = GCHeapRegionManager.fromHeapRegionManager(hrmPointer);
        GCHeapRegionIterator regionIterator = GCHeapRegionIterator.from();
        while (regionIterator.hasNext()) {
            MM_AllocationContextMultiTenantPointer acmt;
            PointerPointer tenantContextJNIRef;
            GCHeapRegionDescriptor region = regionIterator.next();
            if (!region.containsObjects()) continue;
            MM_HeapRegionDescriptorVLHGCPointer vlhgcRegion = MM_HeapRegionDescriptorVLHGCPointer.cast(region.getHeapRegionDescriptorPointer());
            MM_AllocationContextTarokPointer currentAllocationContextTarok = vlhgcRegion._allocateData()._owningContext();
            String currentTenantID = "null";
            J9ObjectPointer currentTenant = J9ObjectPointer.NULL;
            if (MM_AllocationContextTarok.AllocationContextType.MULTI_TENANT == currentAllocationContextTarok._allocationContextType() && (tenantContextJNIRef = (acmt = MM_AllocationContextMultiTenantPointer.cast(currentAllocationContextTarok))._tenantContext()).notNull() && (currentTenant = J9ObjectPointer.cast(tenantContextJNIRef.at(0L))).notNull()) {
                currentTenantID = tenantContextHelper.id(currentTenant);
            }
            if (currentAllocationContextTarok.eq(tenantAllocationContext)) continue;
            GCObjectHeapIterator heapObjectIterator = region.objectIterator(true, false);
            while (heapObjectIterator.hasNext()) {
                J9ObjectPointer currentObject = heapObjectIterator.next();
                GCObjectIterator fieldIterator = GCObjectIterator.fromJ9Object(currentObject, false);
                while (fieldIterator.hasNext()) {
                    GCHeapRegionDescriptor targetRegion;
                    MM_HeapRegionDescriptorVLHGCPointer vlhgcTargetRegion;
                    J9ObjectPointer targetObject = fieldIterator.next();
                    if (!targetObject.notNull() || !(vlhgcTargetRegion = MM_HeapRegionDescriptorVLHGCPointer.cast((targetRegion = heapRegionManager.regionDescriptorForAddress(targetObject)).getHeapRegionDescriptorPointer()))._allocateData()._owningContext().eq(tenantAllocationContext)) continue;
                    J9ClassPointer objectClass = J9ObjectHelper.clazz(currentObject);
                    String objectClassString = J9ClassHelper.getJavaName(objectClass);
                    table.row(currentObject.getHexAddress() + " //" + objectClassString, targetObject.getHexAddress(), currentAllocationContextTarok.getHexAddress() + " (" + currentAllocationContextTarok._allocationContextType() + ")", vlhgcRegion.getHexAddress(), currentTenant.getHexAddress() + " \"" + currentTenantID + "\"");
                    ++numExternalReferences;
                }
            }
        }
        table.render(out);
        out.println("Found " + numExternalReferences + " external references.");
    }
}

