/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.tools.ddrinteractive.Humanize;
import com.ibm.j9ddr.tools.ddrinteractive.Table;
import com.ibm.j9ddr.vm27.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.ObjectModel;
import com.ibm.j9ddr.vm27.j9.gc.GCFinalizableObjectIterator;
import com.ibm.j9ddr.vm27.j9.tenant.TenantContextHelper;
import com.ibm.j9ddr.vm27.j9.tenant.TenantDataHelper;
import com.ibm.j9ddr.vm27.j9.tenant.UncheckedReferenceHelper;
import com.ibm.j9ddr.vm27.pointer.generated.GC_FinalizeListManagerMultiTenantPointer;
import com.ibm.j9ddr.vm27.pointer.generated.GC_FinalizeListManagerPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9IndexableObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ObjectPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_AllocationContextMultiTenantPointer;
import com.ibm.j9ddr.vm27.pointer.generated.MM_GCExtensionsPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import java.io.PrintStream;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TenantsCommand
extends Command {
    private J9ClassPointer tenantContextClazz;
    private TenantContextHelper tenantContextHelper;
    private UncheckedReferenceHelper uncheckedReferenceHelper;
    private TenantDataHelper tenantDataHelper;

    public TenantsCommand() {
        this.addCommand("tenants", "[finalizable]", "Dump a list of all tenants");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        block7: {
            try {
                J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
                if (0 == args.length) {
                    this.tenantContextHelper = TenantContextHelper.getDefault();
                    this.tenantContextClazz = this.tenantContextHelper.tenantContextClazz();
                    if (null == this.tenantContextClazz) {
                        out.println(String.format("Could not find %1s class, are you sure you're running in a multitenant mode?", "Lcom/ibm/tenant/TenantContext;"));
                        return;
                    }
                    this.uncheckedReferenceHelper = new UncheckedReferenceHelper(vm);
                    this.tenantDataHelper = new TenantDataHelper(vm);
                    long walkStart = System.currentTimeMillis();
                    Set<J9ObjectPointer> tenants = this.tenantContextHelper.getAllTenants();
                    long walkMillis = System.currentTimeMillis() - walkStart;
                    out.println(String.format("Found %1d tenants in %2d ms.", tenants.size(), walkMillis));
                    if (tenants.size() >= 1) {
                        this.dumpTenants(tenants, vm, out);
                    }
                    this.dumpFinalizableInfo(vm, out);
                    break block7;
                }
                if (1 == args.length && "finalizable".equals(args[0])) {
                    this.dumpFinalizableInfo(vm, out);
                    break block7;
                }
                throw new DDRInteractiveCommandException("This debug extension takes no arguments and an optional qualifier \" !tenants [finalizable]\"");
            }
            catch (CorruptDataException e) {
                throw new DDRInteractiveCommandException(e);
            }
            catch (ClassNotFoundException e) {
                out.println(e);
                out.println("Are you sure you're running in a multitenant mode?");
                throw new DDRInteractiveCommandException(e);
            }
        }
    }

    private void dumpTenants(Set<J9ObjectPointer> tenants, J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        Table table = new Table("Tenants");
        table.row("num", "address", "threads", "daemons", "mm_alloc", "statics", "heap", "classes", "c_heap", "c_native", "c_jitcode", "c_jitdata", "id");
        int tenantIndex = 0;
        int threadTotal = 0;
        int daemonTotal = 0;
        TenantDataHelper.SlotStats totalStatics = new TenantDataHelper.SlotStats();
        long heapTotal = 0L;
        int classesTotal = 0;
        long totalClassesHeapSize = 0L;
        long totalClassesNativeSize = 0L;
        long totalClassesJITCodeSize = 0L;
        long totalClassesJITDataSize = 0L;
        for (J9ObjectPointer tenantObject : tenants) {
            int threadCount = this.tenantContextHelper.threadTotal(tenantObject);
            int daemonCount = this.tenantContextHelper.daemonThreadTotal(tenantObject);
            long allocationContextRef = this.tenantContextHelper.allocationContextRef(tenantObject);
            String id = this.tenantContextHelper.id(tenantObject);
            J9ObjectPointer dataObject = this.tenantContextHelper.data(tenantObject);
            J9IndexableObjectPointer oslots = this.tenantDataHelper.dataObj(dataObject);
            J9IndexableObjectPointer data32 = this.tenantDataHelper.data32(dataObject);
            J9IndexableObjectPointer data64 = this.tenantDataHelper.data64(dataObject);
            TenantDataHelper.SlotStats statsO = this.tenantDataHelper.getSlotStats(oslots);
            TenantDataHelper.SlotStats stats32 = this.tenantDataHelper.getSlotStats(data32);
            TenantDataHelper.SlotStats stats64 = this.tenantDataHelper.getSlotStats(data64);
            TenantDataHelper.SlotStats staticStats = new TenantDataHelper.SlotStats();
            staticStats.add(statsO);
            staticStats.add(stats32);
            staticStats.add(stats64);
            MM_AllocationContextMultiTenantPointer allocationContext = this.tenantContextHelper.allocationContext(tenantObject);
            long tenantHeap = 0L;
            if (!allocationContext.isNull()) {
                tenantHeap = allocationContext._currentSize().longValue();
            }
            Set<J9ObjectPointer> heapClasses = this.tenantContextHelper.getClasses(tenantObject);
            long classesHeapSize = 0L;
            long classesNativeSize = 0L;
            long classesJITCodeSize = 0L;
            long classesJITDataSize = 0L;
            for (J9ObjectPointer clazz : heapClasses) {
                classesHeapSize += ObjectModel.getConsumedSizeInBytesWithHeader(clazz).longValue();
                J9ClassPointer ramClass = ConstantPoolHelpers.J9VM_J9CLASS_FROM_HEAPCLASS(clazz);
                classesNativeSize += J9ClassHelper.size(ramClass, vm).longValue();
                J9JITExceptionTablePointer jitInfo = ramClass.classLoader().jitMetaDataList();
                while (!jitInfo.isNull()) {
                    classesJITCodeSize += jitInfo.compileMethodCodeSize().longValue();
                    classesJITDataSize += jitInfo.compileMethodDataSize().longValue();
                    jitInfo = jitInfo.nextMethod();
                }
            }
            table.row(Integer.toString(tenantIndex), tenantObject.getHexAddress(), Integer.toString(threadCount), Integer.toString(daemonCount), Humanize.pointer(allocationContextRef), Humanize.bytes(staticStats.nbyte), Humanize.bytes(tenantHeap), Integer.toString(heapClasses.size()), Humanize.bytes(classesHeapSize), Humanize.bytes(classesNativeSize), Humanize.bytes(classesJITCodeSize), Humanize.bytes(classesJITDataSize), id);
            threadTotal += threadCount;
            daemonTotal += daemonCount;
            totalStatics.add(staticStats);
            heapTotal += tenantHeap;
            classesTotal += heapClasses.size();
            totalClassesHeapSize += classesHeapSize;
            totalClassesNativeSize += classesNativeSize;
            totalClassesJITCodeSize += classesJITCodeSize;
            totalClassesJITDataSize += classesJITDataSize;
            ++tenantIndex;
        }
        table.row("", "TOTALs", Integer.toString(threadTotal), Integer.toString(daemonTotal), "", Humanize.bytes(totalStatics.nbyte), Humanize.bytes(heapTotal), Integer.toString(classesTotal), Humanize.bytes(totalClassesHeapSize), Humanize.bytes(totalClassesNativeSize), Humanize.bytes(totalClassesJITCodeSize), Humanize.bytes(totalClassesJITDataSize), "");
        table.render(out);
    }

    private void dumpFinalizableInfo(J9JavaVMPointer vm, PrintStream out) throws CorruptDataException {
        GCFinalizableObjectIterator finalizableObjectIterator = GCFinalizableObjectIterator.from();
        MM_GCExtensionsPointer gcExtensions = MM_GCExtensionsPointer.cast(vm.gcExtensions());
        GC_FinalizeListManagerPointer flm = gcExtensions.finalizeListManager();
        GC_FinalizeListManagerMultiTenantPointer finalizeListManager = GC_FinalizeListManagerMultiTenantPointer.cast(flm);
        int numObjects = 0;
        out.println("!gc_finalizelistmanagermultitenant " + finalizeListManager.getHexAddress());
        out.println("Checking finalizable objects... ");
        while (finalizableObjectIterator.hasNext()) {
            ++numObjects;
            finalizableObjectIterator.next();
        }
        out.println("-> Done. Checked " + numObjects + " objects.");
        out.println("Checking if tenants require unbind notification... ");
        for (int i = 0; i < finalizeListManager._tenantCount().intValue(); ++i) {
            if (!finalizeListManager._tenantRequiresUnbindNotification().boolAt(i)) continue;
            out.println("\ttenant " + i + " requires unbind notification");
        }
        out.println("-> Done.");
    }
}

