/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadIterator;
import com.ibm.j9ddr.vm27.j9.gc.GCVMThreadListIterator;
import com.ibm.j9ddr.vm27.pointer.PointerPointer;
import com.ibm.j9ddr.vm27.pointer.VoidPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.Check;
import com.ibm.j9ddr.vm27.tools.ddrinteractive.gccheck.ScanFormatter;

class CheckVMThreads
extends Check {
    CheckVMThreads() {
    }

    public void check() {
        try {
            GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.from();
            while (vmThreadListIterator.hasNext()) {
                J9VMThreadPointer walkThread = vmThreadListIterator.next();
                GCVMThreadIterator vmthreadIterator = GCVMThreadIterator.fromJ9VMThread(walkThread);
                while (vmthreadIterator.hasNext()) {
                    PointerPointer slot = PointerPointer.cast(vmthreadIterator.nextAddress());
                    if (this._engine.checkSlotVMThread(slot, VoidPointer.cast(walkThread), 0, vmthreadIterator.getState()) == 0) continue;
                }
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }

    public String getCheckName() {
        return "VM THREAD SLOTS";
    }

    public void print() {
        try {
            GCVMThreadListIterator vmThreadListIterator = GCVMThreadListIterator.from();
            ScanFormatter formatter = new ScanFormatter(this, "VMThread Slots");
            while (vmThreadListIterator.hasNext()) {
                J9VMThreadPointer walkThread = vmThreadListIterator.next();
                formatter.section("thread", walkThread);
                GCVMThreadIterator vmthreadIterator = GCVMThreadIterator.fromJ9VMThread(walkThread);
                while (vmthreadIterator.hasNext()) {
                    formatter.entry(vmthreadIterator.next());
                }
                formatter.endSection();
            }
            formatter.end("VMThread Slots");
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
    }
}

