/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.tools.ddrinteractive.structureformat.extensions;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.BaseStructureFormatter;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.FormatWalkResult;
import com.ibm.j9ddr.tools.ddrinteractive.IFieldFormatter;
import com.ibm.j9ddr.vm27.j9.ConstantPoolHelpers;
import com.ibm.j9ddr.vm27.pointer.generated.J9ClassPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9ROMMethodPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9ClassHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9MethodHelper;
import com.ibm.j9ddr.vm27.pointer.helper.J9ROMMethodHelper;
import java.io.PrintStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class J9MethodStructureFormatter
extends BaseStructureFormatter {
    @Override
    public FormatWalkResult postFormat(String type2, long address, PrintStream out, Context context, List<IFieldFormatter> fieldFormatters, String[] extraArgs) {
        J9MethodPointer method;
        if (type2.equalsIgnoreCase("j9method") && !(method = J9MethodPointer.cast(address)).isNull()) {
            this.writeMethodName(method, out);
            this.writeJ9ROMClassAddress(method, out);
        }
        return FormatWalkResult.KEEP_WALKING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJ9ROMClassAddress(J9MethodPointer method, PrintStream out) {
        out.print("ROM Method: ");
        try {
            J9ROMMethodPointer j9romMethod = J9MethodHelper.romMethod(method);
            out.print("!j9rommethod ");
            out.print(j9romMethod.getHexAddress());
        }
        catch (CorruptDataException e) {
            out.print("<FAULT>");
        }
        finally {
            out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMethodName(J9MethodPointer method, PrintStream out) {
        out.print("Signature: ");
        try {
            J9ROMMethodPointer j9romMethod = J9MethodHelper.romMethod(method);
            J9ClassPointer clazz = ConstantPoolHelpers.J9_CLASS_FROM_METHOD(method);
            out.print(J9ClassHelper.getName(clazz));
            out.print(".");
            out.print(J9ROMMethodHelper.getName(j9romMethod));
            out.print(J9ROMMethodHelper.getSignature(j9romMethod));
            out.print(" !bytecodes ");
            out.print(method.getHexAddress());
        }
        catch (CorruptDataException ex) {
            out.print("<FAULT>");
        }
        finally {
            out.println();
        }
    }
}

