/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.types;

import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.pointer.ObjectReferencePointer;
import com.ibm.j9ddr.vm27.types.I32;
import com.ibm.j9ddr.vm27.types.I64;
import com.ibm.j9ddr.vm27.types.U64;
import com.ibm.j9ddr.vm27.types.UDATA;

public abstract class Scalar
extends DataType {
    protected long data;
    protected static final int bitsPerBytes = 8;
    protected static final int bitsPerLong = 64;
    protected String toStringPattern;

    public Scalar(long value) {
        this.data = value;
    }

    public Scalar(Scalar value) {
        this(value.data);
        if (value.sizeof() > this.sizeof()) {
            this.trimExcessBytes();
        } else if (value.sizeof() < this.sizeof()) {
            this.signExtend(value);
        }
    }

    public Scalar() {
    }

    public byte byteValue() {
        return (byte)this.data;
    }

    public short shortValue() {
        return (short)this.data;
    }

    public int intValue() {
        return (int)this.data;
    }

    public long longValue() {
        return this.data;
    }

    public String getHexValue() {
        return String.format("0x%0" + this.sizeof() * 2 + "X", this.data);
    }

    public String toString() {
        if (null == this.toStringPattern) {
            this.toStringPattern = this.getClass().getSimpleName() + "(0x%0" + this.sizeof() * 2 + "X)";
        }
        return String.format(this.toStringPattern, this.data);
    }

    public boolean equals(Object parameter) {
        if (parameter == null) {
            return false;
        }
        if (!parameter.getClass().isInstance(this)) {
            return false;
        }
        return this.data == ((Scalar)parameter).data;
    }

    public boolean eq(Scalar parameter) {
        if (parameter instanceof U64) {
            return parameter.eq(this);
        }
        return parameter.longValue() == this.longValue();
    }

    public boolean eq(long parameter) {
        return parameter == this.longValue();
    }

    public int hashCode() {
        return (int)this.data;
    }

    protected void checkComparisonValid(Scalar parameter) {
        if (this.isSigned() ^ parameter.isSigned()) {
            throw new UnsupportedOperationException("Can't compare signed and unsigned Scalars");
        }
    }

    public boolean gt(int parameter) {
        return this.gt(new I32(parameter));
    }

    public boolean gt(long parameter) {
        return this.gt(new I64(parameter));
    }

    public boolean lt(int parameter) {
        return this.lt(new I32(parameter));
    }

    public boolean lt(long parameter) {
        return this.lt(new I64(parameter));
    }

    public boolean gt(Scalar parameter) {
        this.checkComparisonValid(parameter);
        return this.longValue() > parameter.longValue();
    }

    public boolean gte(Scalar parameter) {
        return this.eq(parameter) || this.gt(parameter);
    }

    public boolean lt(Scalar parameter) {
        this.checkComparisonValid(parameter);
        return this.longValue() < parameter.longValue();
    }

    public boolean lte(Scalar parameter) {
        return this.eq(parameter) || this.lt(parameter);
    }

    public static UDATA convertBytesToSlots(UDATA size) {
        if (4 == UDATA.SIZEOF) {
            return size.rightShift(2);
        }
        return size.rightShift(3);
    }

    public static UDATA convertSlotsToBytes(UDATA size) {
        if (4 == UDATA.SIZEOF) {
            return size.leftShift(2);
        }
        return size.leftShift(3);
    }

    public static UDATA roundToSizeofUDATA(UDATA value) {
        return Scalar.roundTo(value, UDATA.SIZEOF);
    }

    public static UDATA roundToSizeToObjectReference(UDATA value) {
        return Scalar.roundTo(value, ObjectReferencePointer.SIZEOF);
    }

    public static UDATA roundToSizeofU32(UDATA value) {
        return Scalar.roundTo(value, 4L);
    }

    protected static UDATA roundTo(UDATA value, long size) {
        long result = value.longValue() + (size - 1L) & (size - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        return new UDATA(result);
    }

    public boolean allBitsIn(long bitmask) {
        return bitmask == (this.data & bitmask);
    }

    public boolean anyBitsIn(long bitmask) {
        return 0L != (this.data & bitmask);
    }

    public boolean maskAndCompare(long bitmask, long compareValue) {
        return compareValue == (this.data & bitmask);
    }

    private void trimExcessBytes() {
        int bytesToEndOfLong = 8 - this.sizeof();
        int bitsToShift = 8 * bytesToEndOfLong;
        this.data = this.data << bitsToShift >>> bitsToShift;
    }

    private void signExtend(Scalar sourceType) {
        if (sourceType.isSigned() && sourceType.signBitSet()) {
            int bytesToEndOfLong = 8 - sourceType.sizeof();
            int bytesDifference = this.sizeof() - sourceType.sizeof();
            this.data <<= 8 * bytesToEndOfLong;
            this.data >>= 8 * bytesDifference;
            this.data >>>= 8 * (bytesToEndOfLong - bytesDifference);
        }
    }

    protected boolean signBitSet() {
        return this.data >>> this.sizeof() * 8 - 1 != 0L;
    }

    public abstract int sizeof();

    public abstract boolean isSigned();
}

