/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm27.view.dtfj;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImagePointer;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageProcess;
import com.ibm.j9ddr.view.dtfj.image.J9DDRImageSection;
import com.ibm.j9ddr.vm27.j9.DataType;
import com.ibm.j9ddr.vm27.j9.J9VMThreadPointerUtil;
import com.ibm.j9ddr.vm27.pointer.AbstractPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JITDataCacheHeaderPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JITExceptionTablePointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemorySegmentListPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MemorySegmentPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9MethodPointer;
import com.ibm.j9ddr.vm27.pointer.generated.J9VMThreadPointer;
import com.ibm.j9ddr.vm27.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm27.structure.J9JITDataCacheHeader;
import com.ibm.j9ddr.vm27.types.UDATA;
import com.ibm.j9ddr.vm27.view.dtfj.java.DTFJJavaRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTFJContext {
    public static final long J9DataTypeExceptionInfo = 1L;
    public static final long J9DataTypeHashTable = 32L;
    public static final long J9DataTypeRelocationData = 4L;
    public static final long J9DataTypeStackAtlas = 2L;
    public static final long J9DataTypeThunkMappingData = 16L;
    public static final long J9DataTypeThunkMappingList = 8L;
    private static final IProcess process;
    private static final J9JavaVMPointer vm;
    private static List<J9VMThreadPointerUtil.ThreadInfo> threadInfoCache;
    private static DTFJJavaRuntime runtime;
    private static J9DDRImageProcess imageProcess;
    private static Map<J9MethodPointer, List<J9JITExceptionTablePointer>> jitMethodCache;

    public static IProcess getProcess() {
        return process;
    }

    public static J9JavaVMPointer getVm() {
        return vm;
    }

    public static J9DDRImagePointer getImagePointer(long address) {
        return new J9DDRImagePointer(process, address);
    }

    public static J9DDRImageSection getImageSection(long address, String name) {
        return new J9DDRImageSection(process, address, name);
    }

    public static Logger getLogger() {
        return Logger.getLogger("j9ddr.view.dtfj");
    }

    public static List<J9VMThreadPointerUtil.ThreadInfo> getThreadInfoCache() throws CorruptDataException {
        if (threadInfoCache == null) {
            J9VMThreadPointer vmThread;
            ArrayList<J9VMThreadPointerUtil.ThreadInfo> localThreadInfoCache = new ArrayList<J9VMThreadPointerUtil.ThreadInfo>();
            J9VMThreadPointer firstThread = vmThread = DTFJContext.getVm().mainThread();
            do {
                J9VMThreadPointerUtil.ThreadInfo info = J9VMThreadPointerUtil.getJ9State(vmThread);
                localThreadInfoCache.add(info);
            } while (!(vmThread = vmThread.linkNext()).eq(firstThread));
            threadInfoCache = localThreadInfoCache;
        }
        return threadInfoCache;
    }

    public static void setRuntime(DTFJJavaRuntime r) {
        runtime = r;
    }

    public static DTFJJavaRuntime getRuntime() {
        return runtime;
    }

    public static List<J9JITExceptionTablePointer> getJITMetaData(J9MethodPointer j9ramMethod) {
        if (jitMethodCache == null) {
            DTFJContext.cacheJITMethodAddresses();
        }
        return jitMethodCache.get(j9ramMethod);
    }

    private static void cacheJITMethodAddresses() {
        jitMethodCache = new HashMap<J9MethodPointer, List<J9JITExceptionTablePointer>>();
        try {
            J9MemorySegmentListPointer dataCacheList = DTFJContext.getVm().jitConfig().dataCacheList();
            J9MemorySegmentPointer dataCache = dataCacheList.nextSegment();
            while (dataCache.notNull()) {
                UDATA current = UDATA.cast(dataCache.heapBase());
                UDATA end = UDATA.cast(dataCache.heapAlloc());
                while (current.lt(end)) {
                    J9JITDataCacheHeaderPointer hdr = J9JITDataCacheHeaderPointer.cast(current);
                    if (hdr.type().longValue() == 1L) {
                        J9JITExceptionTablePointer metaData = J9JITExceptionTablePointer.cast(current.add(J9JITDataCacheHeader.SIZEOF));
                        DTFJContext.addMetaData(metaData);
                    }
                    current = current.add(hdr.size());
                }
                dataCache = dataCache.nextSegment();
            }
        }
        catch (CorruptDataException e) {
            return;
        }
    }

    private static void addMetaData(J9JITExceptionTablePointer metaData) throws CorruptDataException {
        if (metaData.constantPool().isNull()) {
            return;
        }
        List<J9JITExceptionTablePointer> bucket = jitMethodCache.get(metaData.ramMethod());
        if (bucket == null) {
            bucket = new ArrayList<J9JITExceptionTablePointer>();
            jitMethodCache.put(metaData.ramMethod(), bucket);
        }
        bucket.add(metaData);
    }

    public static void setImageProcess(J9DDRImageProcess process) {
        imageProcess = process;
    }

    public static J9DDRImageProcess getImageProcess() {
        return imageProcess;
    }

    static {
        threadInfoCache = null;
        jitMethodCache = null;
        process = AbstractPointer.getProcess();
        J9JavaVMPointer temp = null;
        try {
            temp = J9RASHelper.getVM(DataType.getJ9RASPointer());
        }
        catch (CorruptDataException e) {
            DTFJContext.getLogger().log(Level.FINE, "", e);
        }
        vm = temp;
    }
}

