/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.misc;

import com.ibm.misc.CharacterEncoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexDumpEncoder
extends CharacterEncoder {
    private int offset;
    private int thisLineLength;
    private int currentByte;
    private byte[] thisLine = new byte[16];

    static void hexDigit(OutputStream o, byte x) {
        int workarea = 0;
        try {
            workarea = x >> 4;
            o.write(HexDumpEncoder.trimIt(Integer.toHexString(workarea)).getBytes("8859_1"));
            workarea = x & 0xF;
            o.write(HexDumpEncoder.trimIt(Integer.toHexString(workarea)).getBytes("8859_1"));
        }
        catch (Exception e) {
            System.out.println("Unable to write to output stream: " + e);
        }
    }

    private static String trimIt(String origResult) {
        if (origResult == null) {
            return new String("00");
        }
        int currLength = origResult.length();
        if (currLength == 0) {
            return new String("00");
        }
        if (currLength <= 2) {
            return origResult;
        }
        return origResult.substring(currLength - 1);
    }

    @Override
    protected int bytesPerAtom() {
        return 1;
    }

    @Override
    protected int bytesPerLine() {
        return 16;
    }

    @Override
    protected void encodeBufferPrefix(OutputStream o) throws IOException {
        this.offset = 0;
        super.encodeBufferPrefix(o);
    }

    @Override
    protected void encodeLinePrefix(OutputStream o, int len) throws IOException {
        HexDumpEncoder.hexDigit(o, (byte)(this.offset >>> 8 & 0xFF));
        HexDumpEncoder.hexDigit(o, (byte)(this.offset & 0xFF));
        o.write(58);
        o.write(32);
        this.currentByte = 0;
        this.thisLineLength = len;
    }

    @Override
    protected void encodeAtom(OutputStream o, byte[] buf, int off, int len) throws IOException {
        this.thisLine[this.currentByte] = buf[off];
        HexDumpEncoder.hexDigit(o, buf[off]);
        o.write(32);
        ++this.currentByte;
        if (this.currentByte == 8) {
            o.write(32);
        }
    }

    @Override
    protected void encodeLineSuffix(OutputStream o) throws IOException {
        int i;
        if (this.thisLineLength < 16) {
            for (i = this.thisLineLength; i < 16; ++i) {
                o.write(32);
                o.write(32);
                o.write(32);
                if (i != 7) continue;
                o.write(32);
                o.write(32);
            }
        }
        o.write(32);
        for (i = 0; i < this.thisLineLength; ++i) {
            if (this.thisLine[i] < 48 || this.thisLine[i] > 122 || this.thisLine[i] > 57 && this.thisLine[i] < 65 || this.thisLine[i] > 90 && this.thisLine[i] < 97) {
                o.write(46);
                continue;
            }
            o.write(this.thisLine[i]);
        }
        o.write(10);
        this.offset += this.thisLineLength;
    }
}

