/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.ec;

import com.ibm.misc.Debug;
import com.ibm.security.ec.ECKeyFactory;
import com.ibm.security.ec.NamedCurve;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;

public final class ECParameters
extends AlgorithmParametersSpi {
    private static Debug debug = Debug.getInstance("ibmpkcs");
    static boolean enableDebugFlag = false;
    static boolean enableDebugFlag2 = false;
    private ECParameterSpec paramSpec;

    public ECParameters() {
        if (debug != null) {
            debug.entry(16384L, "ECParameters", "ECParameters()");
        }
    }

    public static ECPoint decodePoint(byte[] data, EllipticCurve curve) throws IOException {
        int n = curve.getField().getFieldSize() + 7 >> 3;
        int offset = data.length > 2 && data[0] == 4 && data[1] + 2 == data.length && data[2] == 4 && data.length == n * 2 + 1 + 2 ? 2 : (data.length > 3 && data[0] == 4 && (0xFF & data[1]) == 129 && (0xFF & data[2]) + 3 == data.length && data[3] == 4 && data.length == n * 2 + 1 + 3 ? 3 : 0);
        if (data.length <= offset || data[offset] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        if (data.length != n * 2 + 1 + offset) {
            throw new IOException("Point does not match field size");
        }
        byte[] xb = new byte[n];
        byte[] yb = new byte[n];
        System.arraycopy(data, offset + 1, xb, 0, n);
        System.arraycopy(data, offset + n + 1, yb, 0, n);
        return new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
    }

    public static byte[] encodePoint(ECPoint point, EllipticCurve curve) {
        int n = curve.getField().getFieldSize() + 7 >> 3;
        byte[] xb = ECParameters.trimZeroes(point.getAffineX().toByteArray());
        byte[] yb = ECParameters.trimZeroes(point.getAffineY().toByteArray());
        if (xb.length > n || yb.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] b = new byte[1 + (n << 1)];
        b[0] = 4;
        System.arraycopy(xb, 0, b, n - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, b, b.length - yb.length, yb.length);
        return b;
    }

    static byte[] trimZeroes(byte[] b) {
        int i;
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        byte[] t = new byte[b.length - i];
        System.arraycopy(b, i, t, 0, t.length);
        return t;
    }

    public static NamedCurve getNamedCurve(ECParameterSpec params) {
        if (debug != null) {
            debug.entry(16384L, "ECParameters", "getNamedCurve");
        }
        if (params instanceof NamedCurve || params == null) {
            if (debug != null) {
                debug.text(16384L, "ECParameters", "getNamedCurve", "params is null or NamedCurve");
                debug.exit(16384L, "ECParameters", "getNamedCurve");
            }
            return (NamedCurve)params;
        }
        int fieldSize = params.getCurve().getField().getFieldSize();
        for (ECParameterSpec eCParameterSpec : NamedCurve.knownECParameterSpecs()) {
            if (debug != null) {
                debug.text(16384L, "ECParameters", "getNamedCurve", eCParameterSpec.toString());
            }
            if (eCParameterSpec.getCurve().getField().getFieldSize() != fieldSize || !eCParameterSpec.getCurve().equals(params.getCurve()) || !eCParameterSpec.getGenerator().equals(params.getGenerator()) || !eCParameterSpec.getOrder().equals(params.getOrder()) || eCParameterSpec.getCofactor() != params.getCofactor()) continue;
            return (NamedCurve)eCParameterSpec;
        }
        return null;
    }

    public static String getCurveName(ECParameterSpec params) {
        if (debug != null) {
            debug.entry(16384L, "ECParameters", "getCurveName");
        }
        NamedCurve curve = ECParameters.getNamedCurve(params);
        if (debug != null) {
            debug.exit(16384L, "ECParameters", "getCurveName");
        }
        return curve == null ? null : curve.getObjectIdentifier().toString();
    }

    public static AlgorithmParameters getAlgorithmParameters(ECParameterSpec spec) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, "ECParameters", "getAlgorithmParameters");
        }
        try {
            AlgorithmParameters params = AlgorithmParameters.getInstance("EC", ECKeyFactory.ecInternalProvider);
            params.init(spec);
            if (debug != null) {
                debug.exit(16384L, "ECParameters", "getAlgorithmParameters");
            }
            return params;
        }
        catch (GeneralSecurityException e) {
            if (debug != null) {
                debug.exception(16384L, "ECParameters", "getAlgorithmParameters", e);
                debug.exit(16384L, "ECParameters", "getAlgorithmParameters");
            }
            throw new InvalidKeyException("EC parameters error", e);
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (paramSpec instanceof ECParameterSpec) {
            this.paramSpec = ECParameters.getNamedCurve((ECParameterSpec)paramSpec);
            if (this.paramSpec == null) {
                this.paramSpec = (ECParameterSpec)paramSpec;
            }
        } else if (paramSpec instanceof ECGenParameterSpec) {
            String name = ((ECGenParameterSpec)paramSpec).getName();
            ECParameterSpec spec = NamedCurve.getECParameterSpec(name);
            if (spec == null) {
                throw new InvalidParameterSpecException("Unknown curve: " + name);
            }
            this.paramSpec = spec;
        } else {
            if (paramSpec == null) {
                throw new InvalidParameterSpecException("paramSpec must not be null");
            }
            throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
        }
    }

    @Override
    protected void engineInit(byte[] params) throws IOException {
        this.paramSpec = ECParameters.decodeParameters(params);
    }

    @Override
    protected void engineInit(byte[] params, String decodingMethod) throws IOException {
        this.engineInit(params);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> spec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(16384L, "ECParameters", "engineGetParameterSpec");
        }
        if (spec.isAssignableFrom(ECParameterSpec.class)) {
            if (debug != null) {
                debug.text(16384L, "ECParameters", "engineGetParameterSpec", "spec is ECParameterSpec");
                debug.exit(16384L, "ECParameters", "engineGetParameterSpec");
            }
            return (T)this.paramSpec;
        }
        if (spec.isAssignableFrom(ECGenParameterSpec.class)) {
            if (debug != null) {
                debug.text(16384L, "ECParameters", "engineGetParameterSpec", "spec is ECGenParameterSpec");
                debug.exit(16384L, "ECParameters", "engineGetParameterSpec");
            }
            return (T)new ECGenParameterSpec(ECParameters.getCurveName(this.paramSpec));
        }
        throw new InvalidParameterSpecException("Only ECParameterSpec and ECGenParameterSpec supported");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        return ECParameters.encodeParameters(this.paramSpec);
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.paramSpec.toString();
    }

    public static DerValue encodeEllipticCurve(EllipticCurve curve) throws IOException {
        try {
            byte[] aByteArray = ECParameters.trimZeroes(curve.getA().toByteArray());
            byte[] bByteArray = ECParameters.trimZeroes(curve.getB().toByteArray());
            byte[] seed = curve.getSeed();
            DerOutputStream out = new DerOutputStream();
            out.putOctetString(aByteArray);
            out.putOctetString(bByteArray);
            if (seed != null) {
                out.putBitString(seed);
            }
            DerValue val = new DerValue(48, out.toByteArray());
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in encodeEllipticCurve(): " + e);
        }
    }

    public static EllipticCurve decodeEllipticCurve(DerValue encodedEllipticCurve, ECField ecField) throws IOException {
        try {
            if (encodedEllipticCurve.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = encodedEllipticCurve.getData();
            byte[] aByteArray = data.getOctetString();
            BigInteger a = new BigInteger(1, aByteArray);
            byte[] bByteArray = data.getOctetString();
            BigInteger b = new BigInteger(1, bByteArray);
            byte[] seed = null;
            if (data.available() != 0) {
                seed = data.getBitString();
            }
            EllipticCurve ellipticCurve = null;
            ellipticCurve = seed == null ? new EllipticCurve(ecField, a, b) : new EllipticCurve(ecField, a, b, seed);
            return ellipticCurve;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeEllipticCurve(): " + e);
        }
    }

    public static DerValue encodePrimeFieldType(ECFieldFp fieldID) throws IOException {
        try {
            int[] primeFieldType_data = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier primeFieldTypeOID = new ObjectIdentifier(primeFieldType_data);
            BigInteger p = fieldID.getP();
            DerOutputStream out = new DerOutputStream();
            out.putOID(primeFieldTypeOID);
            out.putInteger(p);
            DerValue val = new DerValue(48, out.toByteArray());
            return val;
        }
        catch (IOException e) {
            throw new IOException("Exception in encodePrimeFieldType(): " + e);
        }
    }

    public static ECFieldFp decodePrimeFieldType(DerValue encodedPrimeFieldType) throws IOException {
        int[] primeFieldType_data = new int[]{1, 2, 840, 10045, 1, 1};
        ObjectIdentifier primeFieldTypeOID = null;
        try {
            primeFieldTypeOID = new ObjectIdentifier(primeFieldType_data);
            if (encodedPrimeFieldType.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = encodedPrimeFieldType.getData();
            ObjectIdentifier decodedPrimeFieldTypeOID = data.getOID();
            if (!decodedPrimeFieldTypeOID.equals(primeFieldTypeOID)) {
                throw new IOException("Incorrect OID encountered during decodePrimeFieldType.");
            }
            BigInteger p = data.getBigInteger();
            ECFieldFp myFieldID = new ECFieldFp(p);
            return myFieldID;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodePrimeFieldType(): " + e);
        }
    }

    public static DerValue encodeCharacteristic2FieldType(ECFieldF2m fieldID) throws IOException {
        boolean normalBasis = false;
        boolean trinomialBasis = false;
        boolean pentanomialBasis = false;
        DerValue val1 = null;
        try {
            int[] characteristic2FieldType_data = new int[]{1, 2, 840, 10045, 1, 2};
            ObjectIdentifier characteristic2FieldTypeOID = new ObjectIdentifier(characteristic2FieldType_data);
            int M = fieldID.getM();
            ObjectIdentifier gnBasisOID = null;
            ObjectIdentifier tpBasisOID = null;
            ObjectIdentifier ppBasisOID = null;
            int trinomialBasisParameter = 0;
            int[] k = new int[3];
            int[] middleTerms = fieldID.getMidTermsOfReductionPolynomial();
            if (middleTerms == null) {
                normalBasis = true;
                int[] gnBasis_data = new int[]{1, 2, 840, 10045, 2, 2, 3, 1};
                gnBasisOID = new ObjectIdentifier(gnBasis_data);
            } else if (middleTerms.length == 1) {
                trinomialBasis = true;
                int[] tpBasis_data = new int[]{1, 2, 840, 10045, 2, 2, 3, 2};
                tpBasisOID = new ObjectIdentifier(tpBasis_data);
                trinomialBasisParameter = middleTerms[0];
            } else {
                if (middleTerms.length != 3) {
                    throw new RuntimeException("Incorrect number of middle terms returned from ECFieldF2m.getMidTermsOfReductionPolynomial()");
                }
                pentanomialBasis = true;
                int[] ppBasis_data = new int[]{1, 2, 840, 10045, 2, 2, 3, 3};
                ppBasisOID = new ObjectIdentifier(ppBasis_data);
                boolean lowToHigh = true;
                ECParameters.mySort(middleTerms, lowToHigh);
                k[0] = middleTerms[0];
                k[1] = middleTerms[1];
                k[2] = middleTerms[2];
            }
            DerOutputStream out2 = new DerOutputStream();
            if (normalBasis) {
                out2.putInteger(M);
                out2.putOID(gnBasisOID);
            } else if (trinomialBasis) {
                out2.putInteger(M);
                out2.putOID(tpBasisOID);
                out2.putInteger(trinomialBasisParameter);
            } else if (pentanomialBasis) {
                out2.putInteger(M);
                out2.putOID(ppBasisOID);
                out2.putInteger(k[0]);
                out2.putInteger(k[1]);
                out2.putInteger(k[2]);
            } else {
                throw new RuntimeException("Incorrect basis computed.");
            }
            DerValue val2 = new DerValue(48, out2.toByteArray());
            DerOutputStream out1 = new DerOutputStream();
            out1.putOID(characteristic2FieldTypeOID);
            out1.putDerValue(val2);
            val1 = new DerValue(48, out1.toByteArray());
            return val1;
        }
        catch (IOException e) {
            throw new IOException("Exception in encodeCharacteristic2FieldType(): " + e);
        }
    }

    public static ECFieldF2m decodeCharacteristic2FieldType(DerValue encodedCharacteristic2FieldType) throws IOException {
        try {
            int[] characteristic2FieldType_data = new int[]{1, 2, 840, 10045, 1, 2};
            ObjectIdentifier characteristic2FieldTypeOID = new ObjectIdentifier(characteristic2FieldType_data);
            int[] gnBasis_data = new int[]{1, 2, 840, 10045, 2, 2, 3, 1};
            ObjectIdentifier gnBasisOID = new ObjectIdentifier(gnBasis_data);
            int[] tpBasis_data = new int[]{1, 2, 840, 10045, 2, 2, 3, 2};
            ObjectIdentifier tpBasisOID = new ObjectIdentifier(tpBasis_data);
            int[] ppBasis_data = new int[]{1, 2, 840, 10045, 2, 2, 3, 3};
            ObjectIdentifier ppBasisOID = new ObjectIdentifier(ppBasis_data);
            if (encodedCharacteristic2FieldType.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data = encodedCharacteristic2FieldType.getData();
            ObjectIdentifier decodedCharacteristic2FieldTypeOID = data.getOID();
            if (!decodedCharacteristic2FieldTypeOID.equals(characteristic2FieldTypeOID)) {
                throw new IOException("Incorrect OID encountered during decodeCharacteristic2FieldType.");
            }
            DerValue embeddedSequenceDerValue = data.getDerValue();
            if (embeddedSequenceDerValue.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream data2 = embeddedSequenceDerValue.getData();
            BigInteger M = data2.getInteger();
            ObjectIdentifier basisOID = data2.getOID();
            BigInteger tpBasisParameter = new BigInteger("0");
            BigInteger[] k = new BigInteger[3];
            int[] kIntArray = new int[3];
            if (!basisOID.equals(gnBasisOID)) {
                if (basisOID.equals(tpBasisOID)) {
                    tpBasisParameter = data2.getInteger();
                } else if (basisOID.equals(ppBasisOID)) {
                    k[0] = data2.getInteger();
                    k[1] = data2.getInteger();
                    k[2] = data2.getInteger();
                    boolean lowToHigh = false;
                    ECParameters.mySort(k, lowToHigh);
                    kIntArray[0] = k[0].intValue();
                    kIntArray[1] = k[1].intValue();
                    kIntArray[2] = k[2].intValue();
                } else {
                    throw new IOException("basis OID is incorrect.");
                }
            }
            ECFieldF2m myECFieldF2m = null;
            if (basisOID.equals(gnBasisOID)) {
                myECFieldF2m = new ECFieldF2m(M.intValue());
            } else if (basisOID.equals(tpBasisOID)) {
                int[] mySingleElementKArray = new int[]{tpBasisParameter.intValue()};
                myECFieldF2m = new ECFieldF2m(M.intValue(), mySingleElementKArray);
            } else if (basisOID.equals(ppBasisOID)) {
                myECFieldF2m = new ECFieldF2m(M.intValue(), kIntArray);
            }
            return myECFieldF2m;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeCharacteristic2FieldType(): " + e);
        }
    }

    public static byte[] encodeParameters(ECParameterSpec inputECParameterSpec) {
        try {
            EllipticCurve curve = inputECParameterSpec.getCurve();
            ECPoint ecPoint = inputECParameterSpec.getGenerator();
            BigInteger order = inputECParameterSpec.getOrder();
            int cofactor = inputECParameterSpec.getCofactor();
            ECField ecField = curve.getField();
            DerOutputStream out = new DerOutputStream();
            out.putInteger(1);
            if (ecField instanceof ECFieldFp) {
                DerValue encodedPrimeFieldType = ECParameters.encodePrimeFieldType((ECFieldFp)ecField);
                out.putDerValue(encodedPrimeFieldType);
            } else if (ecField instanceof ECFieldF2m) {
                DerValue encodedCharacteristic2FieldType = ECParameters.encodeCharacteristic2FieldType((ECFieldF2m)ecField);
                out.putDerValue(encodedCharacteristic2FieldType);
            } else {
                throw new RuntimeException("ECField error encountered in encodeECParameters().  The ECField class could not be determined.");
            }
            DerValue encodedEllipticCurve = ECParameters.encodeEllipticCurve(curve);
            out.putDerValue(encodedEllipticCurve);
            byte[] encodedECPoint = ECParameters.encodePoint(ecPoint, curve);
            out.putOctetString(encodedECPoint);
            out.putInteger(order);
            out.putInteger(cofactor);
            DerValue val = new DerValue(48, out.toByteArray());
            byte[] encodedECParameterSpec = val.toByteArray();
            return encodedECParameterSpec;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception in encodeECParameters(): " + e);
        }
    }

    public static ECParameterSpec decodeParameters(byte[] encodedECParameters) throws IOException {
        boolean haveCofactor = false;
        try {
            DerInputStream in = new DerInputStream(encodedECParameters);
            DerValue derValue = in.getDerValue();
            if (derValue.getTag() != 48) {
                if (derValue.getTag() == 6) {
                    String oid = derValue.getOID().toString();
                    return NamedCurve.getECParameterSpec(oid);
                }
                throw new IOException("Not a SEQUENCE or an OID");
            }
            DerInputStream data = derValue.getData();
            int version = data.getBigInteger().intValue();
            DerValue encodedFieldID = data.getDerValue();
            byte[] temp = encodedFieldID.toByteArray();
            DerValue myClone = new DerValue(temp);
            int[] primeFieldType_data = new int[]{1, 2, 840, 10045, 1, 1};
            ObjectIdentifier primeFieldTypeOID = new ObjectIdentifier(primeFieldType_data);
            int[] characteristic2FieldType_data = new int[]{1, 2, 840, 10045, 1, 2};
            ObjectIdentifier characteristic2FieldTypeOID = new ObjectIdentifier(characteristic2FieldType_data);
            if (myClone.getTag() != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream dataTemp = myClone.getData();
            ECField fieldID = null;
            ObjectIdentifier encodedFieldIDOID = dataTemp.getOID();
            if (encodedFieldIDOID.equals(primeFieldTypeOID)) {
                fieldID = ECParameters.decodePrimeFieldType(encodedFieldID);
            } else if (encodedFieldIDOID.equals(characteristic2FieldTypeOID)) {
                fieldID = ECParameters.decodeCharacteristic2FieldType(encodedFieldID);
            } else {
                throw new IOException("Incorrect field type OID encountered during decodeParameters.");
            }
            DerValue encodedEllipticCurve = data.getDerValue();
            EllipticCurve curve = ECParameters.decodeEllipticCurve(encodedEllipticCurve, fieldID);
            byte[] encodedECPoint = data.getOctetString();
            ECPoint ecPoint = ECParameters.decodePoint(encodedECPoint, curve);
            BigInteger order = data.getBigInteger();
            int cofactor = 0;
            if (data.available() != 0) {
                haveCofactor = true;
                cofactor = data.getBigInteger().intValue();
            }
            ECParameterSpec ecParameterSpec = null;
            ecParameterSpec = haveCofactor ? new ECParameterSpec(curve, ecPoint, order, cofactor) : new ECParameterSpec(curve, ecPoint, order, 0);
            return ecParameterSpec;
        }
        catch (IOException e) {
            throw new IOException("Exception in decodeECParameters(): " + e);
        }
    }

    public static void mySort(BigInteger[] myArray, boolean lowToHigh) {
        boolean done = false;
        while (!done) {
            boolean didSwapOccur = false;
            for (int i = 0; i < myArray.length - 1; ++i) {
                BigInteger temp;
                if (lowToHigh) {
                    if (myArray[i].compareTo(myArray[i + 1]) != 1) continue;
                    temp = myArray[i];
                    myArray[i] = myArray[i + 1];
                    myArray[i + 1] = temp;
                    didSwapOccur = true;
                    continue;
                }
                if (myArray[i].compareTo(myArray[i + 1]) != -1) continue;
                temp = myArray[i];
                myArray[i] = myArray[i + 1];
                myArray[i + 1] = temp;
                didSwapOccur = true;
            }
            if (didSwapOccur) continue;
            done = true;
        }
    }

    public static void mySort(int[] myArray, boolean lowToHigh) {
        boolean done = false;
        while (!done) {
            boolean didSwapOccur = false;
            for (int i = 0; i < myArray.length - 1; ++i) {
                int temp;
                if (lowToHigh) {
                    if (myArray[i] <= myArray[i + 1]) continue;
                    temp = myArray[i];
                    myArray[i] = myArray[i + 1];
                    myArray[i + 1] = temp;
                    didSwapOccur = true;
                    continue;
                }
                if (myArray[i] >= myArray[i + 1]) continue;
                temp = myArray[i];
                myArray[i] = myArray[i + 1];
                myArray[i + 1] = temp;
                didSwapOccur = true;
            }
            if (didSwapOccur) continue;
            done = true;
        }
    }
}

