/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.pkcs12;

import com.ibm.misc.Debug;
import com.ibm.security.pkcs12.Bag;
import com.ibm.security.pkcs12.BasicPFX;
import com.ibm.security.pkcs12.CertBag;
import com.ibm.security.pkcs12.CrlBag;
import com.ibm.security.pkcs12.KeyBag;
import com.ibm.security.pkcs12.MacData;
import com.ibm.security.pkcs12.SafeBag;
import com.ibm.security.pkcs12.ShroudedKeyBag;
import com.ibm.security.pkcs7.ContentInfo;
import com.ibm.security.pkcs7.EncryptedContentInfo;
import com.ibm.security.pkcs7.EncryptedData;
import com.ibm.security.pkcs8.EncryptedPrivateKeyInfo;
import com.ibm.security.pkcs8.PrivateKeyInfo;
import com.ibm.security.pkcsutil.PKCSAttribute;
import com.ibm.security.pkcsutil.PKCSAttributes;
import com.ibm.security.pkcsutil.PKCSException;
import com.ibm.security.pkcsutil.PKCSOID;
import com.ibm.security.pkcsutil.SmudgedChars;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Locale;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PFX
extends BasicPFX
implements Cloneable {
    private Cipher cipher;
    private Vector unprotectedBags = new Vector();
    private Vector protectedBags = new Vector();
    SmudgedChars savedPasswd = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.pkcs12.PFX";

    public PFX() {
        if (debug != null) {
            debug.entry(16384L, className, "PFX");
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(String provider) {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PFX", provider);
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(byte[] der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "PFX", (Object)der);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(byte[] der, String provider) throws IOException {
        super(provider);
        if (debug != null) {
            debug.entry(16384L, className, "PFX", der, provider);
        }
        this.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(String filename, boolean base64) throws IOException {
        super(filename, base64);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64)};
            debug.entry(16384L, (Object)className, "PFX", parms);
            debug.exit(16384L, className, "PFX");
        }
    }

    public PFX(String filename, boolean base64, String provider) throws IOException {
        super(filename, base64, provider);
        if (debug != null) {
            Object[] parms = new Object[]{filename, new Boolean(base64), provider};
            debug.entry(16384L, (Object)className, "PFX", parms);
            debug.exit(16384L, className, "PFX");
        }
    }

    public Object clone() {
        try {
            if (debug != null) {
                debug.entry(16384L, className, "clone");
            }
            DerOutputStream derout = new DerOutputStream();
            this.encode(derout);
            PFX retobj = new PFX(derout.toByteArray(), this.provider);
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_1", retobj);
            }
            return retobj;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone_2", null);
            }
            return null;
        }
    }

    public synchronized void addCertificate(Certificate cert, String friendlyName, byte[] localKeyId) throws PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{cert, friendlyName, localKeyId};
            debug.entry(16384L, (Object)className, "addCertificate", parms);
        }
        if (cert == null) {
            if (debug != null) {
                debug.text(16384L, className, "addCertificate", "Certificate must be specified.");
            }
            throw new PKCSException("Certificate must be specified.");
        }
        if (localKeyId == null || localKeyId.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addCertificate", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        CertBag bag = new CertBag(cert, this.provider);
        this.addInfo(bag, friendlyName, localKeyId);
        if (debug != null) {
            debug.exit(16384L, className, "addCertificate");
        }
    }

    public synchronized void addPrivateKey(PrivateKey key, String friendlyName, byte[] localKeyId) throws PKCSException, IOException {
        if (debug != null) {
            Object[] parms = new Object[]{key, friendlyName, localKeyId};
            debug.entry(16384L, (Object)className, "addPrivateKey", parms);
        }
        if (key == null) {
            if (debug != null) {
                debug.text(16384L, className, "addPrivateKey", "Private key must be specified.");
            }
            throw new PKCSException("Private key must be specified.");
        }
        if (localKeyId == null || localKeyId.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addPrivateKey", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        PrivateKeyInfo keyInfo = new PrivateKeyInfo(key.getEncoded(), this.provider);
        KeyBag bag = new KeyBag(keyInfo, this.provider);
        this.addInfo(bag, friendlyName, localKeyId);
        if (debug != null) {
            debug.exit(16384L, className, "addPrivateKey");
        }
    }

    public synchronized void addShroudedKey(EncryptedPrivateKeyInfo key, String friendlyName, byte[] localKeyId) throws PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{key, friendlyName, localKeyId};
            debug.entry(16384L, (Object)className, "addShroudedKey", parms);
        }
        if (key == null) {
            if (debug != null) {
                debug.text(16384L, className, "addShroudedKey", "Shrouded key must be specified.");
            }
            throw new PKCSException("Shrouded key must be specified.");
        }
        if (localKeyId == null || localKeyId.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addShroudedKey", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        ShroudedKeyBag bag = new ShroudedKeyBag(key, this.provider);
        this.addInfo(bag, friendlyName, localKeyId);
        if (debug != null) {
            debug.exit(16384L, className, "addShroudedKey");
        }
    }

    public synchronized void addCRL(CRL crl, String friendlyName, byte[] localKeyId) throws PKCSException {
        if (debug != null) {
            Object[] parms = new Object[]{crl, friendlyName, localKeyId};
            debug.entry(16384L, (Object)className, "addCRL", parms);
        }
        if (crl == null) {
            if (debug != null) {
                debug.text(16384L, className, "addCRL", "CRL must be specified.");
            }
            throw new PKCSException("CRL must be specified.");
        }
        if (localKeyId == null || localKeyId.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "addCRL", "Local key id must be specified.");
            }
            throw new PKCSException("Local key id must be specified.");
        }
        CrlBag bag = new CrlBag(crl, this.provider);
        this.addInfo(bag, friendlyName, localKeyId);
        if (debug != null) {
            debug.exit(16384L, className, "addCRL");
        }
    }

    public synchronized void protect(String encryptionAlg, char[] pwd) throws NoSuchAlgorithmException, IOException, PKCSException {
        int i;
        if (debug != null) {
            debug.entry(16384L, className, "protect", encryptionAlg, pwd);
        }
        if (pwd == null || pwd.length == 0) {
            if (debug != null) {
                debug.text(16384L, className, "protect", "Password must be specified.");
            }
            throw new PKCSException("Password must be specified.");
        }
        if (this.getSavedPassword() != null) {
            boolean pwdChanged = false;
            if (this.getSavedPassword().length != pwd.length) {
                pwdChanged = true;
            } else {
                char[] tmppassword = this.getSavedPassword();
                for (int i2 = 0; i2 < pwd.length; ++i2) {
                    if (tmppassword[i2] == pwd[i2]) continue;
                    pwdChanged = true;
                    break;
                }
                Arrays.fill(tmppassword, ' ');
            }
            if (pwdChanged) {
                for (int i3 = 0; i3 < this.protectedBags.size(); ++i3) {
                    this.unprotectedBags.add(this.protectedBags.elementAt(i3));
                }
                this.protectedBags.clear();
                this.authSafeContents = null;
            }
        }
        if (this.unprotectedBags.size() == 0) {
            if (debug != null) {
                debug.exit(16384L, className, "protect_1");
            }
            return;
        }
        SafeBag[] safeBags = new SafeBag[this.unprotectedBags.size()];
        for (i = 0; i < this.unprotectedBags.size(); ++i) {
            safeBags[i] = (SafeBag)this.unprotectedBags.elementAt(i);
        }
        super.addSafeBagsWithPasswordPrivacy(safeBags, encryptionAlg, pwd);
        for (i = 0; i < this.unprotectedBags.size(); ++i) {
            this.protectedBags.add(this.unprotectedBags.elementAt(i));
        }
        this.unprotectedBags.clear();
        super.applyMac(pwd, 1);
        this.setSavedPassword((char[])pwd.clone());
        if (debug != null) {
            debug.exit(16384L, className, "protect_2");
        }
    }

    public PrivateKeyInfo[] getPrivateKeys(char[] pwd) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getPrivateKeys", (Object)pwd);
            debug.exit(16384L, (Object)className, "getPrivateKeys", super.getPrivateKeys(pwd, null, null, false));
        }
        return super.getPrivateKeys(pwd, null, null, false);
    }

    public EncryptedPrivateKeyInfo[] getShroudedKeys(char[] pwd) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getShroudedKeys", (Object)pwd);
            debug.exit(16384L, (Object)className, "getShroudedKeys", super.getShroudedKeys(pwd, null, null, false));
        }
        return super.getShroudedKeys(pwd, null, null, false);
    }

    public Certificate[] getCertificates(char[] pwd) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCertificates", (Object)pwd);
            debug.exit(16384L, (Object)className, "getCertificates", super.getCertificates(pwd, null, null, false));
        }
        return super.getCertificates(pwd, null, null, false);
    }

    public CRL[] getCRLs(char[] pwd) throws IOException, PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getCRLs", (Object)pwd);
            debug.exit(16384L, (Object)className, "getCRLs", super.getCRLs(pwd, null, null, false));
        }
        return super.getCRLs(pwd, null, null, false);
    }

    @Override
    public String[] getFriendlyNames(char[] pwd) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getFriendlyNames", (Object)pwd);
            debug.exit(16384L, (Object)className, "getFriendlyNames", super.getFriendlyNames(pwd));
        }
        return super.getFriendlyNames(pwd);
    }

    @Override
    public Certificate[] getCertificatesByFriendlyName(char[] pwd, String friendlyName) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByFriendlyName", pwd, friendlyName);
            debug.exit(16384L, (Object)className, "getCertificatesByFriendlyName", super.getCertificatesByFriendlyName(pwd, friendlyName));
        }
        return super.getCertificatesByFriendlyName(pwd, friendlyName);
    }

    @Override
    public PrivateKeyInfo[] getPrivateKeysByFriendlyName(char[] pwd, String friendlyName) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getPrivateKeysByFriendlyName", pwd, friendlyName);
            debug.exit(16384L, (Object)className, "getPrivateKeysByFriendlyName", super.getPrivateKeysByFriendlyName(pwd, friendlyName));
        }
        return super.getPrivateKeysByFriendlyName(pwd, friendlyName);
    }

    @Override
    public EncryptedPrivateKeyInfo[] getShroudedKeysByFriendlyName(char[] pwd, String friendlyName) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByFriendlyName", pwd, friendlyName);
            debug.exit(16384L, (Object)className, "getShroudedKeysByFriendlyName", super.getShroudedKeysByFriendlyName(pwd, friendlyName));
        }
        return super.getShroudedKeysByFriendlyName(pwd, friendlyName);
    }

    @Override
    public byte[][] getAllLocalKeyIds(char[] pwd) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getAllLocalKeyIds", (Object)pwd);
            debug.exit(16384L, (Object)className, "getAllLocalKeyIds", super.getAllLocalKeyIds(pwd));
        }
        return super.getAllLocalKeyIds(pwd);
    }

    @Override
    public Certificate[] getCertificatesByLocalKeyId(char[] pwd, byte[] localKeyId) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getCertificatesByLocalKeyId", pwd, localKeyId);
            debug.exit(16384L, (Object)className, "getCertificatesByLocalKeyId", super.getCertificatesByLocalKeyId(pwd, localKeyId));
        }
        return super.getCertificatesByLocalKeyId(pwd, localKeyId);
    }

    @Override
    public EncryptedPrivateKeyInfo[] getShroudedKeysByLocalKeyId(char[] pwd, byte[] localKeyId) throws PKCSException {
        if (debug != null) {
            debug.entry(16384L, className, "getShroudedKeysByLocalKeyId", pwd, localKeyId);
            debug.exit(16384L, (Object)className, "getShroudedKeysByLocalKeyId", super.getShroudedKeysByLocalKeyId(pwd, localKeyId));
        }
        return super.getShroudedKeysByLocalKeyId(pwd, localKeyId);
    }

    @Override
    public byte[] getLocalKeyIdOfShroudedKey(EncryptedPrivateKeyInfo shroudedKey, char[] pwd) throws PKCSException, IOException {
        return super.getLocalKeyIdOfShroudedKey(shroudedKey, pwd);
    }

    @Override
    public byte[] getLocalKeyIdOfPrivateKey(PrivateKeyInfo privateKey, char[] pwd) throws PKCSException, IOException {
        return super.getLocalKeyIdOfPrivateKey(privateKey, pwd);
    }

    @Override
    public String getFriendlyNameOfShroudedKey(EncryptedPrivateKeyInfo shroudedKey, char[] pwd) throws PKCSException, IOException {
        return super.getFriendlyNameOfShroudedKey(shroudedKey, pwd);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        super.encode(out);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "equals", other);
            debug.exit(16384L, (Object)className, "equals", super.equals(other));
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
            debug.exit(16384L, (Object)className, "toString", super.toString());
        }
        return super.toString();
    }

    @Override
    public boolean verifyMac(char[] pwd) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "verifyMac", (Object)pwd);
            debug.exit(16384L, (Object)className, "verifyMac", super.verifyMac(pwd));
        }
        return super.verifyMac(pwd);
    }

    @Override
    public MacData getMacData() {
        if (debug != null) {
            debug.entry(16384L, className, "getMacData");
            debug.exit(16384L, (Object)className, "getMacData", super.getMacData());
        }
        return super.getMacData();
    }

    @Override
    protected void decode(DerValue der) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", der);
        }
        super.decode(der);
        if (debug != null) {
            debug.exit(16384L, className, "decode");
        }
    }

    private synchronized void addInfo(Bag bag, String name, byte[] key) throws PKCSException {
        SafeBag sbag;
        if (debug != null) {
            Object[] parms = new Object[]{bag, name, key};
            debug.entry(16384L, (Object)className, "addInfo", parms);
        }
        try {
            PKCSAttribute attr = new PKCSAttribute(PKCSOID.LOCAL_KEY_ID_OID, key, this.provider);
            PKCSAttribute[] inAttrs = new PKCSAttribute[]{attr};
            PKCSAttributes attrs = new PKCSAttributes(inAttrs, this.provider);
            if (name != null && name.length() != 0) {
                attrs = attrs.addAttribute(new PKCSAttribute(PKCSOID.FRIENDLY_NAME_OID, name, this.provider));
            }
            sbag = new SafeBag(bag, attrs, this.provider);
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(16384L, className, "addInfo", e);
            }
            throw new PKCSException(e, "Unable to add private information (" + e.toString() + ")");
        }
        this.unprotectedBags.add(sbag);
        if (debug != null) {
            debug.exit(16384L, className, "addInfo");
        }
    }

    @Override
    ContentInfo protectWithPasswordPrivacy(byte[] contents, String digestAlg, String cipherAlg, char[] pwd) throws IOException, PKCSException, NoSuchAlgorithmException {
        AlgorithmId algid;
        AlgorithmId tmpAlgId;
        byte[] encryptedContents;
        AlgorithmParameters params = null;
        if (debug != null) {
            Object[] parms = new Object[]{contents, digestAlg, cipherAlg, pwd};
            debug.entry(16384L, (Object)className, "protectWithPasswordPrivacy", parms);
        }
        if (this.cipher == null) {
            SecretKey key;
            String cipherName = "PBEWith" + digestAlg + "And" + cipherAlg;
            PBEKeySpec keySpec = new PBEKeySpec(pwd);
            try {
                SecretKeyFactory keyFact = this.provider != null ? SecretKeyFactory.getInstance("PBEWithSha1AndRC2", this.provider) : SecretKeyFactory.getInstance("PBEWithSha1AndRC2");
                key = keyFact.generateSecret(keySpec);
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", e2);
                }
                throw new PKCSException(e2, "Unable to encrypt bag contents (" + e2.toString() + ")");
            }
            int saltLen = 8;
            String alg = cipherAlg.toUpperCase(Locale.US);
            if (alg.indexOf("DES") != -1) {
                saltLen = 20;
            }
            byte[] salt = new byte[saltLen];
            SecureRandom random = null;
            try {
                random = this.provider != null ? SecureRandom.getInstance("IBMSecureRandom", this.provider) : SecureRandom.getInstance("IBMSecureRandom");
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", nsae);
                }
                random = new SecureRandom();
            }
            catch (NoSuchProviderException nspe) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", nspe);
                }
                throw new PKCSException(nspe, "Provider " + this.provider + " not found");
            }
            random.nextBytes(salt);
            int iCount = 1;
            PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iCount);
            try {
                params = this.provider != null ? AlgorithmParameters.getInstance("PBE", this.provider) : AlgorithmParameters.getInstance("PBE");
                params.init(paramSpec);
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", e2);
                }
                throw new PKCSException(e2, "Unable to encrypt bag contents (" + e2.toString() + ")");
            }
            try {
                this.cipher = this.provider != null ? Cipher.getInstance(cipherName, this.provider) : Cipher.getInstance(cipherName);
                this.cipher.init(1, (Key)key, params);
            }
            catch (Exception e2) {
                if (debug != null) {
                    debug.exception(16384L, className, "protectWithPasswordPrivacy", e2);
                }
                throw new PKCSException(e2, "Unable to encrypt bag contents (" + e2.toString() + ")");
            }
        }
        try {
            encryptedContents = this.cipher.doFinal(contents);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", e);
            }
            throw new PKCSException(e, "Unable to encrypt bag contents (" + e.toString() + ")");
        }
        AlgorithmParameters cipherParams = this.cipher.getParameters();
        byte[] encodedParms = null;
        if (cipherParams != null) {
            encodedParms = cipherParams.getEncoded();
        }
        try {
            tmpAlgId = AlgorithmId.get(this.cipher.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "protectWithPasswordPrivacy", e);
            }
            throw new PKCSException(e, "Unsupported password-based encryption algorithm: " + this.cipher.getAlgorithm());
        }
        if (encodedParms != null) {
            ObjectIdentifier oid = tmpAlgId.getOID();
            algid = new AlgorithmId(oid, encodedParms, this.provider);
        } else {
            algid = tmpAlgId;
        }
        EncryptedContentInfo eci = new EncryptedContentInfo(PKCSOID.DATA_OID, algid, encryptedContents, this.provider);
        EncryptedData encryptedData = new EncryptedData(eci, null, this.provider);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "protectWithPasswordPrivacy", new ContentInfo(encryptedData, this.provider));
        }
        return new ContentInfo(encryptedData, this.provider);
    }

    private void setSavedPassword(char[] chars) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "setSavedPassword", (Object)chars);
        }
        this.savedPasswd = new SmudgedChars(chars, this.provider);
        if (debug != null) {
            debug.exit(8192L, className, "setSavedPassword");
        }
    }

    private char[] getSavedPassword() {
        if (debug != null) {
            debug.entry(8192L, className, "getSavedPassword");
        }
        if (this.savedPasswd == null) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "getSavedPassword_1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "getSavedPassword_2", this.savedPasswd.getClearText());
        }
        return this.savedPasswd.getClearText();
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(16384L, className, "finalize");
            debug.exit(16384L, className, "finalize");
        }
        this.savedPasswd = null;
    }
}

