/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AttributeNameEnumeration;
import com.ibm.security.x509.CertAttrSet;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.PKIXExtensions;
import com.ibm.security.x509.SerialNumber;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;

public final class AuthorityKeyIdentifierExtension
extends Extension
implements CertAttrSet<String> {
    public static final String IDENT = "x509.info.extensions.AuthorityKeyIdentifier";
    public static final String NAME = "AuthorityKeyIdentifier";
    public static final String KEY_ID = "key_id";
    public static final String AUTH_NAME = "auth_name";
    public static final String SERIAL_NUMBER = "serial_number";
    private static final byte TAG_ID = 0;
    private static final byte TAG_NAMES = 1;
    private static final byte TAG_SERIAL_NUM = 2;
    private KeyIdentifier id = null;
    private GeneralNames names = null;
    private SerialNumber serialNum = null;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.AuthorityKeyIdentifierExtension";

    private void encodeThis() throws IOException {
        DerOutputStream tmp1;
        if (debug != null) {
            debug.entry(8192L, className, "encodeThis");
        }
        if (this.id == null && this.names == null && this.serialNum == null) {
            this.extensionValue = null;
            if (debug != null) {
                debug.exit(8192L, className, "encodeThis_1");
            }
            return;
        }
        DerOutputStream seq = new DerOutputStream();
        DerOutputStream tmp = new DerOutputStream();
        if (this.id != null) {
            tmp1 = new DerOutputStream();
            this.id.encode(tmp1);
            tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp1);
        }
        try {
            if (this.names != null) {
                tmp1 = new DerOutputStream();
                this.names.encode(tmp1);
                tmp.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), tmp1);
            }
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(8192L, className, "encodeThis", e);
            }
            throw new IOException(e.toString());
        }
        if (this.serialNum != null) {
            tmp1 = new DerOutputStream();
            this.serialNum.encode(tmp1);
            tmp.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), tmp1);
        }
        seq.write((byte)48, tmp);
        this.extensionValue = seq.toByteArray();
        if (debug != null) {
            debug.exit(8192L, className, "encodeThis_2");
        }
    }

    public AuthorityKeyIdentifierExtension(KeyIdentifier kid, GeneralNames name, SerialNumber sn) throws IOException {
        if (debug != null) {
            Object[] parms = new Object[]{kid, name, sn};
            debug.entry(16384L, (Object)className, "AuthorityKeyIdentifierExtension", parms);
        }
        this.id = kid;
        this.names = name != null ? (GeneralNames)name.clone() : name;
        this.serialNum = sn;
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = false;
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityKeyIdentifierExtension");
        }
    }

    public AuthorityKeyIdentifierExtension(Boolean critical, Object value) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "AuthorityKeyIdentifierExtension", critical, value);
        }
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = false;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Invalid encoding for AuthorityKeyIdentifierExtension.");
            }
            throw new IOException("Invalid encoding for AuthorityKeyIdentifierExtension.");
        }
        while (val.getData() != null && val.getData().available() != 0) {
            DerValue opt = val.getData().getDerValue();
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                if (this.id != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Duplicate KeyIdentifier in AuthorityKeyIdentifier.");
                    }
                    throw new IOException("Duplicate KeyIdentifier in AuthorityKeyIdentifier.");
                }
                opt.resetTag((byte)4);
                this.id = new KeyIdentifier(opt);
                continue;
            }
            if (opt.isContextSpecific((byte)1) && opt.isConstructed()) {
                if (this.names != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Duplicate GeneralNames in AuthorityKeyIdentifier.");
                    }
                    throw new IOException("Duplicate GeneralNames in AuthorityKeyIdentifier.");
                }
                try {
                    opt.resetTag((byte)48);
                    this.names = new GeneralNames(opt);
                    continue;
                }
                catch (GeneralNamesException e) {
                    if (debug != null) {
                        debug.exception(16384L, className, "AuthorityKeyIdentifierExtension", e);
                    }
                    throw new IOException(e.toString());
                }
            }
            if (opt.isContextSpecific((byte)2) && !opt.isConstructed()) {
                if (this.serialNum != null) {
                    if (debug != null) {
                        debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Duplicate SerialNumber in AuthorityKeyIdentifier.");
                    }
                    throw new IOException("Duplicate SerialNumber in AuthorityKeyIdentifier.");
                }
                opt.resetTag((byte)2);
                this.serialNum = new SerialNumber(opt);
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "AuthorityKeyIdentifierExtension", "Invalid encoding of AuthorityKeyIdentifierExtension.");
            }
            throw new IOException("Invalid encoding of AuthorityKeyIdentifierExtension.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "AuthorityKeyIdentifierExtension");
        }
    }

    @Override
    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = super.toString() + "AuthorityKeyIdentifier [\n";
        if (this.id != null) {
            s = s + this.id.toString();
        }
        if (this.names != null) {
            s = s + this.names.toString() + "\n";
        }
        if (this.serialNum != null) {
            s = s + this.serialNum.toString() + "\n";
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s + "]\n");
        }
        return s + "]\n";
    }

    @Override
    public void decode(InputStream in) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "decode", in);
            debug.text(16384L, className, "decode", "Method not to be called directly.");
        }
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.AuthorityKey_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (debug != null) {
            debug.entry(16384L, className, "set", name, obj);
        }
        if (name.equalsIgnoreCase(KEY_ID)) {
            if (!(obj instanceof KeyIdentifier)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type KeyIdentifier.");
                }
                throw new IOException("Attribute value should be of type KeyIdentifier.");
            }
            this.id = (KeyIdentifier)obj;
        } else if (name.equalsIgnoreCase(AUTH_NAME)) {
            if (!(obj instanceof GeneralNames)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type GeneralNames.");
                }
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = (GeneralNames)((GeneralNames)obj).clone();
        } else if (name.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (!(obj instanceof SerialNumber)) {
                if (debug != null) {
                    debug.text(16384L, className, "set", "Attribute value should be of type SerialNumber.");
                }
                throw new IOException("Attribute value should be of type SerialNumber.");
            }
            this.serialNum = (SerialNumber)obj;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "set", "Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "set");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "get", name);
        }
        if (name.equalsIgnoreCase(KEY_ID)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_1", this.id);
            }
            return this.id;
        }
        if (name.equalsIgnoreCase(AUTH_NAME)) {
            if (this.names != null) {
                if (debug != null) {
                    debug.exit(16384L, (Object)className, "get_2", this.names.clone());
                }
                return this.names.clone();
            }
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_3", this.names);
            }
            return this.names;
        }
        if (name.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (debug != null) {
                debug.exit(16384L, (Object)className, "get_4", this.serialNum);
            }
            return this.serialNum;
        }
        if (debug != null) {
            debug.text(16384L, className, "get", "Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "delete", name);
        }
        if (name.equalsIgnoreCase(KEY_ID)) {
            this.id = null;
        } else if (name.equalsIgnoreCase(AUTH_NAME)) {
            this.names = null;
        } else if (name.equalsIgnoreCase(SERIAL_NUMBER)) {
            this.serialNum = null;
        } else {
            if (debug != null) {
                debug.text(16384L, className, "delete", "Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
            }
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
        if (debug != null) {
            debug.exit(16384L, className, "delete");
        }
    }

    @Override
    public Enumeration<String> getElements() {
        AttributeNameEnumeration elements = new AttributeNameEnumeration();
        if (debug != null) {
            debug.entry(16384L, className, "getElements");
        }
        elements.addElement(KEY_ID);
        elements.addElement(AUTH_NAME);
        elements.addElement(SERIAL_NUMBER);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getElements", elements.elements());
        }
        return elements.elements();
    }

    @Override
    public String getName() {
        if (debug != null) {
            debug.entry(16384L, className, "getName");
            debug.exit(16384L, (Object)className, "getName", NAME);
        }
        return NAME;
    }
}

