/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.GeneralName;
import java.io.IOException;
import java.math.BigInteger;

public final class GeneralSubtree {
    private static final byte TAG_MIN = 0;
    private static final byte TAG_MAX = 1;
    private static final int MIN_DEFAULT = 0;
    private GeneralName name;
    private int minimum = 0;
    private int maximum = -1;
    private int myhash = -1;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.GeneralSubtree";

    public GeneralSubtree(GeneralName name, int min, int max) {
        if (debug != null) {
            Object[] parms = new Object[]{name, new Integer(min), new Integer(max)};
            debug.entry(16384L, (Object)className, "GeneralSubtree", parms);
        }
        this.name = name;
        this.minimum = min;
        this.maximum = max;
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtree");
        }
    }

    public GeneralSubtree(DerValue val) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSubtree", val);
        }
        if (val.getTag() != 48) {
            if (debug != null) {
                debug.text(16384L, className, "GeneralSubtree", "Invalid encoding for GeneralSubtree.");
            }
            throw new IOException("Invalid encoding for GeneralSubtree.");
        }
        this.name = new GeneralName(val.getData().getDerValue(), true);
        while (val.getData().available() != 0) {
            DerValue opt = val.getData().getDerValue();
            if (opt.isContextSpecific((byte)0) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.minimum = opt.getInteger().intValue();
                continue;
            }
            if (opt.isContextSpecific((byte)1) && !opt.isConstructed()) {
                opt.resetTag((byte)2);
                this.maximum = opt.getInteger().intValue();
                continue;
            }
            if (debug != null) {
                debug.text(16384L, className, "GeneralSubtree", "Invalid encoding of GeneralSubtree.");
            }
            throw new IOException("Invalid encoding of GeneralSubtree.");
        }
        if (debug != null) {
            debug.exit(16384L, className, "GeneralSubtree");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(16384L, className, "toString");
        }
        String s = "\n   GeneralSubtree: [\n    GeneralName: " + (this.name == null ? "" : this.name.toString()) + "\n    Minimum: " + this.minimum;
        s = this.maximum == -1 ? s + "\t    Maximum: undefined" : s + "\t    Maximum: " + this.maximum;
        s = s + "    ]\n";
        if (debug != null) {
            debug.exit(16384L, (Object)className, "toString", s);
        }
        return s;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GeneralSubtree)) {
            return false;
        }
        GeneralSubtree otherGS = (GeneralSubtree)other;
        if (this.name == null ? otherGS.name != null : !this.name.equals(otherGS.name)) {
            return false;
        }
        if (this.minimum != otherGS.minimum) {
            return false;
        }
        return this.maximum == otherGS.maximum;
    }

    public int hashCode() {
        if (this.myhash == -1) {
            this.myhash = 17;
            if (this.name != null) {
                this.myhash = 37 * this.myhash + this.name.hashCode();
            }
            if (this.minimum != 0) {
                this.myhash = 37 * this.myhash + this.minimum;
            }
            if (this.maximum != -1) {
                this.myhash = 37 * this.myhash + this.maximum;
            }
        }
        return this.myhash;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "encode", out);
        }
        DerOutputStream seq = new DerOutputStream();
        this.name.encode(seq);
        if (this.minimum != 0) {
            tmp = new DerOutputStream();
            tmp.putInteger(BigInteger.valueOf(this.minimum));
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp);
        }
        if (this.maximum != -1) {
            tmp = new DerOutputStream();
            tmp.putInteger(BigInteger.valueOf(this.maximum));
            seq.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
        }
        out.write((byte)48, seq);
        if (debug != null) {
            debug.exit(16384L, className, "encode");
        }
    }

    public GeneralName getBase() {
        if (debug != null) {
            debug.entry(16384L, className, "getBase");
            debug.exit(16384L, (Object)className, "getBase", this.name);
        }
        return this.name;
    }

    public int getMinimum() {
        if (debug != null) {
            debug.entry(16384L, className, "getMinimum");
            debug.exit(16384L, (Object)className, "getMinimum", this.minimum);
        }
        return this.minimum;
    }

    public int getMaximum() {
        if (debug != null) {
            debug.entry(16384L, className, "getMaximum");
            debug.exit(16384L, (Object)className, "getMaximum", this.maximum);
        }
        return this.maximum;
    }
}

