/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.ObjectIdentifier;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public final class OIDMap {
    private static final String ROOT = "x509.info.extensions";
    private static final String AUTH_KEY_IDENTIFIER = "x509.info.extensions.AuthorityKeyIdentifier";
    private static final String SUB_KEY_IDENTIFIER = "x509.info.extensions.SubjectKeyIdentifier";
    private static final String KEY_USAGE = "x509.info.extensions.KeyUsage";
    private static final String PRIVATE_KEY_USAGE = "x509.info.extensions.PrivateKeyUsage";
    private static final String POLICY_MAPPINGS = "x509.info.extensions.PolicyMappings";
    private static final String SUB_ALT_NAME = "x509.info.extensions.SubjectAlternativeName";
    private static final String ISSUER_ALT_NAME = "x509.info.extensions.IssuerAlternativeName";
    private static final String BASIC_CONSTRAINTS = "x509.info.extensions.BasicConstraints";
    private static final String NAME_CONSTRAINTS = "x509.info.extensions.NameConstraints";
    private static final String POLICY_CONSTRAINTS = "x509.info.extensions.PolicyConstraints";
    private static final String CRL_NUMBER = "x509.info.extensions.CRLNumber";
    private static final String CRL_REASON = "x509.info.extensions.CRLReasonCode";
    private static final String CRL_DISTRIBUTION_POINTS = "x509.info.extensions.CRLDistributionPoints";
    private static final String ISSUING_DISTRIBUTION_POINT = "x509.info.extensions.IssuingDistributionPoint";
    private static final String NETSCAPE_CERT = "x509.info.extensions.NetscapeCertType";
    private static final String DELTA_CRL_INDICATOR = "x509.info.extensions.DeltaCRLIndicator";
    private static final String HOLD_INSTRUCTION_CODE = "x509.info.extensions.HoldInstructionCode";
    private static final String INVALIDITY_DATE = "x509.info.extensions.InvalidityDate";
    private static final String CERTIFICATE_ISSUER = "x509.info.extensions.CertificateIssuer";
    private static final String SUBJECT_INFO_ACCESS = "x509.info.extensions.SubjectInfoAccess";
    private static final String SUBJECT_DIRECTORY_ATTRIBUTES = "x509.info.extensions.SubjectDirectoryAttributes";
    private static final String CERTIFICATE_POLICIES = "x509.info.extensions.CertificatePolicies";
    private static final String EXT_KEY_USAGE = "x509.info.extensions.ExtKeyUsage";
    private static final String INHIBIT_ANY_POLICY = "x509.info.extensions.InhibitAnyPolicy";
    private static final String AUTHORITY_INFO_ACCESS = "x509.info.extensions.AuthorityInfoAccess";
    private static final String FRESHEST_CRL = "x509.info.extensions.FreshestCRL";
    private static final Hashtable oid2Name = new Hashtable(15);
    private static final Hashtable name2OID = new Hashtable(15);
    private static final Hashtable name2Class = new Hashtable(15);
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.OIDMap";

    private static void loadNamesDefault(Properties props) {
        if (debug != null) {
            debug.entry(40960L, (Object)className, "loadNamesDefault", props);
        }
        props.put(SUBJECT_DIRECTORY_ATTRIBUTES, "2.5.29.9");
        props.put(SUB_KEY_IDENTIFIER, "2.5.29.14");
        props.put(KEY_USAGE, "2.5.29.15");
        props.put(PRIVATE_KEY_USAGE, "2.5.29.16");
        props.put(SUB_ALT_NAME, "2.5.29.17");
        props.put(ISSUER_ALT_NAME, "2.5.29.18");
        props.put(BASIC_CONSTRAINTS, "2.5.29.19");
        props.put(CRL_NUMBER, "2.5.29.20");
        props.put(CRL_REASON, "2.5.29.21");
        props.put(HOLD_INSTRUCTION_CODE, "2.5.29.23");
        props.put(INVALIDITY_DATE, "2.5.29.24");
        props.put(DELTA_CRL_INDICATOR, "2.5.29.27");
        props.put(ISSUING_DISTRIBUTION_POINT, "2.5.29.28");
        props.put(CERTIFICATE_ISSUER, "2.5.29.29");
        props.put(NAME_CONSTRAINTS, "2.5.29.30");
        props.put(CRL_DISTRIBUTION_POINTS, "2.5.29.31");
        props.put(CERTIFICATE_POLICIES, "2.5.29.32");
        props.put(POLICY_MAPPINGS, "2.5.29.33");
        props.put(AUTH_KEY_IDENTIFIER, "2.5.29.35");
        props.put(POLICY_CONSTRAINTS, "2.5.29.36");
        props.put(EXT_KEY_USAGE, "2.5.29.37");
        props.put(INHIBIT_ANY_POLICY, "2.5.29.54");
        props.put(NETSCAPE_CERT, "2.16.840.1.113730.1.1");
        props.put(AUTHORITY_INFO_ACCESS, "1.3.6.1.5.5.7.1.1");
        props.put(FRESHEST_CRL, "2.5.29.46");
        if (debug != null) {
            debug.exit(8192L, className, "loadNamesDefault");
        }
    }

    private static void loadClassDefault(Properties props) {
        if (debug != null) {
            debug.entry(40960L, (Object)className, "loadClassDefault", props);
        }
        props.put(AUTH_KEY_IDENTIFIER, "com.ibm.security.x509.AuthorityKeyIdentifierExtension");
        props.put(SUB_KEY_IDENTIFIER, "com.ibm.security.x509.SubjectKeyIdentifierExtension");
        props.put(KEY_USAGE, "com.ibm.security.x509.KeyUsageExtension");
        props.put(PRIVATE_KEY_USAGE, "com.ibm.security.x509.PrivateKeyUsageExtension");
        props.put(POLICY_MAPPINGS, "com.ibm.security.x509.PolicyMappingsExtension");
        props.put(SUB_ALT_NAME, "com.ibm.security.x509.SubjectAlternativeNameExtension");
        props.put(ISSUER_ALT_NAME, "com.ibm.security.x509.IssuerAlternativeNameExtension");
        props.put(BASIC_CONSTRAINTS, "com.ibm.security.x509.BasicConstraintsExtension");
        props.put(NAME_CONSTRAINTS, "com.ibm.security.x509.NameConstraintsExtension");
        props.put(POLICY_CONSTRAINTS, "com.ibm.security.x509.PolicyConstraintsExtension");
        props.put(CRL_NUMBER, "com.ibm.security.x509.CRLNumberExtension");
        props.put(CRL_REASON, "com.ibm.security.x509.CRLReasonCodeExtension");
        props.put(CRL_DISTRIBUTION_POINTS, "com.ibm.security.x509.CRLDistributionPointsExtension");
        props.put(ISSUING_DISTRIBUTION_POINT, "com.ibm.security.x509.IssuingDistributionPointExtension");
        props.put(NETSCAPE_CERT, "com.ibm.security.x509.NetscapeCertTypeExtension");
        props.put(DELTA_CRL_INDICATOR, "com.ibm.security.x509.DeltaCRLIndicatorExtension");
        props.put(HOLD_INSTRUCTION_CODE, "com.ibm.security.x509.HoldInstructionCodeExtension");
        props.put(INVALIDITY_DATE, "com.ibm.security.x509.InvalidityDateExtension");
        props.put(CERTIFICATE_ISSUER, "com.ibm.security.x509.CertificateIssuerExtension");
        props.put(SUBJECT_DIRECTORY_ATTRIBUTES, "com.ibm.security.x509.SubjectDirectoryAttributesExtension");
        props.put(CERTIFICATE_POLICIES, "com.ibm.security.x509.CertificatePoliciesExtension");
        props.put(EXT_KEY_USAGE, "com.ibm.security.x509.ExtKeyUsageExtension");
        props.put(SUBJECT_INFO_ACCESS, "com.ibm.security.x509.SubjectInfoAccessExtension");
        props.put(INHIBIT_ANY_POLICY, "com.ibm.security.x509.InhibitAnyPolicyExtension");
        props.put(AUTHORITY_INFO_ACCESS, "com.ibm.security.x509.AuthorityInfoAccessExtension");
        props.put(FRESHEST_CRL, "com.ibm.security.x509.FreshestCRLExtension");
        if (debug != null) {
            debug.exit(40960L, className, "loadClassDefault");
        }
    }

    private static void loadNames() {
        if (debug != null) {
            debug.entry(40960L, className, "loadNames");
        }
        Properties props = new Properties();
        OIDMap.loadNamesDefault(props);
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String oidName = props.getProperty(name);
            ObjectIdentifier oid = null;
            try {
                oid = new ObjectIdentifier(oidName);
            }
            catch (Exception e) {
                oid = null;
            }
            name2OID.put(name, oid);
            oid2Name.put(oid, name);
        }
        if (debug != null) {
            debug.exit(40960L, className, "loadNames");
        }
    }

    private static void loadClasses() {
        if (debug != null) {
            debug.entry(40960L, className, "loadClasses");
        }
        Properties props = new Properties();
        OIDMap.loadClassDefault(props);
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String className = props.getProperty(name);
            name2Class.put(name, className);
        }
        if (debug != null) {
            debug.exit(40960L, className, "loadClasses");
        }
    }

    public static void addAttribute(String className, String oid, String name) throws CertificateException {
        if (debug != null) {
            Object[] parms = new Object[]{className, oid, name};
            debug.entry(49152L, (Object)className, "addAttribute", parms);
        }
        ObjectIdentifier objId = null;
        try {
            objId = new ObjectIdentifier(oid);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (oid2Name.get(objId) != null) {
            if (debug != null) {
                debug.text(49152L, className, "addAttribute", "Object identifier already exists");
            }
            throw new CertificateException("Object identifier already exists");
        }
        if (name2OID.get(name) != null) {
            if (debug != null) {
                debug.text(49152L, className, "addAttribute", "Name already exists");
            }
            throw new CertificateException("Name already exists");
        }
        if (name2Class.get(className) != null) {
            if (debug != null) {
                debug.text(49152L, className, "addAttribute", "Class already exists");
            }
            throw new CertificateException("Class already exists");
        }
        oid2Name.put(objId, name);
        name2OID.put(name, objId);
        name2Class.put(name, className);
        if (debug != null) {
            debug.exit(49152L, className, "addAttribute");
        }
    }

    public static String getName(ObjectIdentifier oid) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getName", oid);
            debug.exit(16384L, (Object)className, "getName", (String)oid2Name.get(oid));
        }
        return (String)oid2Name.get(oid);
    }

    public static ObjectIdentifier getOID(String name) {
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getOID", name);
            debug.exit(49152L, (Object)className, "getOID", (ObjectIdentifier)name2OID.get(name));
        }
        return (ObjectIdentifier)name2OID.get(name);
    }

    public static Class getClass(String name) throws CertificateException {
        String className;
        if (debug != null) {
            debug.entry(49152L, (Object)OIDMap.className, "getClass", name);
        }
        if ((className = (String)name2Class.get(name)) == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getClass_1", null);
            }
            return null;
        }
        try {
            Class<?> extClass = Class.forName(className);
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getClass_2", extClass);
            }
            return extClass;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(49152L, className, "getClass", e);
            }
            throw new CertificateException("Error instantiating class for " + name + " " + e.toString());
        }
    }

    public static Class getClass(ObjectIdentifier oid) throws CertificateException {
        String name;
        if (debug != null) {
            debug.entry(49152L, (Object)className, "getClass", oid);
        }
        if ((name = OIDMap.getName(oid)) == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getClass_1", null);
            }
            return null;
        }
        String className = (String)name2Class.get(name);
        if (className == null) {
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getClass_2", null);
            }
            return null;
        }
        try {
            Class<?> extClass = Class.forName(className);
            if (debug != null) {
                debug.exit(49152L, (Object)className, "getClass_3", extClass);
            }
            return extClass;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(49152L, className, "getClass", e);
            }
            throw new CertificateException("Error instantiating class for " + name + " " + e.toString());
        }
    }

    static {
        OIDMap.loadNames();
        OIDMap.loadClasses();
    }
}

