/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X500Name;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.Signer;
import java.security.spec.AlgorithmParameterSpec;

class X500Signer
extends Signer {
    static final long serialVersionUID = -7949587785526204490L;
    private Signature sig;
    private X500Name agent;
    private AlgorithmId algid;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static String className = "com.ibm.security.x509.X500Signer";

    public void update(byte[] buf, int offset, int len) throws SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset), new Integer(len)};
            debug.entry(16384L, (Object)className, "update", parms);
        }
        this.sig.update(buf, offset, len);
        if (debug != null) {
            debug.exit(16384L, className, "update");
        }
    }

    public byte[] sign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, className, "sign");
        }
        byte[] result = this.sig.sign();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "sign", result);
        }
        return result;
    }

    public AlgorithmId getAlgorithmId() {
        if (debug != null) {
            debug.entry(16384L, className, "getAlgorithmId");
            debug.exit(16384L, (Object)className, "getAlgorithmId", this.algid);
        }
        return this.algid;
    }

    public X500Name getSigner() {
        if (debug != null) {
            debug.entry(16384L, className, "getSigner");
            debug.exit(16384L, (Object)className, "getSigner", this.agent);
        }
        return this.agent;
    }

    public X500Signer(Signature sig, X500Name agent, AlgorithmParameterSpec sigParameterSpec) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "X500Signer", new Object[]{sig, agent, sigParameterSpec});
        }
        if (sig == null || agent == null) {
            if (debug != null) {
                debug.text(16384L, className, "X500Signer", "null parameter");
            }
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = sig;
        this.agent = agent;
        try {
            this.algid = AlgorithmId.get(sig.getParameters());
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "X500Signer", e);
                debug.text(16384L, className, "X500Signer", "internal error! " + e.getMessage());
            }
            throw new RuntimeException("internal error! " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X500Signer");
        }
    }

    public X500Signer(Signature sig, X500Name agent) {
        if (debug != null) {
            debug.entry(16384L, className, "X500Signer", sig, agent);
        }
        if (sig == null || agent == null) {
            if (debug != null) {
                debug.text(16384L, className, "X500Signer", "null parameter");
            }
            throw new IllegalArgumentException("null parameter");
        }
        this.sig = sig;
        this.agent = agent;
        try {
            this.algid = AlgorithmId.getAlgorithmId(sig.getAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(16384L, className, "X500Signer", e);
                debug.text(16384L, className, "X500Signer", "internal error! " + e.getMessage());
            }
            throw new RuntimeException("internal error! " + e.getMessage());
        }
        if (debug != null) {
            debug.exit(16384L, className, "X500Signer");
        }
    }
}

