/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview;

import com.ibm.jvm.dtfjview.ConsoleOutputChannel;
import com.ibm.jvm.dtfjview.FileOutputChannel;
import com.ibm.jvm.dtfjview.JdmpviewPrintStream;
import com.ibm.jvm.dtfjview.spi.IOutputChannel;
import com.ibm.jvm.dtfjview.spi.IOutputManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Output
extends OutputStream
implements IOutputManager {
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private PrintStream internalStream = new PrintStream(this.bos);
    private boolean isBufferingEnabled = false;
    Vector outputChannels = new Vector();
    long lastTimestamp = 0L;
    String lastPrompt = "";
    String lastInput = "";

    @Override
    public void clearBuffer() {
        this.bos.reset();
    }

    @Override
    public void setBuffering(boolean enabled) {
        this.isBufferingEnabled = enabled;
    }

    @Override
    public String getBuffer() {
        return this.bos.toString();
    }

    @Override
    public void print(String outputString) {
        if (this.isBufferingEnabled) {
            this.internalStream.print(outputString);
        } else {
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                ((IOutputChannel)this.outputChannels.elementAt(i)).print(outputString);
            }
        }
    }

    @Override
    public void printPrompt(String prompt) {
        if (this.isBufferingEnabled) {
            this.internalStream.print(prompt);
        } else {
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                ((IOutputChannel)this.outputChannels.elementAt(i)).printPrompt(prompt);
            }
        }
    }

    @Override
    public void println(String outputString) {
        if (this.isBufferingEnabled) {
            this.internalStream.println(outputString);
        } else {
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                ((IOutputChannel)this.outputChannels.elementAt(i)).println(outputString);
            }
        }
    }

    @Override
    public void addChannel(IOutputChannel channel) {
        this.addChannel(channel, false);
    }

    public void addChannel(IOutputChannel channel, boolean printLastInput) {
        this.outputChannels.add(channel);
    }

    @Override
    public void removeChannel(Class<?> type) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            IOutputChannel channel = (IOutputChannel)this.outputChannels.elementAt(i);
            if (!channel.getClass().isAssignableFrom(type)) continue;
            ((IOutputChannel)this.outputChannels.elementAt(i)).close();
            this.outputChannels.removeElementAt(i);
        }
    }

    @Override
    public void removeChannel(IOutputChannel channel) {
        this.outputChannels.remove(channel);
    }

    @Override
    public void removeAllChannels() {
        this.outputChannels.clear();
    }

    public void removeFileChannel() {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            if (!((IOutputChannel)this.outputChannels.elementAt(i) instanceof FileOutputChannel)) continue;
            ((IOutputChannel)this.outputChannels.elementAt(i)).close();
            this.outputChannels.removeElementAt(i);
        }
    }

    public void setConsoleNoPrint(boolean noPrint) {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            if (!((IOutputChannel)this.outputChannels.elementAt(i) instanceof ConsoleOutputChannel)) continue;
            ((ConsoleOutputChannel)this.outputChannels.elementAt(i)).setNoPrint(noPrint);
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.outputChannels.size(); ++i) {
            ((IOutputChannel)this.outputChannels.elementAt(i)).close();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        String msg = new String(b, off, len);
        this.print(msg);
    }

    @Override
    public void write(byte[] b) throws IOException {
        String msg = new String(b);
        this.print(msg);
    }

    @Override
    public void write(int b) throws IOException {
        char[] chars = new char[]{(char)b};
        String msg = new String(chars);
        this.print(msg);
    }

    @Override
    public void flush() {
    }

    @Override
    public PrintStream getPrintStream() {
        JdmpviewPrintStream stream = new JdmpviewPrintStream(this);
        return stream;
    }
}

