/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.FindCommand;
import java.io.PrintStream;

@DTFJPlugin(version="1.*", runtime=false)
public class FindNextCommand
extends BaseJdmpviewCommand {
    public FindNextCommand() {
        this.addCommand("findnext", "", "finds the next instance of the last string passed to \"find\"");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        FindCommand.FindAttribute findAtt = (FindCommand.FindAttribute)this.ctx.getProperties().get("FindAttributes");
        if (null == findAtt) {
            out.println("No find command has been executed.");
            return;
        }
        String startAddress = Long.toHexString(findAtt.lastMatch + 1L);
        String endAddress = Long.toHexString(findAtt.endAddress);
        this.ctx.execute("find " + findAtt.pattern + "," + startAddress + "," + endAddress + "," + findAtt.boundary + "," + findAtt.numBytesToPrint + "," + findAtt.numMatchesToDisplay, out);
    }

    public void printDetailedHelp(PrintStream out) {
        out.println("finds the next instance of the last string passed to \"find\"\n\nparameters: none\n\nThe findnext command is used in conjunction with find or findptr command to continue searching for upcoming matches. It repeats the previous find or findptr command (depending on which command is most recently issued) starting from the last match.");
    }
}

