/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DTFJException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.heapdump.HeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.HeapDumpSettings;
import com.ibm.jvm.dtfjview.heapdump.LongListReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.ReferenceIterator;
import com.ibm.jvm.dtfjview.heapdump.classic.ClassicHeapDumpFormatter;
import com.ibm.jvm.dtfjview.heapdump.portable.PortableHeapDumpFormatter;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DTFJPlugin(version="1.*", runtime=false)
public class HeapdumpCommand
extends BaseJdmpviewCommand {
    public static final String COMMAND_NAME = "heapdump";
    public static final String DESCRIPTION = "generates a PHD or classic format heapdump";
    public static final String LONG_DESCRIPTION = "Parameters: [heapname+]\n\n\t[heapname+] - space-separated name of heap or heaps to dump. Use \"info heap\" to get the list of heap names. Default: all heaps are dumped.\n\nWrites a heapdump from the memory image.\nThe file name and format are controlled using the \"set heapdump\" command; the current settings can be displayed using \"show heapdump\".\n";
    private static final String PROTECTION_DOMAIN_FIELD_NAME = "protectionDomain";
    private static final Pattern J9_VERSION_PATTERN = Pattern.compile("(IBM J9 VM.*?\\))");
    private static final String[] PRIMITIVE_TYPES = new String[]{"boolean", "char", "float", "double", "byte", "short", "int", "long", "void"};
    private int _numberOfObjects = 0;
    private int _numberOfClasses = 0;
    private int _numberOfErrors = 0;
    private boolean _verbose = false;
    private boolean _is32BitHash;
    private long pdSkipCount;

    public HeapdumpCommand() {
        this.addCommand(COMMAND_NAME, "", DESCRIPTION);
        this.pdSkipCount = 0L;
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        this.doCommand(args);
    }

    public void doCommand(String[] args) {
        HashSet heapsToDump = new HashSet();
        this._numberOfObjects = 0;
        this._numberOfErrors = 0;
        this._numberOfClasses = 0;
        if (this.ctx.hasPropertyBeenSet("verbose.mode")) {
            this._verbose = true;
        }
        JavaRuntime runtime = this.ctx.getRuntime();
        while (runtime != null) {
            ImageAddressSpace addressSpace = null;
            try {
                addressSpace = runtime.getJavaVM().getAddressSpace();
            }
            catch (CorruptDataException e) {
                // empty catch block
            }
            if (addressSpace == null) {
                this.out.println("Couldn't get handle on address space");
                break;
            }
            if (!this.heapArgumentsAreValid(runtime, heapsToDump)) break;
            String version = this.getVersionString(runtime);
            this._is32BitHash = !version.contains("IBM J9 2.3") && !version.contains("IBM J9 2.4") && !version.contains("IBM J9 2.5");
            boolean is64Bit = addressSpace.getCurrentProcess().getPointerSize() == 64;
            String filename = HeapDumpSettings.getFileName(this.ctx.getProperties());
            boolean phdFormat = HeapDumpSettings.areHeapDumpsPHD(this.ctx.getProperties());
            try {
                if (HeapDumpSettings.multipleHeapsInMultipleFiles(this.ctx.getProperties())) {
                    this.dumpMultipleHeapsInSeparateFiles(runtime, version, is64Bit, phdFormat, filename, heapsToDump);
                } else {
                    this.dumpMultipleHeapsInOneFile(runtime, version, is64Bit, phdFormat, filename, heapsToDump);
                }
                if (this._numberOfErrors == 0) {
                    this.out.print("\nSuccessfully wrote " + this._numberOfObjects + " objects and " + this._numberOfClasses + " classes\n");
                } else {
                    this.out.print("\nWrote " + this._numberOfObjects + " objects and " + this._numberOfClasses + " classes and encountered " + this._numberOfErrors + " errors." + "\n");
                }
            }
            catch (IOException ex) {
                this.out.println("I/O error writing dump:\n");
                StringWriter writer = new StringWriter();
                ex.printStackTrace(new PrintWriter(writer));
                this.out.println(writer.toString());
            }
            runtime = null;
        }
    }

    private boolean heapArgumentsAreValid(JavaRuntime runtime, Set heapsToDump) {
        if (heapsToDump.size() == 0) {
            return true;
        }
        HashSet workingSet = new HashSet();
        workingSet.addAll(heapsToDump);
        Iterator heapIt = runtime.getHeaps();
        while (heapIt.hasNext()) {
            Object potential = heapIt.next();
            if (potential instanceof JavaHeap) {
                JavaHeap thisHeap = (JavaHeap)potential;
                workingSet.remove(thisHeap.getName());
                continue;
            }
            if (potential instanceof CorruptData) {
                this.reportError("Corrupt heap found. Address = " + ((CorruptData)potential).getAddress(), null);
                ++this._numberOfErrors;
                continue;
            }
            ++this._numberOfErrors;
            this.reportError("Unexpected type " + potential.getClass().getName() + " found in heap iterator", null);
        }
        if (workingSet.isEmpty()) {
            return true;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("These specified heaps do not exist:\n");
        Iterator nameIterator = workingSet.iterator();
        while (nameIterator.hasNext()) {
            buffer.append("\t\t" + nameIterator.next() + "\n");
        }
        buffer.append("\tUse \"info heap\" to see list of heap names");
        this.out.println(buffer.toString());
        return false;
    }

    private String getVersionString(JavaRuntime runtime) {
        try {
            String rawVersion = runtime.getVersion();
            Matcher matcher = J9_VERSION_PATTERN.matcher(rawVersion);
            if (matcher.find()) {
                String minimalVersion = matcher.group(1);
                return minimalVersion;
            }
            return rawVersion;
        }
        catch (CorruptDataException e) {
            ++this._numberOfErrors;
            this.out.println("Could not read version string from dump: data corrupted at " + e.getCorruptData().getAddress());
            return "*Corrupt*";
        }
    }

    private void dumpMultipleHeapsInOneFile(JavaRuntime runtime, String version, boolean is64Bit, boolean phdFormat, String filename, Set heapsToDump) throws IOException {
        Iterator heapIterator = runtime.getHeaps();
        HeapDumpFormatter formatter = this.getFormatter(filename, version, is64Bit, phdFormat);
        this.out.println("Writing " + (phdFormat ? "PHD" : "Classic") + " format heapdump into " + filename);
        while (heapIterator.hasNext()) {
            Object thisHeapObj = heapIterator.next();
            if (thisHeapObj instanceof CorruptData) {
                this.out.println("Corrupt heap data found at: " + ((CorruptData)thisHeapObj).getAddress());
                ++this._numberOfErrors;
                continue;
            }
            JavaHeap thisHeap = (JavaHeap)thisHeapObj;
            if (heapsToDump.size() > 0 && !heapsToDump.contains(thisHeap.getName())) continue;
            this.dumpHeap(formatter, thisHeap);
        }
        this.dumpClasses(formatter, runtime);
        formatter.close();
    }

    private void dumpMultipleHeapsInSeparateFiles(JavaRuntime runtime, String version, boolean is64Bit, boolean phdFormat, String baseFileName, Set heapsToDump) throws IOException {
        Iterator heapIterator = runtime.getHeaps();
        HeapDumpFormatter formatter = null;
        while (heapIterator.hasNext()) {
            Object thisHeapObj = heapIterator.next();
            if (thisHeapObj instanceof CorruptData) {
                this.out.println("Heap corrupted at: " + ((CorruptData)thisHeapObj).getAddress());
                ++this._numberOfErrors;
                continue;
            }
            JavaHeap thisHeap = (JavaHeap)thisHeapObj;
            if (formatter != null) {
                formatter.close();
            }
            if (heapsToDump.size() > 0 && !heapsToDump.contains(thisHeap.getName())) continue;
            String fileName = this.getFileNameForHeap(thisHeap, baseFileName);
            this.out.print("Writing " + (phdFormat ? "PHD" : "Classic") + " format heapdump for heap " + thisHeap.getName() + " into " + fileName + "\n");
            formatter = this.getFormatter(fileName, version, is64Bit, phdFormat);
            this.dumpClasses(formatter, runtime);
            this.dumpHeap(formatter, thisHeap);
        }
        if (formatter != null) {
            formatter.close();
        }
    }

    private void dumpClasses(HeapDumpFormatter formatter, JavaRuntime runtime) throws IOException {
        Iterator classLoaderIt = runtime.getJavaClassLoaders();
        int numberOfClasses = 0;
        while (classLoaderIt.hasNext()) {
            Object potential = classLoaderIt.next();
            if (potential instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("CorruptData found in classloader list at address: " + ((CorruptData)potential).getAddress(), null);
                continue;
            }
            JavaClassLoader thisClassLoader = (JavaClassLoader)potential;
            Iterator classesIt = thisClassLoader.getDefinedClasses();
            while (classesIt.hasNext()) {
                potential = classesIt.next();
                ++numberOfClasses;
                try {
                    if (potential instanceof CorruptData) {
                        ++this._numberOfErrors;
                        this.reportError("CorruptData found in class list for classloader " + Long.toHexString(thisClassLoader.getObject().getID().getAddress()) + " at address: " + ((CorruptData)potential).getAddress(), null);
                        continue;
                    }
                    JavaClass thisJavaClass = (JavaClass)potential;
                    JavaClass superClass = thisJavaClass.getSuperclass();
                    JavaObject classObject = thisJavaClass.getObject();
                    long instanceSize = thisJavaClass.isArray() ? 0L : thisJavaClass.getInstanceSize();
                    int hashcode = 0;
                    if (this._is32BitHash) {
                        try {
                            hashcode = classObject != null ? (int)classObject.getPersistentHashcode() : 0;
                        }
                        catch (DataUnavailable ex) {}
                    } else {
                        hashcode = classObject != null ? (int)classObject.getHashcode() : 0;
                    }
                    formatter.addClass(classObject.getID().getAddress(), thisJavaClass.getName(), superClass != null ? superClass.getID().getAddress() : 0L, classObject != null ? (int)classObject.getSize() : 0, instanceSize, hashcode, this.getClassReferences(thisJavaClass));
                }
                catch (DTFJException ex) {
                    ++this._numberOfErrors;
                    this.reportError(null, ex);
                }
            }
        }
        this._numberOfClasses = numberOfClasses;
        if (this.pdSkipCount > 0L && this._verbose) {
            this.out.println("Warning : The protection domain information was not available for " + this.pdSkipCount + " classes");
        }
    }

    private void dumpHeap(HeapDumpFormatter formatter, JavaHeap thisHeap) throws IOException {
        Iterator objectIterator = thisHeap.getObjects();
        while (objectIterator.hasNext()) {
            Object next = objectIterator.next();
            ++this._numberOfObjects;
            if (next instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("Corrupt object data found at " + ((CorruptData)next).getAddress() + " while walking heap " + thisHeap.getName(), null);
                continue;
            }
            try {
                JavaObject thisObject = (JavaObject)next;
                if (thisObject.getJavaClass().getName().equals("java/lang/Class")) continue;
                JavaClass thisClass = thisObject.getJavaClass();
                JavaObject thisClassObject = thisClass.getObject();
                int hashcode = 0;
                if (this._is32BitHash) {
                    try {
                        hashcode = (int)thisObject.getPersistentHashcode();
                    }
                    catch (DataUnavailable ex) {}
                } else {
                    try {
                        hashcode = (int)thisObject.getHashcode();
                    }
                    catch (DataUnavailable ex) {
                        ++this._numberOfErrors;
                        this.reportError("Failed to get hashcode for object: " + thisObject.getID(), ex);
                    }
                }
                if (thisObject.isArray()) {
                    if (HeapdumpCommand.isPrimitive(thisClass.getComponentType())) {
                        formatter.addPrimitiveArray(thisObject.getID().getAddress(), thisClassObject.getID().getAddress(), this.getPrimitiveTypeCode(thisClass.getComponentType()), thisObject.getSize(), hashcode, thisObject.getArraySize());
                        continue;
                    }
                    formatter.addObjectArray(thisObject.getID().getAddress(), thisClassObject.getID().getAddress(), thisClass.getName(), thisClass.getComponentType().getObject().getID().getAddress(), thisClass.getComponentType().getName(), thisObject.getSize(), thisObject.getArraySize(), hashcode, this.getObjectReferences(thisObject));
                    continue;
                }
                formatter.addObject(thisObject.getID().getAddress(), thisClassObject.getID().getAddress(), thisClass.getName(), (int)thisObject.getSize(), hashcode, this.getObjectReferences(thisObject));
            }
            catch (CorruptDataException ex) {
                ++this._numberOfErrors;
                this.reportError(null, ex);
            }
        }
    }

    private ReferenceIterator getClassReferences(JavaClass thisJavaClass) {
        LinkedList<Long> references = new LinkedList<Long>();
        try {
            this.addReferences(thisJavaClass.getObject(), references);
            this.addStaticReferences(thisJavaClass, references);
            this.addProtectionDomainReference(thisJavaClass, references);
            Iterator constantPoolIt = thisJavaClass.getConstantPoolReferences();
            while (constantPoolIt.hasNext()) {
                Object cpObject = constantPoolIt.next();
                if (!(cpObject instanceof JavaClass)) continue;
                JavaClass cpJavaClass = (JavaClass)cpObject;
                references.add(new Long(cpJavaClass.getObject().getID().getAddress()));
            }
            for (JavaClass superClass = thisJavaClass.getSuperclass(); null != superClass; superClass = superClass.getSuperclass()) {
                references.add(new Long(superClass.getObject().getID().getAddress()));
            }
            JavaClassLoader loader = thisJavaClass.getClassLoader();
            if (loader != null) {
                JavaObject loaderObject = loader.getObject();
                if (loaderObject != null) {
                    references.add(new Long(loaderObject.getID().getAddress()));
                } else {
                    this.reportError("Null loader object returned for class: " + thisJavaClass.getName() + "(" + thisJavaClass.getID() + ")", null);
                    ++this._numberOfErrors;
                }
            } else {
                this.reportError("Null classloader returned for class: " + thisJavaClass.getName() + "(" + thisJavaClass.getID() + ")", null);
                ++this._numberOfErrors;
            }
        }
        catch (DTFJException ex) {
            this.reportError(null, ex);
            ++this._numberOfErrors;
        }
        return new LongListReferenceIterator(references);
    }

    private void addProtectionDomainReference(JavaClass thisJavaClass, List references) throws CorruptDataException, MemoryAccessException {
        try {
            JavaObject protectionDomain = thisJavaClass.getProtectionDomain();
            if (protectionDomain != null) {
                references.add(new Long(protectionDomain.getID().getAddress()));
            }
        }
        catch (DataUnavailable e) {
            ++this.pdSkipCount;
        }
    }

    private void addStaticReferences(JavaClass thisClass, List references) throws CorruptDataException, MemoryAccessException {
        Iterator fieldsIt = thisClass.getDeclaredFields();
        while (fieldsIt.hasNext()) {
            Object potential = fieldsIt.next();
            if (potential instanceof CorruptData) {
                this.reportError("Corrupt field found in class " + thisClass.getName() + "(" + thisClass.getID() + ") at " + ((CorruptData)potential).getAddress(), null);
                ++this._numberOfErrors;
                continue;
            }
            JavaField field = (JavaField)potential;
            if (!Modifier.isStatic(field.getModifiers())) continue;
            Object referent = field.get(thisClass.getObject());
            if (referent instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("Corrupt referent found in class " + thisClass.getName() + "(" + thisClass.getID() + ") from field " + field.getName() + " at address " + ((CorruptData)potential).getAddress(), null);
                continue;
            }
            if (referent instanceof JavaObject) {
                JavaObject referredObject = (JavaObject)referent;
                references.add(new Long(referredObject.getID().getAddress()));
                continue;
            }
            if (referent == null) {
                references.add(new Long(0L));
                continue;
            }
            if (referent instanceof Number || referent instanceof Boolean || referent instanceof Character) continue;
            this.reportError("Unexpected type: " + referent.getClass().getName() + " returned from field " + field.getName() + " from class " + thisClass.getName() + "(" + thisClass.getID() + ")", null);
            ++this._numberOfErrors;
        }
    }

    private ReferenceIterator getObjectReferences(JavaObject thisObject) {
        LinkedList<Long> references = new LinkedList<Long>();
        try {
            this.addReferences(thisObject, references);
            if (thisObject.getJavaClass().isArray()) {
                Long[] refsAsArray = references.toArray(new Long[0]);
                references.clear();
                if (thisObject.isPacked() && refsAsArray.length > 0) {
                    references.add(refsAsArray[0]);
                    for (int i = refsAsArray.length - 1; i >= 1; --i) {
                        references.add(refsAsArray[i]);
                    }
                } else {
                    for (int i = refsAsArray.length - 1; i >= 0; --i) {
                        references.add(refsAsArray[i]);
                    }
                }
            }
        }
        catch (DTFJException ex) {
            ++this._numberOfErrors;
            this.reportError(null, ex);
        }
        return new LongListReferenceIterator(references);
    }

    private void addReferences(JavaObject object, List<Long> references) throws CorruptDataException, MemoryAccessException {
        Iterator it = object.getReferences();
        Object ref = null;
        if (it.hasNext()) {
            ref = it.next();
        }
        while (it.hasNext()) {
            Object target;
            ref = it.next();
            if (ref instanceof CorruptData) {
                ++this._numberOfErrors;
                this.reportError("Corrupt data found at address " + ((CorruptData)ref).getAddress() + " getting references from object at address: " + Long.toHexString(object.getID().getAddress()) + " of class " + object.getJavaClass().getName() + "(" + object.getJavaClass().getID() + ")", null);
                continue;
            }
            if (!(ref instanceof JavaReference)) {
                ++this._numberOfErrors;
                this.reportError("Object of unexpected type " + ref.getClass() + " found within references from object at address: " + object.getID().getAddress() + " of class " + object.getJavaClass().getName() + "(" + object.getJavaClass().getID() + ")", null);
                continue;
            }
            try {
                target = ((JavaReference)ref).getTarget();
            }
            catch (DataUnavailable e) {
                ++this._numberOfErrors;
                this.reportError("DataUnavailable thrown from call to getTarget() on reference: " + ref, null);
                continue;
            }
            if (target instanceof JavaObject) {
                references.add(new Long(((JavaObject)target).getID().getAddress()));
                continue;
            }
            if (target instanceof JavaClass) {
                references.add(new Long(((JavaClass)target).getID().getAddress()));
                continue;
            }
            ++this._numberOfErrors;
            this.reportError("Object of unexpected type " + target.getClass() + " returned from call to getTarget() on reference " + ref, null);
        }
    }

    private static boolean isPrimitive(JavaClass clazz) throws CorruptDataException {
        String name = clazz.getName();
        if (name.indexOf("/") != -1) {
            return false;
        }
        for (int i = 0; i != PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private int getPrimitiveTypeCode(JavaClass clazz) throws CorruptDataException {
        String name = clazz.getName();
        for (int i = 0; i != PRIMITIVE_TYPES.length; ++i) {
            if (!PRIMITIVE_TYPES[i].equals(name)) continue;
            return i;
        }
        throw new IllegalArgumentException("Class: " + name + " is not primitive");
    }

    private HeapDumpFormatter getFormatter(String fileName, String version, boolean is64Bit, boolean phdFormat) throws IOException {
        if (phdFormat) {
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            return new PortableHeapDumpFormatter(dos, version, is64Bit, this._is32BitHash);
        }
        return new ClassicHeapDumpFormatter(new FileWriter(fileName), version, is64Bit);
    }

    private String getFileNameForHeap(JavaHeap thisHeap, String baseFileName) {
        int pointIndex = baseFileName.lastIndexOf(".");
        if (pointIndex != -1) {
            return baseFileName.substring(0, pointIndex) + "." + thisHeap.getName() + baseFileName.substring(pointIndex);
        }
        return baseFileName + "." + thisHeap.getName();
    }

    private void reportError(String msg, Throwable t) {
        if (!this._verbose) {
            return;
        }
        if (msg != null) {
            this.out.println(msg);
        }
        if (t != null) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            this.out.println(writer.toString());
        }
    }

    @Override
    public void printDetailedHelp(PrintStream out) {
        out.println(LONG_DESCRIPTION);
    }
}

