/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.dtfjview.commands.infocommands;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.java.diagnostics.utils.IContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.DTFJPlugin;
import com.ibm.jvm.dtfjview.commands.BaseJdmpviewCommand;
import com.ibm.jvm.dtfjview.commands.helpers.Exceptions;
import java.io.PrintStream;
import java.util.Iterator;

@DTFJPlugin(version="1.*", runtime=false)
public class InfoSymCommand
extends BaseJdmpviewCommand {
    protected static final String longDesc = "parameters: none, module name\n\nif no parameters are passed then for each process in the address spaces, outputs a list of module sections for each module with their start and end addresses, names, and sizes\nif a module name is passed then it outputs the above information for that module plus a list of all the known symbols for that module. Module names can be specified with leading or trailing * characters to save specifying full paths or remembering what file extension is used on this platform. e.g. info mod *libzip* info mod * will all modules with sections and symbols.";

    public InfoSymCommand() {
        this.addCommand("info sym", "", "an alias for 'mod'");
        this.addCommand("info mod", "", "outputs module information");
    }

    public void run(String command, String[] args, IContext context, PrintStream out) throws CommandException {
        if (this.initCommand(command, args, context, out)) {
            return;
        }
        switch (args.length) {
            case 0: {
                this.listModules(null);
                break;
            }
            case 1: {
                this.listModules(args[0]);
                break;
            }
            default: {
                out.println("\"info sym\" command takes either 0 or 1 parameters");
            }
        }
    }

    private void listModules(String moduleName) {
        Iterator iLibs;
        ImageProcess ip = this.ctx.getProcess();
        try {
            ImageModule e = ip.getExecutable();
            if (e instanceof ImageModule) {
                ImageModule exe = e;
                if (moduleName != null) {
                    if (this.checkModuleName(exe.getName(), moduleName)) {
                        this.printModule(exe, true);
                    }
                } else {
                    this.printModule(exe, false);
                }
            } else if (e instanceof CorruptData) {
                CorruptData corruptObj = (CorruptData)e;
                this.out.print("\t  <corrupt executable encountered: " + corruptObj.toString() + ">\n\n");
            }
        }
        catch (DataUnavailable e) {
            this.out.println(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException e) {
            this.out.println(Exceptions.getCorruptDataExceptionString());
        }
        try {
            iLibs = ip.getLibraries();
        }
        catch (DataUnavailable du) {
            iLibs = null;
            this.out.println(Exceptions.getDataUnavailableString());
        }
        catch (CorruptDataException cde) {
            iLibs = null;
            this.out.println(Exceptions.getCorruptDataExceptionString());
        }
        while (null != iLibs && iLibs.hasNext()) {
            Object next = iLibs.next();
            if (next instanceof ImageModule) {
                ImageModule mod = (ImageModule)next;
                String currentName = null;
                try {
                    currentName = mod.getName();
                }
                catch (CorruptDataException e) {
                    this.out.print("\t  <corrupt library name: " + mod.toString() + ">\n\n");
                }
                if (moduleName != null) {
                    if (!this.checkModuleName(currentName, moduleName)) continue;
                    this.printModule(mod, true);
                    continue;
                }
                this.printModule(mod, false);
                continue;
            }
            if (next instanceof CorruptData) {
                CorruptData corruptObj = (CorruptData)next;
                this.out.print("\t  <corrupt library encountered: " + corruptObj.toString() + ">\n\n");
                continue;
            }
            this.out.print("\t  <corrupt library encountered>\n\n");
        }
    }

    private void printModule(ImageModule imageModule, boolean printSymbols) {
        try {
            this.out.print("\t  " + imageModule.getName());
        }
        catch (CorruptDataException cde) {
            this.out.print("\t  " + Exceptions.getCorruptDataExceptionString());
        }
        try {
            String addressInHex = String.format("0x%x", imageModule.getLoadAddress());
            this.out.print(" @ " + addressInHex);
        }
        catch (DataUnavailable e) {
        }
        catch (CorruptDataException e) {
            // empty catch block
        }
        Iterator itSection = imageModule.getSections();
        if (itSection.hasNext()) {
            this.out.print(", sections:\n");
        } else {
            this.out.print(", <no section information>\n");
        }
        while (itSection.hasNext()) {
            Object next = itSection.next();
            if (next instanceof ImageSection) {
                ImageSection is = (ImageSection)next;
                this.out.print("\t   0x" + Long.toHexString(is.getBaseAddress().getAddress()) + " - 0x" + Long.toHexString(is.getBaseAddress().getAddress() + is.getSize()));
                this.out.print(", name: \"");
                this.out.print(is.getName());
                this.out.print("\", size: 0x");
                this.out.print(Long.toHexString(is.getSize()));
                this.out.print("\n");
                continue;
            }
            if (next instanceof CorruptData) {
                this.out.print("\t   <corrupt section encountered>\n");
                continue;
            }
            this.out.print("\t   <corrupt section encountered>\n");
        }
        if (printSymbols) {
            this.out.print("\t  symbols:\n");
            Iterator itSymbols = imageModule.getSymbols();
            while (itSymbols.hasNext()) {
                Object next = itSymbols.next();
                if (next instanceof ImageSymbol) {
                    ImageSymbol is = (ImageSymbol)next;
                    this.out.print("\t   0x" + Long.toHexString(is.getAddress().getAddress()));
                    this.out.print(", name: \"");
                    this.out.print(is.getName());
                    this.out.print("\"\n");
                    continue;
                }
                if (next instanceof CorruptData) {
                    this.out.print("\t   <corrupt symbol encountered>\n");
                    continue;
                }
                this.out.print("\t   <corrupt symbol encountered>\n");
            }
        }
        this.out.print("\n");
    }

    private boolean checkModuleName(String name, String moduleName) {
        boolean wildCardStart = false;
        boolean wildCardEnd = false;
        if ((moduleName = moduleName.trim()).startsWith("*")) {
            wildCardStart = true;
            if ((moduleName = moduleName.substring(1)).length() == 0) {
                wildCardEnd = true;
            }
        }
        if (moduleName.endsWith("*")) {
            wildCardEnd = true;
            moduleName = moduleName.substring(0, moduleName.length() - 1);
        }
        if (!wildCardStart && !wildCardEnd && moduleName.equals(name)) {
            return true;
        }
        if (wildCardStart && !wildCardEnd && name.endsWith(moduleName)) {
            return true;
        }
        if (!wildCardStart && wildCardEnd && name.startsWith(moduleName)) {
            return true;
        }
        return wildCardStart && wildCardEnd && name.indexOf(moduleName) >= 0;
    }

    public void printDetailedHelp(PrintStream out) {
        out.println(longDesc);
    }
}

