/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import java.io.IOException;
import java.math.BigInteger;

public final class TCPMsgRfc2510PartialMsgRep {
    BigInteger pollingRef;
    BigInteger timeToCheckBack;
    private byte[] pkiMsg;

    public TCPMsgRfc2510PartialMsgRep(BigInteger bigInteger, BigInteger bigInteger2, byte[] byArray) {
        if (bigInteger == null) {
            throw new IllegalArgumentException("TCPMsgRfc2510PartialMsgRep error : polling reference not specified");
        }
        if (bigInteger2 == null) {
            throw new IllegalArgumentException("TCPMsgRfc2510PartialMsgRep error : time-to-check-back not specified");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("TCPMsgRfc2510PartialMsgRep error : PKIMessage not specified");
        }
        this.pollingRef = bigInteger;
        this.timeToCheckBack = bigInteger2;
        this.pkiMsg = byArray;
    }

    public TCPMsgRfc2510PartialMsgRep(byte[] byArray) throws IOException {
        this.parse(byArray);
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[this.pkiMsg.length + 8];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = 0;
            ++n;
        }
        byte[] byArray2 = this.pollingRef.toByteArray();
        if (byArray2.length < 4) {
            System.arraycopy(byArray2, 0, byArray, 4 - byArray2.length, byArray2.length);
        } else {
            System.arraycopy(byArray2, byArray2.length - 4, byArray, 0, 4);
        }
        byArray2 = this.timeToCheckBack.toByteArray();
        if (byArray2.length < 4) {
            System.arraycopy(byArray2, 0, byArray, 8 - byArray2.length, byArray2.length);
        } else {
            System.arraycopy(byArray2, byArray2.length - 4, byArray, 4, 4);
        }
        System.arraycopy(this.pkiMsg, 0, byArray, 8, this.pkiMsg.length);
        return byArray;
    }

    public byte[] getPkiMessage() {
        if (this.pkiMsg == null) {
            return null;
        }
        return (byte[])this.pkiMsg.clone();
    }

    public BigInteger getPollingReference() {
        return this.pollingRef;
    }

    public BigInteger getTimeToCheckBack() {
        return this.timeToCheckBack;
    }

    private void parse(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IOException("TCPMsgPollRep error : value not specified");
        }
        if (byArray.length < 8) {
            throw new IOException("TCPMsgPollRep error : invalid input");
        }
        this.pkiMsg = null;
        this.pollingRef = null;
        this.timeToCheckBack = null;
        byte[] byArray2 = new byte[4];
        System.arraycopy(byArray, 0, byArray2, 0, 4);
        this.pollingRef = new BigInteger(1, byArray2);
        System.arraycopy(byArray, 4, byArray2, 0, 4);
        this.timeToCheckBack = new BigInteger(1, byArray2);
        byArray2 = new byte[byArray.length - 8];
        System.arraycopy(byArray, 8, byArray2, 0, byArray2.length);
        this.pkiMsg = byArray2;
    }

    public String toString() {
        String string = "\r\nPartialMsgRep";
        return string;
    }
}

