/*
 * Decompiled with CFR 0.152.
 */
package com.sun.script.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import javax.script.Invocable;
import javax.script.ScriptException;
import sun.reflect.misc.ReflectUtil;

public class InterfaceImplementor {
    private Invocable engine;

    public InterfaceImplementor(Invocable invocable) {
        this.engine = invocable;
    }

    public <T> T getInterface(Object object, Class<T> clazz) throws ScriptException {
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface Class expected");
        }
        if (!this.isImplemented(object, clazz)) {
            return null;
        }
        if (System.getSecurityManager() != null && !Modifier.isPublic(clazz.getModifiers())) {
            throw new SecurityException("attempt to implement non-public interface");
        }
        ReflectUtil.checkPackageAccess(clazz.getName());
        AccessControlContext accessControlContext = AccessController.getContext();
        return clazz.cast(Proxy.newProxyInstance(InterfaceImplementor.getLoaderForProxy(clazz), new Class[]{clazz}, (InvocationHandler)new InterfaceImplementorInvocationHandler(object, accessControlContext)));
    }

    protected boolean isImplemented(Object object, Class<?> clazz) {
        return true;
    }

    protected Object convertResult(Method method, Object object) throws ScriptException {
        return object;
    }

    protected Object[] convertArguments(Method method, Object[] objectArray) throws ScriptException {
        return objectArray;
    }

    private static ClassLoader getLoaderForProxy(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private final class InterfaceImplementorInvocationHandler
    implements InvocationHandler {
        private Object thiz;
        private AccessControlContext accCtxt;

        public InterfaceImplementorInvocationHandler(Object object, AccessControlContext accessControlContext) {
            this.thiz = object;
            this.accCtxt = accessControlContext;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            objectArray = InterfaceImplementor.this.convertArguments(method, objectArray);
            final Method method2 = method;
            final Object[] objectArray2 = objectArray;
            Object object2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (InterfaceImplementorInvocationHandler.this.thiz == null) {
                        return InterfaceImplementor.this.engine.invokeFunction(method2.getName(), objectArray2);
                    }
                    return InterfaceImplementor.this.engine.invokeMethod(InterfaceImplementorInvocationHandler.this.thiz, method2.getName(), objectArray2);
                }
            }, this.accCtxt);
            return InterfaceImplementor.this.convertResult(method, object2);
        }
    }
}

