/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.securerandom.provider;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandomSpi;

public final class SecureRandom
extends SecureRandomSpi
implements Serializable {
    static final long serialVersionUID = -3821368229687533162L;
    private transient MessageDigest sha1;
    private static SecureRandom seedGenerator;
    private BigInteger P64;
    private int[] syms = new int[16];
    private byte[] sbuf = new byte[256];
    private byte[] rngTestBuf = null;
    private long accu = 0L;
    private boolean firstTrng = true;
    private boolean extSeeded = false;
    private long rngTest = 0L;
    private int bits = 0;
    private int nsam = 64;
    private static final short[] logtab;
    byte[] state = new byte[85];
    private static final String[] z;

    public SecureRandom() {
        this.a(null);
    }

    public SecureRandom(byte[] byArray) {
        this.a(byArray);
    }

    private void a(byte[] byArray) {
        byte[] byArray2 = new byte[9];
        try {
            this.sha1 = MessageDigest.getInstance(z[1]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(z[0]);
        }
        byArray2[0] = 1;
        byArray2[8] = 13;
        this.P64 = new BigInteger(1, byArray2);
        SecureRandom.a(128, this.state, 49);
        SecureRandom.a(30, this.state, 53);
        if (byArray != null) {
            this.engineSetSeed(byArray);
        }
    }

    public synchronized void engineSetSeed(byte[] byArray) {
        this.b(byArray);
    }

    protected synchronized void b(byte[] byArray) {
        if (byArray != null) {
            int n = 0;
            int n2 = byArray.length;
            if (n2 > 40) {
                MessageDigest messageDigest;
                byte[] byArray2 = new byte[20];
                try {
                    messageDigest = MessageDigest.getInstance(z[1]);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException(z[0]);
                }
                messageDigest.update(byArray, 0, byArray.length);
                byArray2 = messageDigest.digest();
                n2 = 20;
                byArray = this.state;
                n = 65;
                System.arraycopy(byArray2, 0, this.state, 65, n2);
            }
            while (--n2 >= 0) {
                int n3 = 25 + n2 % 20;
                this.state[n3] = (byte)(this.state[n3] ^ byArray[n + n2]);
            }
            if (this.state[0] == 0) {
                this.state[0] = 25;
            }
            this.extSeeded = true;
        }
    }

    public synchronized void engineNextBytes(byte[] byArray) {
        this.c(byArray);
    }

    protected synchronized void c(byte[] byArray) {
        this.b(byArray, 0, byArray.length);
    }

    public byte[] engineGenerateSeed(int n) {
        return this.a(n);
    }

    protected byte[] a(int n) {
        byte[] byArray = new byte[n];
        this.b(byArray, 0, byArray.length);
        return byArray;
    }

    private int a() {
        int n;
        while (this.bits == 0) {
            BigInteger bigInteger;
            long l;
            this.accu = 0L;
            int n2 = 0;
            do {
                this.syms[n2] = 0;
            } while (++n2 < 16);
            int n3 = this.sbuf.length - 1;
            int n4 = 0;
            n = 0;
            int n5 = 0;
            int n6 = 0;
            while (true) {
                int n7 = 0;
                do {
                    l = System.currentTimeMillis();
                    while (l == System.currentTimeMillis()) {
                        ++n7;
                    }
                } while (n7 == 0);
                this.sbuf[n3] = (byte)(this.sbuf[n3] << 4 | n7 % 16);
                n3 -= n4;
                n4 ^= 1;
                if ((n6 - n7) * (n6 - n7) != 1) {
                    n6 = n7;
                }
                int n8 = n6 % 16;
                this.syms[n8] = this.syms[n8] + n;
                n |= 1;
                if (n3 < 0) {
                    bigInteger = new BigInteger(1, this.sbuf);
                    this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue();
                    n3 += this.sbuf.length;
                    n = 0;
                }
                if (++n5 < this.nsam) continue;
                n2 = 0;
                int n9 = 0;
                int n10 = SecureRandom.b(n5);
                do {
                    n = this.syms[n2];
                    n9 += n * (n10 - SecureRandom.b(n));
                } while (++n2 < 16);
                this.nsam = 96000 * n5 / n9;
                if (this.nsam <= n5) break;
                this.nsam = n9 > n5 ? this.nsam + 3 : n5 + 32;
                n = 0;
            }
            bigInteger = new BigInteger(1, this.sbuf);
            this.accu ^= bigInteger.multiply(bigInteger).remainder(this.P64).longValue() ^ l;
            this.bits = 64;
            if (this.firstTrng) {
                this.firstTrng = false;
                this.rngTest = this.accu;
                this.accu = 0L;
                this.bits = 0;
                continue;
            }
            if (this.accu != this.rngTest) continue;
            throw new RuntimeException(z[2]);
        }
        n = (int)(this.accu & 0xFFL);
        this.accu >>>= 8;
        this.bits -= 8;
        return n;
    }

    private void a(byte[] byArray, int n, int n2) {
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[n2];
        if (seedGenerator == null) {
            int n3 = n2;
            while (--n3 >= 0) {
                int n4 = 25 + n3 % 20;
                byArray2[n4] = (byte)(byArray2[n4] ^ this.a());
            }
            System.arraycopy(byArray2, 25, byArray3, 0, n2);
            seedGenerator = new SecureRandom(byArray3);
        }
        seedGenerator.engineNextBytes(byArray3);
        System.arraycopy(byArray3, 0, byArray2, 25, n2);
        long l = (long)SecureRandom.a(byArray2, 53) * 1000L + System.currentTimeMillis();
        SecureRandom.a((int)(l >>> 32), byArray2, 57);
        SecureRandom.a((int)l, byArray2, 61);
        if (byArray2[0] == 0) {
            byArray2[0] = 25;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void b(byte[] byArray, int n, int n2) {
        int n3;
        byte[] byArray2 = this.state;
        byte[] byArray3 = new byte[64];
        byte[] byArray4 = new byte[20];
        byte[] byArray5 = null;
        int n4 = 160;
        while ((n3 = byArray2[0]) == 0) {
            this.a(null, 0, 20);
        }
        block5: while (true) {
            if (--n2 < 0) {
                byArray2[0] = (byte)n3;
                return;
            }
            while (true) {
                boolean bl;
                int n5;
                int n6;
                int n7;
                if (n3 == 25 || this.rngTestBuf == null) {
                    int n8 = SecureRandom.a(byArray2, 49);
                    if (n8 > 0 && !this.extSeeded) {
                        long l = ((long)SecureRandom.a(byArray2, 57) << 32) + ((long)SecureRandom.a(byArray2, 61) & 0xFFFFFFFFL);
                        n7 = SecureRandom.a(byArray2, 45);
                        n6 = n7 + 20;
                        if (n6 < n7) {
                            n7 = 0;
                            n6 = 0 + 20;
                        }
                        SecureRandom.a(n6, byArray2, 45);
                        n7 += n8 - n7 % n8;
                        while (n7 < n6) {
                            byte[] byArray6 = this.sbuf;
                            // MONITORENTER : this.sbuf
                            if (this.bits > 0 || System.currentTimeMillis() >= l) {
                                int n9 = 25 + n7 / n8 % 20;
                                byArray2[n9] = (byte)(byArray2[n9] ^ this.a());
                                l = (long)SecureRandom.a(byArray2, 53) * 1000L + System.currentTimeMillis();
                                SecureRandom.a((int)(l >>> 32), byArray2, 57);
                                SecureRandom.a((int)l, byArray2, 61);
                            }
                            // MONITOREXIT : byArray6
                            n7 += n8;
                        }
                    }
                    int n10 = 0;
                    for (n5 = 19; n5 >= 0; --n5) {
                        n10 = (n10 >> 8) + (byArray2[5 + n5] & 0xFF) + (byArray2[25 + n5] & 0xFF);
                        byArray4[n5] = (byte)n10;
                    }
                    for (n10 = 0; n10 < byArray3.length; ++n10) {
                        byArray3[n10] = 0;
                    }
                    System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
                    try {
                        byArray5 = this.sha1.digest(byArray3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    bl = true;
                    n7 = 256;
                } else {
                    byArray[n++] = byArray2[n3 + 60];
                    ++n3;
                    continue block5;
                }
                for (n6 = 19; n6 >= 0; bl &= n5 >= (n6 == 19 ? 209 : 255), --n6) {
                    n5 = byArray5[n6] & 0xFF;
                    n7 = (n7 >> 8) + n5 + (byArray2[5 + n6] & 0xFF);
                    byArray2[5 + n6] = (byte)n7;
                }
                if (bl) {
                    n5 = 12032;
                    for (n7 = 19; n7 >= 0; --n7) {
                        n5 = (n5 >> 8) + (byArray2[5 + n7] & 0xFF);
                        byArray2[5 + n7] = (byte)n5;
                    }
                }
                if (this.rngTestBuf != null) {
                    if (this.rngTestBuf.equals(byArray5)) {
                        throw new RuntimeException(z[2]);
                    }
                    System.arraycopy(byArray5, 0, this.rngTestBuf, 0, 20);
                    System.arraycopy(byArray5, 0, byArray2, 65, 20);
                    n3 = 5;
                    continue;
                }
                this.rngTestBuf = new byte[20];
                System.arraycopy(byArray5, 0, this.rngTestBuf, 0, 20);
                n3 = 25;
            }
            break;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.sha1 = MessageDigest.getInstance(z[1]);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(z[0]);
        }
    }

    private static final int b(int n) {
        int n2 = 6;
        if (n == 0) {
            return 0;
        }
        while (n < 64) {
            n <<= 1;
            --n2;
        }
        while (n >= 128) {
            n >>= 1;
            ++n2;
        }
        return n2 * 1000 + logtab[n & 0x3F];
    }

    static final int a(byte[] byArray, int n) {
        return byArray[n] << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static final void a(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[n2 + 1] = (byte)(n >>> 16);
        byArray[n2 + 2] = (byte)(n >>> 8);
        byArray[n2 + 3] = (byte)n;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block29: {
            int n;
            int n2;
            block28: {
                char[] cArray2;
                Object var0;
                block27: {
                    int n3;
                    block26: {
                        char[] cArray3;
                        block25: {
                            int n4;
                            block24: {
                                stringArray = new String[3];
                                var0 = null;
                                char[] cArray4 = "\ry\u0010[O ~\u0010IV$yBAN+{\u0010MB s@\\S,x\u0010\u0005\u001a\u0010^q\u0005\u000bm".toCharArray();
                                cArray3 = cArray4;
                                n4 = cArray4.length;
                                n2 = 0;
                                if (!true) break block24;
                                n4 = n4;
                                if (n4 <= n2) break block25;
                            }
                            do {
                                int n5;
                                cArray3 = cArray3;
                                int n6 = n2;
                                char c2 = cArray3[n6];
                                switch (n2 % 5) {
                                    case 0: {
                                        n5 = 67;
                                        break;
                                    }
                                    case 1: {
                                        n5 = 22;
                                        break;
                                    }
                                    case 2: {
                                        n5 = 48;
                                        break;
                                    }
                                    case 3: {
                                        n5 = 40;
                                        break;
                                    }
                                    default: {
                                        n5 = 58;
                                    }
                                }
                                cArray3[n6] = (char)(c2 ^ n5);
                                ++n2;
                                n4 = n4;
                            } while (n4 > n2);
                        }
                        stringArray[0] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray5 = "\u0010^q\u0005\u000b".toCharArray();
                        cArray2 = cArray5;
                        n3 = cArray5.length;
                        n2 = 0;
                        if (!true) break block26;
                        n3 = n3;
                        if (n3 <= n2) break block27;
                    }
                    do {
                        int n7;
                        cArray2 = cArray2;
                        int n8 = n2;
                        char c3 = cArray2[n8];
                        switch (n2 % 5) {
                            case 0: {
                                n7 = 67;
                                break;
                            }
                            case 1: {
                                n7 = 22;
                                break;
                            }
                            case 2: {
                                n7 = 48;
                                break;
                            }
                            case 3: {
                                n7 = 40;
                                break;
                            }
                            default: {
                                n7 = 58;
                            }
                        }
                        cArray2[n8] = (char)(c3 ^ n7);
                        ++n2;
                        n3 = n3;
                    } while (n3 > n2);
                }
                stringArray[1] = new String(cArray2).intern();
                var0 = null;
                char[] cArray6 = "\u0000y^\\S-yE[\u001a\u0011Xw\bN&eD\b\\\"\u007f\\M^m".toCharArray();
                cArray = cArray6;
                n = cArray6.length;
                n2 = 0;
                if (!true) break block28;
                n = n;
                if (n <= n2) break block29;
            }
            do {
                int n9;
                cArray = cArray;
                int n10 = n2;
                char c4 = cArray[n10];
                switch (n2 % 5) {
                    case 0: {
                        n9 = 67;
                        break;
                    }
                    case 1: {
                        n9 = 22;
                        break;
                    }
                    case 2: {
                        n9 = 48;
                        break;
                    }
                    case 3: {
                        n9 = 40;
                        break;
                    }
                    default: {
                        n9 = 58;
                    }
                }
                cArray[n10] = (char)(c4 ^ n9);
                ++n2;
                n = n;
            } while (n > n2);
        }
        stringArray[2] = new String(cArray).intern();
        z = stringArray;
        logtab = new short[]{0, 22, 44, 66, 87, 109, 129, 150, 170, 190, 209, 229, 248, 267, 285, 304, 322, 340, 358, 375, 392, 409, 426, 443, 459, 476, 492, 508, 524, 539, 555, 570, 585, 600, 615, 629, 644, 658, 672, 687, 700, 714, 728, 741, 755, 768, 781, 794, 807, 820, 833, 845, 858, 870, 883, 895, 907, 919, 931, 943, 954, 966, 977, 989};
    }
}

