/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.mbean;

import com.ibm.java.diagnostics.healthcenter.agent.mbean.AgentLogFactory;
import com.ibm.java.diagnostics.healthcenter.agent.mbean.Messages;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.logging.Logger;

public class NetworkAddressFinder {
    private final Logger logger;
    private static final String _127 = "127.";
    private String localAddress = null;
    private static final int NUM_CONNECTION_TYPES = 3;
    private static final String[][] INTERFACE_NAMES = new String[][]{{Messages.getString("NetworkAddressFinder.eth0"), Messages.getString("NetworkAddressFinder.eth1")}, {Messages.getString("NetworkAddressFinder.wlan0")}, {Messages.getString("NetworkAddressFinder.wc0")}};
    private String[] localAddresses = new String[3];

    public NetworkAddressFinder() {
        this.logger = AgentLogFactory.setUpLogging(this.getClass());
        this.findAllNetworkInterfaces();
        this.calculateLocalAddress();
    }

    private void findAllNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                this.doStuffWithInterface(networkInterface);
            }
        }
        catch (SocketException socketException) {
            socketException.printStackTrace();
        }
    }

    private void doStuffWithInterface(NetworkInterface networkInterface) {
        String string = networkInterface.getName();
        if (this.isLoopback(networkInterface)) {
            return;
        }
        int n = -1;
        for (int i = 0; i < INTERFACE_NAMES.length; ++i) {
            for (int j = 0; j < INTERFACE_NAMES[i].length; ++j) {
                if (!INTERFACE_NAMES[i][j].equals(string)) continue;
                n = i;
            }
        }
        if (n != -1) {
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
            while (enumeration.hasMoreElements()) {
                this.doStuffWithInetAddress(n, enumeration);
            }
        }
    }

    private void doStuffWithInetAddress(int n, Enumeration<InetAddress> enumeration) {
        InetAddress inetAddress = enumeration.nextElement();
        if (inetAddress instanceof Inet4Address) {
            String string;
            this.localAddresses[n] = string = inetAddress.getHostAddress();
        } else if (!(inetAddress instanceof Inet6Address)) {
            this.logger.warning(MessageFormat.format(Messages.getString("NetworkAddressFinder.unknown.address.class"), inetAddress.getClass()));
        }
    }

    private boolean isLoopback(NetworkInterface networkInterface) {
        return networkInterface.getName().startsWith(_127);
    }

    private void calculateLocalAddress() {
        for (int i = 0; i < this.localAddresses.length; ++i) {
            this.localAddress = this.localAddresses[i];
            if (this.localAddress == null) continue;
            return;
        }
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public boolean defaultAddressIsUnreliable() {
        boolean bl = false;
        if (!System.getProperty("os.name").contains("Windows")) {
            try {
                String string;
                InetAddress inetAddress = InetAddress.getLocalHost();
                if (inetAddress != null && (string = inetAddress.getHostAddress()) != null && string.startsWith(_127)) {
                    bl = true;
                }
            }
            catch (UnknownHostException unknownHostException) {
                bl = true;
            }
        }
        return bl;
    }
}

