/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.nativememory.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.nativememory.MemoryData;
import com.ibm.java.diagnostics.healthcenter.api.nativememory.NativeMemoryCategory;
import com.ibm.java.diagnostics.healthcenter.api.nativememory.NativeMemoryData;
import com.ibm.java.diagnostics.healthcenter.api.nativememory.impl.MemoryDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.nativememory.impl.NativeMemoryCategoryImpl;
import com.ibm.java.diagnostics.healthcenter.memory.MemoryLabels;
import java.util.Date;
import javax.management.Notification;

public class NativeMemoryDataImpl
extends HealthCenterDataImpl
implements NativeMemoryData {
    private Notification physicalMemoryNotify;
    private Notification freePhysicalMemoryNotify;
    private Notification virtualMemoryNotify;
    private Notification totalPhysicalMemoryNotify;
    private Notification privateMemoryNotify;

    public NativeMemoryDataImpl(Data data) {
        super(data);
    }

    @Override
    public MemoryData[] getProcessPhysical() {
        return this.getMemoryData(MemoryLabels.PHYSICAL_MEMORY_SIZE);
    }

    @Override
    public MemoryData[] getFreePhysicalMemory() {
        return this.getMemoryData(MemoryLabels.FREE_PYHSICAL_MEMORY_SIZE);
    }

    @Override
    public MemoryData[] getProcessPrivate() {
        return this.getMemoryData(MemoryLabels.PRIVATE_MEMORY_SIZE);
    }

    @Override
    public MemoryData[] getTotalPhysicalMemory() {
        return this.getMemoryData(MemoryLabels.TOTAL_PHYSICAL_MEMORY_SIZE);
    }

    @Override
    public MemoryData[] getProcessVirtual() {
        return this.getMemoryData(MemoryLabels.VIRTUAL_MEMORY_SIZE);
    }

    @Override
    public NativeMemoryCategory getNativeMemoryRoot() {
        Data[] dataArray;
        Data data = this.getJvmData().getTopLevelData(JVMLabels.MEMORY);
        Data data2 = data.getData(MemoryLabels.ALLOCATION_DEEP_LABEL);
        Data data3 = data.getData(MemoryLabels.ALLOCATION_SHALLOW_LABEL);
        Data data4 = data.getData(MemoryLabels.BYTES_DEEP_LABEL);
        Data data5 = data.getData(MemoryLabels.BYTES_SHALLOW_LABEL);
        NativeMemoryCategoryImpl nativeMemoryCategoryImpl = null;
        if (data2 != null && (dataArray = data2.getChildren()) != null) {
            for (Data data6 : dataArray) {
                TwoDimensionalDataImpl twoDimensionalDataImpl;
                if (!(data6 instanceof TwoDimensionalDataImpl) || (twoDimensionalDataImpl = (TwoDimensionalDataImpl)data6) == null || twoDimensionalDataImpl.getDataPoints().length <= 0) continue;
                String string = twoDimensionalDataImpl.getLabel();
                double d = twoDimensionalDataImpl.getLastDataPoint().getRawY();
                TwoDimensionalDataImpl twoDimensionalDataImpl2 = (TwoDimensionalDataImpl)data3.getData(string);
                double d2 = twoDimensionalDataImpl2.getLastDataPoint().getRawY();
                TwoDimensionalDataImpl twoDimensionalDataImpl3 = (TwoDimensionalDataImpl)data4.getData(string);
                double d3 = twoDimensionalDataImpl3.getLastDataPoint().getRawY();
                TwoDimensionalDataImpl twoDimensionalDataImpl4 = (TwoDimensionalDataImpl)data5.getData(string);
                double d4 = twoDimensionalDataImpl4.getLastDataPoint().getRawY();
                nativeMemoryCategoryImpl = new NativeMemoryCategoryImpl(string, (long)d, (long)d2, (long)d3, (long)d4, this);
                if (!twoDimensionalDataImpl.hasChildren()) continue;
                this.createChildren(twoDimensionalDataImpl, twoDimensionalDataImpl2, twoDimensionalDataImpl3, twoDimensionalDataImpl4, nativeMemoryCategoryImpl);
            }
        }
        return nativeMemoryCategoryImpl;
    }

    private void createChildren(TwoDimensionalDataImpl twoDimensionalDataImpl, TwoDimensionalDataImpl twoDimensionalDataImpl2, TwoDimensionalDataImpl twoDimensionalDataImpl3, TwoDimensionalDataImpl twoDimensionalDataImpl4, NativeMemoryCategoryImpl nativeMemoryCategoryImpl) {
        NativeMemoryCategoryImpl nativeMemoryCategoryImpl2 = null;
        for (DataBuilder dataBuilder : twoDimensionalDataImpl.getChildren()) {
            if (!(dataBuilder instanceof TwoDimensionalDataImpl)) continue;
            TwoDimensionalDataImpl twoDimensionalDataImpl5 = (TwoDimensionalDataImpl)dataBuilder;
            String string = twoDimensionalDataImpl5.getLabel();
            double d = twoDimensionalDataImpl5.getLastDataPoint().getRawY();
            TwoDimensionalDataImpl twoDimensionalDataImpl6 = (TwoDimensionalDataImpl)twoDimensionalDataImpl2.getData(string);
            double d2 = twoDimensionalDataImpl6.getLastDataPoint().getRawY();
            TwoDimensionalDataImpl twoDimensionalDataImpl7 = (TwoDimensionalDataImpl)twoDimensionalDataImpl3.getData(string);
            double d3 = twoDimensionalDataImpl7.getLastDataPoint().getRawY();
            TwoDimensionalDataImpl twoDimensionalDataImpl8 = (TwoDimensionalDataImpl)twoDimensionalDataImpl4.getData(string);
            double d4 = twoDimensionalDataImpl8.getLastDataPoint().getRawY();
            nativeMemoryCategoryImpl2 = new NativeMemoryCategoryImpl(string, (long)d, (long)d2, (long)d3, (long)d4, this);
            nativeMemoryCategoryImpl2.setParent(nativeMemoryCategoryImpl);
            nativeMemoryCategoryImpl.addChildren(nativeMemoryCategoryImpl2);
            if (!dataBuilder.hasChildren()) continue;
            this.createChildren(twoDimensionalDataImpl5, twoDimensionalDataImpl6, twoDimensionalDataImpl7, twoDimensionalDataImpl8, nativeMemoryCategoryImpl2);
        }
    }

    MemoryData[] getMemoryData(String string) {
        Data data = this.getJvmData().getTopLevelData(JVMLabels.MEMORY);
        DataPointBuilder[] dataPointBuilderArray = null;
        MemoryData[] memoryDataArray = new MemoryData[]{};
        if (data != null && (dataPointBuilderArray = this.getEventData(data, string)) != null) {
            memoryDataArray = new MemoryData[dataPointBuilderArray.length];
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray) {
                memoryDataArray[n] = new MemoryDataImpl(dataPointBuilder.getRawX(), dataPointBuilder.getRawY());
                ++n;
            }
        }
        return memoryDataArray;
    }

    @Override
    protected String getRecommendationLabel() {
        return MemoryLabels.RECOMMENDATION_LABEL;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.MEMORY;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    @Override
    public long getMaxFreePhysicalMemory() {
        return (long)this.getMaxData(JVMLabels.MEMORY, MemoryLabels.FREE_PYHSICAL_MEMORY_SIZE);
    }

    @Override
    public double getMeanFreePhysicalMemory() {
        return this.getMeanData(JVMLabels.MEMORY, MemoryLabels.FREE_PYHSICAL_MEMORY_SIZE);
    }

    @Override
    public long getMinFreePhysicalMemory() {
        return (long)this.getMinData(JVMLabels.MEMORY, MemoryLabels.FREE_PYHSICAL_MEMORY_SIZE);
    }

    @Override
    public long getMaxProcessPhysicalMemory() {
        return (long)this.getMaxData(JVMLabels.MEMORY, MemoryLabels.PHYSICAL_MEMORY_SIZE);
    }

    @Override
    public double getMeanProcessPhysicalMemory() {
        return this.getMeanData(JVMLabels.MEMORY, MemoryLabels.PHYSICAL_MEMORY_SIZE);
    }

    @Override
    public long getMinProcessPhysicalMemory() {
        return (long)this.getMinData(JVMLabels.MEMORY, MemoryLabels.PHYSICAL_MEMORY_SIZE);
    }

    @Override
    public long getMaxProcessPrivateMemory() {
        return (long)this.getMaxData(JVMLabels.MEMORY, MemoryLabels.PRIVATE_MEMORY_SIZE);
    }

    @Override
    public double getMeanProcessPrivateMemory() {
        return this.getMeanData(JVMLabels.MEMORY, MemoryLabels.PRIVATE_MEMORY_SIZE);
    }

    @Override
    public long getMinProcessPrivateMemory() {
        return (long)this.getMinData(JVMLabels.MEMORY, MemoryLabels.PRIVATE_MEMORY_SIZE);
    }

    @Override
    public long getMaxProcessVirtualMemory() {
        return (long)this.getMaxData(JVMLabels.MEMORY, MemoryLabels.VIRTUAL_MEMORY_SIZE);
    }

    @Override
    public double getMeanProcessVirtualMemory() {
        return this.getMeanData(JVMLabels.MEMORY, MemoryLabels.VIRTUAL_MEMORY_SIZE);
    }

    @Override
    public long getMinProcessVirtualMemory() {
        return (long)this.getMinData(JVMLabels.MEMORY, MemoryLabels.VIRTUAL_MEMORY_SIZE);
    }

    static /* synthetic */ long access$000(NativeMemoryDataImpl nativeMemoryDataImpl) {
        return nativeMemoryDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        Date physicalMemoryTime;
        Date freePhysicalMemoryTime;
        Date virtualMemoryTime;
        Date totalPhysicalMemoryTime;
        Date privateMemoryTime;
        long count = 0L;
        long delay = NativeMemoryDataImpl.access$000(NativeMemoryDataImpl.this);

        public Updater(long l) {
            if (l >= NativeMemoryDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.physicalMemoryTime = new Date();
                        this.freePhysicalMemoryTime = new Date();
                        this.virtualMemoryTime = new Date();
                        this.totalPhysicalMemoryTime = new Date();
                        this.privateMemoryTime = new Date();
                        if (NativeMemoryDataImpl.this.getProcessPhysical() != null && NativeMemoryDataImpl.this.getProcessPhysical().length > 0 && NativeMemoryDataImpl.this.getProcessPhysical()[NativeMemoryDataImpl.this.getProcessPhysical().length - 1].getTime() != this.physicalMemoryTime.getTime()) {
                            NativeMemoryDataImpl.this.physicalMemoryNotify = new Notification(null, NativeMemoryDataImpl.this, this.count++);
                            NativeMemoryDataImpl.this.physicalMemoryNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.nativememory.PhysicalMemoryData");
                            NativeMemoryDataImpl.this.sendNotification(NativeMemoryDataImpl.this.physicalMemoryNotify);
                        }
                        if (NativeMemoryDataImpl.this.getFreePhysicalMemory() != null && NativeMemoryDataImpl.this.getFreePhysicalMemory().length > 0 && NativeMemoryDataImpl.this.getFreePhysicalMemory()[NativeMemoryDataImpl.this.getFreePhysicalMemory().length - 1].getTime() != this.freePhysicalMemoryTime.getTime()) {
                            NativeMemoryDataImpl.this.freePhysicalMemoryNotify = new Notification(null, NativeMemoryDataImpl.this, this.count++);
                            NativeMemoryDataImpl.this.freePhysicalMemoryNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.nativememory.FreePhysicalMemoryData");
                            NativeMemoryDataImpl.this.sendNotification(NativeMemoryDataImpl.this.freePhysicalMemoryNotify);
                        }
                        if (NativeMemoryDataImpl.this.getTotalPhysicalMemory() != null && NativeMemoryDataImpl.this.getTotalPhysicalMemory().length > 0 && NativeMemoryDataImpl.this.getTotalPhysicalMemory()[NativeMemoryDataImpl.this.getTotalPhysicalMemory().length - 1].getTime() != this.totalPhysicalMemoryTime.getTime()) {
                            NativeMemoryDataImpl.this.totalPhysicalMemoryNotify = new Notification(null, NativeMemoryDataImpl.this, this.count++);
                            NativeMemoryDataImpl.this.totalPhysicalMemoryNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.nativememory.TotalPhysicalMemoryData");
                            NativeMemoryDataImpl.this.sendNotification(NativeMemoryDataImpl.this.totalPhysicalMemoryNotify);
                        }
                        if (NativeMemoryDataImpl.this.getProcessPrivate() != null && NativeMemoryDataImpl.this.getProcessPrivate().length > 0 && NativeMemoryDataImpl.this.getProcessPrivate()[NativeMemoryDataImpl.this.getProcessPrivate().length - 1].getTime() != this.privateMemoryTime.getTime()) {
                            NativeMemoryDataImpl.this.privateMemoryNotify = new Notification(null, NativeMemoryDataImpl.this, this.count++);
                            NativeMemoryDataImpl.this.privateMemoryNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.nativememory.PrivateMemoryData");
                            NativeMemoryDataImpl.this.sendNotification(NativeMemoryDataImpl.this.privateMemoryNotify);
                        }
                        if (NativeMemoryDataImpl.this.getProcessVirtual() != null && NativeMemoryDataImpl.this.getProcessVirtual().length > 0 && NativeMemoryDataImpl.this.getProcessVirtual()[NativeMemoryDataImpl.this.getProcessVirtual().length - 1].getTime() != this.virtualMemoryTime.getTime()) {
                            NativeMemoryDataImpl.this.virtualMemoryNotify = new Notification(null, NativeMemoryDataImpl.this, this.count++);
                            NativeMemoryDataImpl.this.virtualMemoryNotify.setUserData("com.ibm.java.diagnostics.healthcenter.api.nativememory.VirtualMemoryData");
                            NativeMemoryDataImpl.this.sendNotification(NativeMemoryDataImpl.this.virtualMemoryNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

