/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.api.profiling.impl;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.api.impl.HealthCenterDataImpl;
import com.ibm.java.diagnostics.healthcenter.api.profiling.MethodProfileData;
import com.ibm.java.diagnostics.healthcenter.api.profiling.ProfilingData;
import com.ibm.java.diagnostics.healthcenter.api.profiling.impl.MethodProfileDataImpl;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingLabels;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingTableDataImpl;
import com.ibm.java.diagnostics.healthcenter.profiling.ProfilingTableRow;
import java.util.Date;
import javax.management.Notification;

public class ProfilingDataImpl
extends HealthCenterDataImpl
implements ProfilingData {
    private Notification profileNotify;

    public ProfilingDataImpl(Data data) {
        super(data);
    }

    @Override
    public MethodProfileData[] getProfilingEvents() {
        MethodProfileData[] methodProfileDataArray = new MethodProfileData[]{};
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)this.getJvmData().getTopLevelData(JVMLabels.PROFILING);
        ProfilingTableDataImpl profilingTableDataImpl = (ProfilingTableDataImpl)subsystemDataBuilder.getData(ProfilingLabels.PROFILE_TABLE);
        ProfilingTableRow[] profilingTableRowArray = null;
        if (profilingTableDataImpl != null) {
            profilingTableRowArray = profilingTableDataImpl.getContents();
        }
        if (profilingTableRowArray != null) {
            methodProfileDataArray = new MethodProfileData[profilingTableRowArray.length];
            int n = 0;
            for (ProfilingTableRow profilingTableRow : profilingTableRowArray) {
                methodProfileDataArray[n] = new MethodProfileDataImpl(this.getJvmData(), profilingTableRow.getMethodName(), profilingTableRow.getMethodId(), profilingTableRow.getCumulativePercentage(), profilingTableRow.getPercentage(), profilingTableRow.getSampleCount());
                ++n;
            }
        }
        return methodProfileDataArray;
    }

    @Override
    protected String getRecommendationLabel() {
        return ProfilingLabels.PROFILE_INTERPRETATION;
    }

    @Override
    protected String getSubsystemLabel() {
        return JVMLabels.PROFILING;
    }

    @Override
    public void startNotifying() {
        this.startNotifying(this.DEFAULT_NOTIFICATION);
    }

    @Override
    public void startNotifying(long l) {
        new Updater(l).start();
    }

    static /* synthetic */ long access$000(ProfilingDataImpl profilingDataImpl) {
        return profilingDataImpl.DEFAULT_NOTIFICATION;
    }

    private class Updater
    extends Thread {
        Date profileTime;
        long count = 0L;
        long delay = ProfilingDataImpl.access$000(ProfilingDataImpl.this);

        public Updater(long l) {
            if (l >= ProfilingDataImpl.this.DEFAULT_NOTIFICATION) {
                this.delay = l;
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.profileTime = new Date();
                        if (ProfilingDataImpl.this.getProfilingEvents() != null && ProfilingDataImpl.this.getProfilingEvents().length > 0 && ProfilingDataImpl.this.getProfilingEvents()[ProfilingDataImpl.this.getProfilingEvents().length - 1].getMethodProfileTimes()[ProfilingDataImpl.this.getProfilingEvents()[ProfilingDataImpl.this.getProfilingEvents().length - 1].getMethodProfileTimes().length - 1].getTime() != this.profileTime.getTime()) {
                            ProfilingDataImpl.this.profileNotify = new Notification(null, ProfilingDataImpl.this, this.count++);
                            ProfilingDataImpl.this.profileNotify.setUserData("com.ibm.java.diagonstics.healthcenter.api.profiling.ProfileData");
                            ProfilingDataImpl.this.sendNotification(ProfilingDataImpl.this.profileNotify);
                        }
                        Thread.sleep(this.delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, interruptedException);
                    continue;
                }
                break;
            }
        }
    }
}

